/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.config;

import io.appulse.encon.config.ServerPortGenerator;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class ServerConfig {
    private Integer port;
    private Integer bossThreads;
    private Integer workerThreads;

    static ServerConfig newInstance(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map is marked @NonNull but is null");
        }
        ServerConfigBuilder builder = ServerConfig.builder();
        Optional.ofNullable(map.get("port")).map(Object::toString).map(Integer::parseInt).ifPresent(builder::port);
        Optional.ofNullable(map.get("boss-threads")).map(Object::toString).map(Integer::parseInt).ifPresent(builder::bossThreads);
        Optional.ofNullable(map.get("worker-threads")).map(Object::toString).map(Integer::parseInt).ifPresent(builder::workerThreads);
        return builder.build();
    }

    public ServerConfig(ServerConfig serverConfig) {
        this.port = serverConfig.getPort();
        this.bossThreads = serverConfig.getBossThreads();
        this.workerThreads = serverConfig.getWorkerThreads();
    }

    ServerConfig withDefaultsFrom(@NonNull ServerConfig defaults) {
        if (defaults == null) {
            throw new NullPointerException("defaults is marked @NonNull but is null");
        }
        this.port = Optional.ofNullable(this.port).orElse(ServerPortGenerator.nextPort());
        this.bossThreads = Optional.ofNullable(this.bossThreads).orElse(defaults.getBossThreads());
        this.workerThreads = Optional.ofNullable(this.workerThreads).orElse(defaults.getWorkerThreads());
        return this;
    }

    public static ServerConfigBuilder builder() {
        return new ServerConfigBuilder();
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getBossThreads() {
        return this.bossThreads;
    }

    public Integer getWorkerThreads() {
        return this.workerThreads;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setBossThreads(Integer bossThreads) {
        this.bossThreads = bossThreads;
    }

    public void setWorkerThreads(Integer workerThreads) {
        this.workerThreads = workerThreads;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerConfig)) {
            return false;
        }
        ServerConfig other = (ServerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$bossThreads = this.getBossThreads();
        Integer other$bossThreads = other.getBossThreads();
        if (this$bossThreads == null ? other$bossThreads != null : !((Object)this$bossThreads).equals(other$bossThreads)) {
            return false;
        }
        Integer this$workerThreads = this.getWorkerThreads();
        Integer other$workerThreads = other.getWorkerThreads();
        return !(this$workerThreads == null ? other$workerThreads != null : !((Object)this$workerThreads).equals(other$workerThreads));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $bossThreads = this.getBossThreads();
        result = result * 59 + ($bossThreads == null ? 43 : ((Object)$bossThreads).hashCode());
        Integer $workerThreads = this.getWorkerThreads();
        result = result * 59 + ($workerThreads == null ? 43 : ((Object)$workerThreads).hashCode());
        return result;
    }

    public String toString() {
        return "ServerConfig(port=" + this.getPort() + ", bossThreads=" + this.getBossThreads() + ", workerThreads=" + this.getWorkerThreads() + ")";
    }

    public ServerConfig() {
    }

    public ServerConfig(Integer port, Integer bossThreads, Integer workerThreads) {
        this.port = port;
        this.bossThreads = bossThreads;
        this.workerThreads = workerThreads;
    }

    public static class ServerConfigBuilder {
        private Integer port;
        private Integer bossThreads;
        private Integer workerThreads;

        ServerConfigBuilder() {
        }

        public ServerConfigBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public ServerConfigBuilder bossThreads(Integer bossThreads) {
            this.bossThreads = bossThreads;
            return this;
        }

        public ServerConfigBuilder workerThreads(Integer workerThreads) {
            this.workerThreads = workerThreads;
            return this;
        }

        public ServerConfig build() {
            return new ServerConfig(this.port, this.bossThreads, this.workerThreads);
        }

        public String toString() {
            return "ServerConfig.ServerConfigBuilder(port=" + this.port + ", bossThreads=" + this.bossThreads + ", workerThreads=" + this.workerThreads + ")";
        }
    }
}

