/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.config;

import io.appulse.encon.common.DistributionFlag;
import io.appulse.encon.config.CompressionConfig;
import io.appulse.encon.config.MailboxConfig;
import io.appulse.encon.config.ServerConfig;
import io.appulse.epmd.java.client.EpmdClient;
import io.appulse.epmd.java.core.model.NodeType;
import io.appulse.epmd.java.core.model.Protocol;
import io.appulse.epmd.java.core.model.Version;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Defaults {
    public static final Defaults INSTANCE = Defaults.builder().build();
    private int epmdPort;
    private NodeType type;
    private Boolean shortNamed;
    private String cookie;
    private Protocol protocol;
    private Version low;
    private Version high;
    private Set<DistributionFlag> distributionFlags;
    private MailboxConfig mailbox;
    private ServerConfig server;
    private CompressionConfig compression;

    public static String getDefaultCookie() {
        Path cookieFile = Paths.get(Defaults.getHomeDir(), ".erlang.cookie");
        if (!Files.exists(cookieFile, new LinkOption[0])) {
            return "";
        }
        try {
            return Files.lines(cookieFile).filter(Objects::nonNull).map(String::trim).filter(it -> !it.isEmpty()).findFirst().orElse("");
        }
        catch (IOException ex) {
            return "";
        }
    }

    public static String getHomeDir() {
        String home = System.getProperty("user.home");
        if (!System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows")) {
            return home;
        }
        String drive = System.getenv("HOMEDRIVE");
        String path = System.getenv("HOMEPATH");
        return drive == null || path == null ? home : drive + path;
    }

    static Defaults newInstance(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map is marked @NonNull but is null");
        }
        DefaultsBuilder builder = Defaults.builder();
        Optional.ofNullable(map.get("epmd-port")).map(Object::toString).map(Integer::parseInt).ifPresent(builder::epmdPort);
        Optional.ofNullable(map.get("type")).map(Object::toString).map(NodeType::valueOf).ifPresent(builder::type);
        Optional.ofNullable(map.get("short-name")).map(Object::toString).map(Boolean::valueOf).ifPresent(builder::shortNamed);
        Optional.ofNullable(map.get("cookie")).map(Object::toString).ifPresent(builder::cookie);
        Optional.ofNullable(map.get("protocol")).map(Object::toString).map(Protocol::valueOf).ifPresent(builder::protocol);
        if (map.containsKey("version") && map.get("version") instanceof Map) {
            Map versionMap = (Map)map.get("version");
            Optional.ofNullable(versionMap.get("low")).map(Object::toString).map(Version::valueOf).ifPresent(builder::low);
            Optional.ofNullable(versionMap.get("high")).map(Object::toString).map(Version::valueOf).ifPresent(builder::high);
        }
        Optional.ofNullable(map.get("distribution-flags")).filter(it -> it instanceof List).map(it -> (List)it).map(it -> it.stream().map(DistributionFlag::valueOf).collect(Collectors.toSet())).ifPresent(builder::distributionFlags);
        Optional.ofNullable(map.get("mailbox")).filter(it -> it instanceof Map).map(it -> (Map)it).map(MailboxConfig::newInstance).ifPresent(builder::mailbox);
        Optional.ofNullable(map.get("server")).filter(it -> it instanceof Map).map(it -> (Map)it).map(ServerConfig::newInstance).ifPresent(builder::server);
        Optional.ofNullable(map.get("compression")).filter(it -> it instanceof Map).map(it -> (Map)it).map(CompressionConfig::newInstance).ifPresent(builder::compression);
        return builder.build();
    }

    public Defaults(Defaults defaults) {
        this.epmdPort = defaults.getEpmdPort();
        this.type = defaults.getType();
        this.shortNamed = defaults.getShortNamed();
        this.cookie = defaults.getCookie();
        this.protocol = defaults.getProtocol();
        this.low = defaults.getLow();
        this.high = defaults.getHigh();
        this.distributionFlags = Optional.ofNullable(defaults.getDistributionFlags()).map(HashSet::new).orElse(null);
        this.mailbox = Optional.ofNullable(defaults.getMailbox()).map(MailboxConfig::new).orElse(null);
        this.server = Optional.ofNullable(defaults.getServer()).map(ServerConfig::new).orElse(null);
        this.compression = Optional.ofNullable(defaults.getCompression()).map(CompressionConfig::new).orElse(null);
    }

    private static int $default$epmdPort() {
        return EpmdClient.Default.PORT;
    }

    private static NodeType $default$type() {
        return NodeType.R6_ERLANG;
    }

    private static Boolean $default$shortNamed() {
        return Boolean.FALSE;
    }

    private static String $default$cookie() {
        return Defaults.getDefaultCookie();
    }

    private static Protocol $default$protocol() {
        return Protocol.TCP;
    }

    private static Version $default$low() {
        return Version.R6;
    }

    private static Version $default$high() {
        return Version.R6;
    }

    private static Set<DistributionFlag> $default$distributionFlags() {
        return new HashSet<DistributionFlag>(Arrays.asList(DistributionFlag.EXTENDED_REFERENCES, DistributionFlag.EXTENDED_PIDS_PORTS, DistributionFlag.BIT_BINARIES, DistributionFlag.NEW_FLOATS, DistributionFlag.FUN_TAGS, DistributionFlag.NEW_FUN_TAGS, DistributionFlag.UTF8_ATOMS, DistributionFlag.MAP_TAG, DistributionFlag.BIG_CREATION));
    }

    private static MailboxConfig $default$mailbox() {
        return MailboxConfig.builder().build();
    }

    private static ServerConfig $default$server() {
        return ServerConfig.builder().bossThreads(1).workerThreads(2).build();
    }

    private static CompressionConfig $default$compression() {
        return CompressionConfig.builder().enabled(Boolean.FALSE).level(-1).build();
    }

    public static DefaultsBuilder builder() {
        return new DefaultsBuilder();
    }

    public int getEpmdPort() {
        return this.epmdPort;
    }

    public NodeType getType() {
        return this.type;
    }

    public Boolean getShortNamed() {
        return this.shortNamed;
    }

    public String getCookie() {
        return this.cookie;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Version getLow() {
        return this.low;
    }

    public Version getHigh() {
        return this.high;
    }

    public Set<DistributionFlag> getDistributionFlags() {
        return this.distributionFlags;
    }

    public MailboxConfig getMailbox() {
        return this.mailbox;
    }

    public ServerConfig getServer() {
        return this.server;
    }

    public CompressionConfig getCompression() {
        return this.compression;
    }

    public void setEpmdPort(int epmdPort) {
        this.epmdPort = epmdPort;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public void setShortNamed(Boolean shortNamed) {
        this.shortNamed = shortNamed;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setLow(Version low) {
        this.low = low;
    }

    public void setHigh(Version high) {
        this.high = high;
    }

    public void setDistributionFlags(Set<DistributionFlag> distributionFlags) {
        this.distributionFlags = distributionFlags;
    }

    public void setMailbox(MailboxConfig mailbox) {
        this.mailbox = mailbox;
    }

    public void setServer(ServerConfig server) {
        this.server = server;
    }

    public void setCompression(CompressionConfig compression) {
        this.compression = compression;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Defaults)) {
            return false;
        }
        Defaults other = (Defaults)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpmdPort() != other.getEpmdPort()) {
            return false;
        }
        NodeType this$type = this.getType();
        NodeType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Boolean this$shortNamed = this.getShortNamed();
        Boolean other$shortNamed = other.getShortNamed();
        if (this$shortNamed == null ? other$shortNamed != null : !((Object)this$shortNamed).equals(other$shortNamed)) {
            return false;
        }
        String this$cookie = this.getCookie();
        String other$cookie = other.getCookie();
        if (this$cookie == null ? other$cookie != null : !this$cookie.equals(other$cookie)) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        Version this$low = this.getLow();
        Version other$low = other.getLow();
        if (this$low == null ? other$low != null : !this$low.equals(other$low)) {
            return false;
        }
        Version this$high = this.getHigh();
        Version other$high = other.getHigh();
        if (this$high == null ? other$high != null : !this$high.equals(other$high)) {
            return false;
        }
        Set<DistributionFlag> this$distributionFlags = this.getDistributionFlags();
        Set<DistributionFlag> other$distributionFlags = other.getDistributionFlags();
        if (this$distributionFlags == null ? other$distributionFlags != null : !((Object)this$distributionFlags).equals(other$distributionFlags)) {
            return false;
        }
        MailboxConfig this$mailbox = this.getMailbox();
        MailboxConfig other$mailbox = other.getMailbox();
        if (this$mailbox == null ? other$mailbox != null : !((Object)this$mailbox).equals(other$mailbox)) {
            return false;
        }
        ServerConfig this$server = this.getServer();
        ServerConfig other$server = other.getServer();
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        CompressionConfig this$compression = this.getCompression();
        CompressionConfig other$compression = other.getCompression();
        return !(this$compression == null ? other$compression != null : !((Object)this$compression).equals(other$compression));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Defaults;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEpmdPort();
        NodeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Boolean $shortNamed = this.getShortNamed();
        result = result * 59 + ($shortNamed == null ? 43 : ((Object)$shortNamed).hashCode());
        String $cookie = this.getCookie();
        result = result * 59 + ($cookie == null ? 43 : $cookie.hashCode());
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        Version $low = this.getLow();
        result = result * 59 + ($low == null ? 43 : $low.hashCode());
        Version $high = this.getHigh();
        result = result * 59 + ($high == null ? 43 : $high.hashCode());
        Set<DistributionFlag> $distributionFlags = this.getDistributionFlags();
        result = result * 59 + ($distributionFlags == null ? 43 : ((Object)$distributionFlags).hashCode());
        MailboxConfig $mailbox = this.getMailbox();
        result = result * 59 + ($mailbox == null ? 43 : ((Object)$mailbox).hashCode());
        ServerConfig $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        CompressionConfig $compression = this.getCompression();
        result = result * 59 + ($compression == null ? 43 : ((Object)$compression).hashCode());
        return result;
    }

    public String toString() {
        return "Defaults(epmdPort=" + this.getEpmdPort() + ", type=" + this.getType() + ", shortNamed=" + this.getShortNamed() + ", cookie=" + this.getCookie() + ", protocol=" + this.getProtocol() + ", low=" + this.getLow() + ", high=" + this.getHigh() + ", distributionFlags=" + this.getDistributionFlags() + ", mailbox=" + this.getMailbox() + ", server=" + this.getServer() + ", compression=" + this.getCompression() + ")";
    }

    public Defaults() {
        this.epmdPort = Defaults.$default$epmdPort();
        this.type = Defaults.$default$type();
        this.shortNamed = Defaults.$default$shortNamed();
        this.cookie = Defaults.$default$cookie();
        this.protocol = Defaults.$default$protocol();
        this.low = Defaults.$default$low();
        this.high = Defaults.$default$high();
        this.distributionFlags = Defaults.$default$distributionFlags();
        this.mailbox = Defaults.$default$mailbox();
        this.server = Defaults.$default$server();
        this.compression = Defaults.$default$compression();
    }

    public Defaults(int epmdPort, NodeType type, Boolean shortNamed, String cookie, Protocol protocol, Version low, Version high, Set<DistributionFlag> distributionFlags, MailboxConfig mailbox, ServerConfig server, CompressionConfig compression) {
        this.epmdPort = epmdPort;
        this.type = type;
        this.shortNamed = shortNamed;
        this.cookie = cookie;
        this.protocol = protocol;
        this.low = low;
        this.high = high;
        this.distributionFlags = distributionFlags;
        this.mailbox = mailbox;
        this.server = server;
        this.compression = compression;
    }

    public static class DefaultsBuilder {
        private boolean epmdPort$set;
        private int epmdPort;
        private boolean type$set;
        private NodeType type;
        private boolean shortNamed$set;
        private Boolean shortNamed;
        private boolean cookie$set;
        private String cookie;
        private boolean protocol$set;
        private Protocol protocol;
        private boolean low$set;
        private Version low;
        private boolean high$set;
        private Version high;
        private boolean distributionFlags$set;
        private Set<DistributionFlag> distributionFlags;
        private boolean mailbox$set;
        private MailboxConfig mailbox;
        private boolean server$set;
        private ServerConfig server;
        private boolean compression$set;
        private CompressionConfig compression;

        DefaultsBuilder() {
        }

        public DefaultsBuilder epmdPort(int epmdPort) {
            this.epmdPort = epmdPort;
            this.epmdPort$set = true;
            return this;
        }

        public DefaultsBuilder type(NodeType type) {
            this.type = type;
            this.type$set = true;
            return this;
        }

        public DefaultsBuilder shortNamed(Boolean shortNamed) {
            this.shortNamed = shortNamed;
            this.shortNamed$set = true;
            return this;
        }

        public DefaultsBuilder cookie(String cookie) {
            this.cookie = cookie;
            this.cookie$set = true;
            return this;
        }

        public DefaultsBuilder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.protocol$set = true;
            return this;
        }

        public DefaultsBuilder low(Version low) {
            this.low = low;
            this.low$set = true;
            return this;
        }

        public DefaultsBuilder high(Version high) {
            this.high = high;
            this.high$set = true;
            return this;
        }

        public DefaultsBuilder distributionFlags(Set<DistributionFlag> distributionFlags) {
            this.distributionFlags = distributionFlags;
            this.distributionFlags$set = true;
            return this;
        }

        public DefaultsBuilder mailbox(MailboxConfig mailbox) {
            this.mailbox = mailbox;
            this.mailbox$set = true;
            return this;
        }

        public DefaultsBuilder server(ServerConfig server) {
            this.server = server;
            this.server$set = true;
            return this;
        }

        public DefaultsBuilder compression(CompressionConfig compression) {
            this.compression = compression;
            this.compression$set = true;
            return this;
        }

        public Defaults build() {
            int epmdPort = this.epmdPort;
            if (!this.epmdPort$set) {
                epmdPort = Defaults.$default$epmdPort();
            }
            NodeType type = this.type;
            if (!this.type$set) {
                type = Defaults.$default$type();
            }
            Boolean shortNamed = this.shortNamed;
            if (!this.shortNamed$set) {
                shortNamed = Defaults.$default$shortNamed();
            }
            String cookie = this.cookie;
            if (!this.cookie$set) {
                cookie = Defaults.$default$cookie();
            }
            Protocol protocol = this.protocol;
            if (!this.protocol$set) {
                protocol = Defaults.$default$protocol();
            }
            Version low = this.low;
            if (!this.low$set) {
                low = Defaults.$default$low();
            }
            Version high = this.high;
            if (!this.high$set) {
                high = Defaults.$default$high();
            }
            Set distributionFlags = this.distributionFlags;
            if (!this.distributionFlags$set) {
                distributionFlags = Defaults.$default$distributionFlags();
            }
            MailboxConfig mailbox = this.mailbox;
            if (!this.mailbox$set) {
                mailbox = Defaults.$default$mailbox();
            }
            ServerConfig server = this.server;
            if (!this.server$set) {
                server = Defaults.$default$server();
            }
            CompressionConfig compression = this.compression;
            if (!this.compression$set) {
                compression = Defaults.$default$compression();
            }
            return new Defaults(epmdPort, type, shortNamed, cookie, protocol, low, high, distributionFlags, mailbox, server, compression);
        }

        public String toString() {
            return "Defaults.DefaultsBuilder(epmdPort=" + this.epmdPort + ", type=" + this.type + ", shortNamed=" + this.shortNamed + ", cookie=" + this.cookie + ", protocol=" + this.protocol + ", low=" + this.low + ", high=" + this.high + ", distributionFlags=" + this.distributionFlags + ", mailbox=" + this.mailbox + ", server=" + this.server + ", compression=" + this.compression + ")";
        }
    }
}

