/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.config;

import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class MailboxConfig {
    private String name;
    private Boolean blocking;

    static MailboxConfig newInstance(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map is marked @NonNull but is null");
        }
        MailboxConfigBuilder builder = MailboxConfig.builder();
        Optional.ofNullable(map.get("name")).map(Object::toString).ifPresent(builder::name);
        Optional.ofNullable(map.get("blocking")).map(Object::toString).map(Boolean::valueOf).ifPresent(builder::blocking);
        return builder.build();
    }

    public MailboxConfig(MailboxConfig mailboxConfig) {
        this.name = mailboxConfig.getName();
        this.blocking = mailboxConfig.getBlocking();
    }

    public MailboxConfig withDefaultsFrom(@NonNull MailboxConfig defaults) {
        if (defaults == null) {
            throw new NullPointerException("defaults is marked @NonNull but is null");
        }
        this.blocking = Optional.ofNullable(this.blocking).orElse(defaults.getBlocking());
        return this;
    }

    public static MailboxConfigBuilder builder() {
        return new MailboxConfigBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Boolean getBlocking() {
        return this.blocking;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBlocking(Boolean blocking) {
        this.blocking = blocking;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailboxConfig)) {
            return false;
        }
        MailboxConfig other = (MailboxConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Boolean this$blocking = this.getBlocking();
        Boolean other$blocking = other.getBlocking();
        return !(this$blocking == null ? other$blocking != null : !((Object)this$blocking).equals(other$blocking));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MailboxConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Boolean $blocking = this.getBlocking();
        result = result * 59 + ($blocking == null ? 43 : ((Object)$blocking).hashCode());
        return result;
    }

    public String toString() {
        return "MailboxConfig(name=" + this.getName() + ", blocking=" + this.getBlocking() + ")";
    }

    public MailboxConfig() {
    }

    public MailboxConfig(String name, Boolean blocking) {
        this.name = name;
        this.blocking = blocking;
    }

    public static class MailboxConfigBuilder {
        private String name;
        private Boolean blocking;

        MailboxConfigBuilder() {
        }

        public MailboxConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MailboxConfigBuilder blocking(Boolean blocking) {
            this.blocking = blocking;
            return this;
        }

        public MailboxConfig build() {
            return new MailboxConfig(this.name, this.blocking);
        }

        public String toString() {
            return "MailboxConfig.MailboxConfigBuilder(name=" + this.name + ", blocking=" + this.blocking + ")";
        }
    }
}

