/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.config;

import io.appulse.encon.config.exception.NoSuchMailboxHandlerException;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class MailboxConfig {
    private String name;
    private Class<?> handler;

    static MailboxConfig newInstance(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map is marked @NonNull but is null");
        }
        MailboxConfigBuilder builder = MailboxConfig.builder();
        Optional.ofNullable(map.get("name")).map(Object::toString).ifPresent(builder::name);
        Optional.ofNullable(map.get("handler")).map(Object::toString).map(it -> {
            try {
                return Class.forName(it);
            }
            catch (ClassNotFoundException ex) {
                throw new NoSuchMailboxHandlerException(ex, (String)it);
            }
        }).ifPresent(builder::handler);
        return builder.build();
    }

    public MailboxConfig withDefaultsFrom(@NonNull MailboxConfig defaults) {
        if (defaults == null) {
            throw new NullPointerException("defaults is marked @NonNull but is null");
        }
        if (this.handler == null) {
            this.handler = defaults.getHandler();
        }
        return this;
    }

    public static MailboxConfigBuilder builder() {
        return new MailboxConfigBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getHandler() {
        return this.handler;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHandler(Class<?> handler) {
        this.handler = handler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailboxConfig)) {
            return false;
        }
        MailboxConfig other = (MailboxConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Class<?> this$handler = this.getHandler();
        Class<?> other$handler = other.getHandler();
        return !(this$handler == null ? other$handler != null : !this$handler.equals(other$handler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MailboxConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Class<?> $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
        return result;
    }

    public String toString() {
        return "MailboxConfig(name=" + this.getName() + ", handler=" + this.getHandler() + ")";
    }

    public MailboxConfig() {
    }

    public MailboxConfig(String name, Class<?> handler) {
        this.name = name;
        this.handler = handler;
    }

    public static class MailboxConfigBuilder {
        private String name;
        private Class<?> handler;

        MailboxConfigBuilder() {
        }

        public MailboxConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MailboxConfigBuilder handler(Class<?> handler) {
            this.handler = handler;
            return this;
        }

        public MailboxConfig build() {
            return new MailboxConfig(this.name, this.handler);
        }

        public String toString() {
            return "MailboxConfig.MailboxConfigBuilder(name=" + this.name + ", handler=" + this.handler + ")";
        }
    }
}

