/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.common;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import lombok.NonNull;

public final class NodeDescriptor
implements Serializable {
    private static final long serialVersionUID = 7324588959922091097L;
    private static final Map<String, NodeDescriptor> NODE_DESCRIPTOR_CACHE;
    private static final InetAddress LOCALHOST;
    private static final InetAddress LOOPBACK;
    private static final String LONG_HOST_NAME;
    private static final String SHORT_HOST_NAME;
    private final String nodeName;
    private final String hostName;
    private final String fullName;
    private final InetAddress address;
    private final boolean shortName;

    public static NodeDescriptor from(@NonNull String node) {
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        NodeDescriptor cached = NODE_DESCRIPTOR_CACHE.get(node);
        if (cached != null) {
            return cached;
        }
        NodeDescriptor descriptor = NodeDescriptor.getFromCacheOrCreateNew(node);
        Stream.of(descriptor.getFullName(), descriptor.getNodeName(), node).forEach(it -> NODE_DESCRIPTOR_CACHE.putIfAbsent((String)it, descriptor));
        return descriptor;
    }

    public static NodeDescriptor from(@NonNull String node, boolean isShortName) {
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        NodeDescriptor cached = NODE_DESCRIPTOR_CACHE.get(node);
        if (cached != null) {
            return cached;
        }
        NodeDescriptor descriptor = NodeDescriptor.getFromCacheOrCreateNew(node, isShortName);
        Stream.of(descriptor.getFullName(), descriptor.getNodeName(), node).forEach(it -> NODE_DESCRIPTOR_CACHE.putIfAbsent((String)it, descriptor));
        return descriptor;
    }

    public static boolean wasCached(@NonNull String node) {
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        NodeDescriptor descriptor = NodeDescriptor.getFromCacheOrCreateNew(node);
        return NodeDescriptor.wasCached(descriptor);
    }

    public static boolean wasCached(@NonNull NodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is marked @NonNull but is null");
        }
        return NODE_DESCRIPTOR_CACHE.containsKey(descriptor.getNodeName()) || NODE_DESCRIPTOR_CACHE.containsKey(descriptor.getFullName());
    }

    public static boolean removeFromCache(@NonNull String node) {
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        NodeDescriptor descriptor = NodeDescriptor.getFromCacheOrCreateNew(node);
        return NodeDescriptor.removeFromCache(descriptor);
    }

    public static boolean removeFromCache(@NonNull NodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is marked @NonNull but is null");
        }
        boolean wasRemoved = NODE_DESCRIPTOR_CACHE.remove(descriptor.getNodeName()) != null;
        return NODE_DESCRIPTOR_CACHE.remove(descriptor.getFullName()) != null || wasRemoved;
    }

    private static NodeDescriptor getFromCacheOrCreateNew(@NonNull String node) {
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        int atIndex = node.indexOf(64);
        boolean isShortName = atIndex < 0 || node.indexOf(46, atIndex) < 0;
        return NodeDescriptor.getFromCacheOrCreateNew(node, isShortName);
    }

    private static NodeDescriptor getFromCacheOrCreateNew(@NonNull String node, boolean isShortName) {
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        String trimmedNode = Optional.of(node).map(String::trim).filter(it -> !it.isEmpty()).orElseThrow(() -> new IllegalArgumentException("Invalid node descriptor string '" + node + "'"));
        NodeDescriptor cached = NODE_DESCRIPTOR_CACHE.get(trimmedNode);
        return cached == null ? NodeDescriptor.parse(trimmedNode, isShortName) : cached;
    }

    private static NodeDescriptor parse(@NonNull String node, boolean isShortName) {
        InetAddress address;
        String hostName;
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        int expectedTokensCount = 2;
        String[] tokens = node.split("@", 2);
        String nodeName = tokens[0];
        if (nodeName.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (tokens.length == 2) {
            hostName = tokens[1];
            if (isShortName && hostName.contains(".")) {
                String message = String.format("Using host name '%s' in short node name is illegal, because it contains dots ('.') and suits only for long name nodes", hostName);
                throw new IllegalArgumentException(message);
            }
            address = isShortName ? LOOPBACK : InetAddress.getByName(hostName);
        } else if (isShortName) {
            hostName = SHORT_HOST_NAME;
            address = LOOPBACK;
        } else {
            hostName = LONG_HOST_NAME;
            address = LOCALHOST;
        }
        String fullName = nodeName + '@' + hostName;
        return new NodeDescriptor(nodeName, hostName, fullName, address, isShortName);
    }

    public boolean isShortName() {
        return this.shortName;
    }

    public boolean isLongName() {
        return !this.shortName;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getNodeName() {
        return this.nodeName;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getHostName() {
        return this.hostName;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getFullName() {
        return this.fullName;
    }

    @SuppressFBWarnings(justification="generated code")
    public InetAddress getAddress() {
        return this.address;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "NodeDescriptor(nodeName=" + this.getNodeName() + ", hostName=" + this.getHostName() + ", fullName=" + this.getFullName() + ", address=" + this.getAddress() + ", shortName=" + this.isShortName() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeDescriptor)) {
            return false;
        }
        NodeDescriptor other = (NodeDescriptor)o;
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        return !(this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName));
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    private NodeDescriptor(String nodeName, String hostName, String fullName, InetAddress address, boolean shortName) {
        this.nodeName = nodeName;
        this.hostName = hostName;
        this.fullName = fullName;
        this.address = address;
        this.shortName = shortName;
    }

    static {
        try {
            LOCALHOST = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException(ex);
        }
        LOOPBACK = InetAddress.getLoopbackAddress();
        LONG_HOST_NAME = LOCALHOST.getHostName();
        int dotIndex = LONG_HOST_NAME.indexOf(46);
        SHORT_HOST_NAME = dotIndex > 0 ? LONG_HOST_NAME.substring(0, dotIndex) : LONG_HOST_NAME;
        NODE_DESCRIPTOR_CACHE = new ConcurrentHashMap<String, NodeDescriptor>();
    }
}

