/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.common;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DistributionFlag {
    PUBLISHED(1),
    ATOM_CACHE(2),
    EXTENDED_REFERENCES(4),
    DIST_MONITOR(8),
    FUN_TAGS(16),
    DIST_MONITOR_NAME(32),
    HIDDEN_ATOM_CACHE(64),
    NEW_FUN_TAGS(128),
    EXTENDED_PIDS_PORTS(256),
    EXPORT_PTR_TAG(512),
    BIT_BINARIES(1024),
    NEW_FLOATS(2048),
    UNICODE_IO(4096),
    DIST_HDR_ATOM_CACHE(8192),
    SMALL_ATOM_TAGS(16384),
    UTF8_ATOMS(65536),
    MAP_TAG(131072),
    BIG_CREATION(262144);

    private final int code;

    private DistributionFlag(int code) {
        this.code = code;
    }

    public static int bitwiseOr(DistributionFlag ... flags) {
        return Stream.of(flags).map(DistributionFlag::getCode).reduce(0, (left, right) -> left | right);
    }

    public static int bitwiseOr(Collection<DistributionFlag> flags) {
        return flags.stream().map(DistributionFlag::getCode).reduce(0, (left, right) -> left | right);
    }

    public static Set<DistributionFlag> parse(int number) {
        return Stream.of(DistributionFlag.values()).filter(it -> (number & it.getCode()) != 0).collect(Collectors.toSet());
    }

    @SuppressFBWarnings(justification="generated code")
    public int getCode() {
        return this.code;
    }
}

