/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.rxhub;

import rx.Observable;

public interface RxHub {
    public void addProvider(Object var1, Observable var2);

    public void removeProvider(Object var1, Observable var2);

    public void clearProviders();

    public Observable getNode(Object var1);

    public <T> Observable<T> getNodeFiltered(Object var1, Class<T> var2);

    public void emit(Object var1, Object var2);

    public NodeType getNodeType(Object var1);

    public boolean isNodeThreadsafe(Object var1);

    public boolean canTriggerEmit(Object var1);

    public static enum NodeType {
        BehaviorSubject,
        PublishSubject,
        ReplaySubject,
        BehaviorRelay,
        PublishRelay,
        ReplayRelay,
        ObservableRef;

    }

    public static class Source {
        final Observable provider;
        final Object tag;

        Source(Observable provider, Object tag) {
            this.provider = provider;
            this.tag = tag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Source source = (Source)o;
            if (!this.provider.equals(source.provider)) {
                return false;
            }
            return this.tag.equals(source.tag);
        }

        public int hashCode() {
            int result = this.provider.hashCode();
            result = 31 * result + this.tag.hashCode();
            return result;
        }
    }
}

