/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.rxhub;

import com.jakewharton.rxrelay.BehaviorRelay;
import com.jakewharton.rxrelay.PublishRelay;
import com.jakewharton.rxrelay.Relay;
import com.jakewharton.rxrelay.ReplayRelay;
import com.jakewharton.rxrelay.SerializedRelay;
import io.apptik.rxhub.RxHub;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.subjects.BehaviorSubject;
import rx.subjects.PublishSubject;
import rx.subjects.ReplaySubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;
import rx.subscriptions.CompositeSubscription;

public abstract class AbstractRxHub
implements RxHub {
    private Map<Object, Observable> nodeMap = new ConcurrentHashMap<Object, Observable>();
    private Map<RxHub.Source, Subscription> subscriptionMap = new ConcurrentHashMap<RxHub.Source, Subscription>();
    private CompositeSubscription subscriptions = new CompositeSubscription();

    @Override
    public void addProvider(Object tag, Observable provider) {
        if (this.getNodeType(tag) == RxHub.NodeType.ObservableRef) {
            this.nodeMap.put(tag, provider);
        } else {
            Subscription res;
            Observable node = this.nodeMap.get(tag);
            if (node == null) {
                node = this.addNode(tag);
            }
            if (Action1.class.isAssignableFrom(node.getClass())) {
                res = provider.subscribe((Action1)node);
            } else if (Observer.class.isAssignableFrom(node.getClass())) {
                res = provider.subscribe((Observer)node);
            } else {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Node(%s) type(%s) is not supported! Do we have an alien injection?", tag, provider.getClass()));
            }
            this.subscriptions.add(res);
            this.subscriptionMap.put(new RxHub.Source(provider, tag), res);
        }
    }

    @Override
    public void removeProvider(Object tag, Observable provider) {
        if (this.getNodeType(tag) == RxHub.NodeType.ObservableRef) {
            this.nodeMap.remove(tag);
        } else {
            RxHub.Source s = new RxHub.Source(provider, tag);
            this.subscriptions.remove(this.subscriptionMap.get(s));
            this.subscriptionMap.remove(s);
        }
    }

    @Override
    public Observable getNode(Object tag) {
        return this.getNodeInternal(tag).asObservable();
    }

    @Override
    public <T> Observable<T> getNodeFiltered(Object tag, final Class<T> filterClass) {
        return this.getNode(tag).filter((Func1)new Func1<Object, Boolean>(){

            public Boolean call(Object obj) {
                return filterClass.isAssignableFrom(obj.getClass());
            }
        });
    }

    private Observable getNodeInternal(Object tag) {
        Observable res = this.nodeMap.get(tag);
        if (res == null) {
            res = this.addNode(tag);
        }
        return res;
    }

    private Observable addNode(Object tag) {
        BehaviorSubject res;
        RxHub.NodeType nt = this.getNodeType(tag);
        switch (nt) {
            case BehaviorSubject: {
                res = BehaviorSubject.create();
                break;
            }
            case PublishSubject: {
                res = PublishSubject.create();
                break;
            }
            case ReplaySubject: {
                res = ReplaySubject.create();
                break;
            }
            case BehaviorRelay: {
                res = BehaviorRelay.create();
                break;
            }
            case PublishRelay: {
                res = PublishRelay.create();
                break;
            }
            case ReplayRelay: {
                res = ReplayRelay.create();
                break;
            }
            case ObservableRef: {
                res = null;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown NodeType");
            }
        }
        if (this.isNodeThreadsafe(tag)) {
            switch (nt) {
                case BehaviorSubject: 
                case PublishSubject: 
                case ReplaySubject: {
                    res = new SerializedSubject((Subject)res);
                    break;
                }
                case BehaviorRelay: 
                case PublishRelay: 
                case ReplayRelay: {
                    res = new SerializedRelay((Relay)res);
                }
            }
        }
        this.nodeMap.put(tag, (Observable)res);
        return res;
    }

    @Override
    public void emit(Object tag, Object event) {
        if (this.getNodeType(tag) == RxHub.NodeType.ObservableRef) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Emitting event not possible. Node(%s) represents immutable stream.", tag));
        }
        Observable node = this.getNodeInternal(tag);
        if (Action1.class.isAssignableFrom(node.getClass())) {
            ((Action1)node).call(event);
        } else if (Observer.class.isAssignableFrom(node.getClass())) {
            ((Observer)node).onNext(event);
        } else {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Node(%s) type(%s) is not supported! Do we have an alien injection?", tag, node.getClass()));
        }
    }

    @Override
    public void clearProviders() {
        this.subscriptions.clear();
    }
}

