/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.modelgen.util;

import io.apptik.json.modelgen.util.RuleAndReplacement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WordUtils {
    private static final Pattern UNDERSCORE_PATTERN_1 = Pattern.compile("([A-Z]+)([A-Z][a-z])");
    private static final Pattern UNDERSCORE_PATTERN_2 = Pattern.compile("([a-z\\d])([A-Z])");
    private static List<RuleAndReplacement> plurals = new ArrayList<RuleAndReplacement>();
    private static List<RuleAndReplacement> singulars = new ArrayList<RuleAndReplacement>();
    private static List<String> uncountables = new ArrayList<String>();

    private WordUtils() {
    }

    public static String underscore(String camelCasedWord) {
        String underscoredWord = UNDERSCORE_PATTERN_1.matcher(camelCasedWord).replaceAll("$1_$2");
        underscoredWord = UNDERSCORE_PATTERN_2.matcher(underscoredWord).replaceAll("$1_$2");
        underscoredWord = underscoredWord.replace('-', '_').toLowerCase();
        return underscoredWord;
    }

    public static String pluralize(String word) {
        if (uncountables.contains(word.toLowerCase())) {
            return word;
        }
        return WordUtils.replaceWithFirstRule(word, plurals);
    }

    public static String singularize(String word) {
        if (uncountables.contains(word.toLowerCase())) {
            return word;
        }
        return WordUtils.replaceWithFirstRule(word, singulars);
    }

    private static String replaceWithFirstRule(String word, List<RuleAndReplacement> ruleAndReplacements) {
        for (RuleAndReplacement rar : ruleAndReplacements) {
            String rule = rar.getRule();
            String replacement = rar.getReplacement();
            Matcher matcher = Pattern.compile(rule, 2).matcher(word);
            if (!matcher.find()) continue;
            return matcher.replaceAll(replacement);
        }
        return word;
    }

    public static String tableize(String className) {
        return WordUtils.pluralize(WordUtils.underscore(className));
    }

    public static String tableize(Class<?> klass) {
        String className = klass.getName().replace(klass.getPackage().getName() + ".", "");
        return WordUtils.tableize(className);
    }

    public static void plural(String rule, String replacement) {
        plurals.add(0, new RuleAndReplacement(rule, replacement));
    }

    public static void singular(String rule, String replacement) {
        singulars.add(0, new RuleAndReplacement(rule, replacement));
    }

    public static void irregular(String singular, String plural) {
        WordUtils.plural(singular, plural);
        WordUtils.singular(plural, singular);
    }

    public static void uncountable(String ... words) {
        for (String word : words) {
            uncountables.add(word);
        }
    }

    public static String capitalize(String word) {
        String[] words = word.split(" ");
        StringBuilder res = new StringBuilder();
        for (String w : words) {
            res.append(WordUtils.capitalizeSingle(w));
        }
        return res.toString();
    }

    public static String capitalizeSingle(String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    static {
        WordUtils.plural("$", "s");
        WordUtils.plural("s$", "s");
        WordUtils.plural("(ax|test)is$", "$1es");
        WordUtils.plural("(octop|vir)us$", "$1i");
        WordUtils.plural("(alias|status)$", "$1es");
        WordUtils.plural("(bu)s$", "$1es");
        WordUtils.plural("(buffal|tomat)o$", "$1oes");
        WordUtils.plural("([ti])um$", "$1a");
        WordUtils.plural("sis$", "ses");
        WordUtils.plural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        WordUtils.plural("(hive)$", "$1s");
        WordUtils.plural("([^aeiouy]|qu)y$", "$1ies");
        WordUtils.plural("([^aeiouy]|qu)ies$", "$1y");
        WordUtils.plural("(x|ch|ss|sh)$", "$1es");
        WordUtils.plural("(matr|vert|ind)ix|ex$", "$1ices");
        WordUtils.plural("([m|l])ouse$", "$1ice");
        WordUtils.plural("(ox)$", "$1en");
        WordUtils.plural("(quiz)$", "$1zes");
        WordUtils.singular("s$", "");
        WordUtils.singular("(n)ews$", "$1ews");
        WordUtils.singular("([ti])a$", "$1um");
        WordUtils.singular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis");
        WordUtils.singular("(^analy)ses$", "$1sis");
        WordUtils.singular("([^f])ves$", "$1fe");
        WordUtils.singular("(hive)s$", "$1");
        WordUtils.singular("(tive)s$", "$1");
        WordUtils.singular("([lr])ves$", "$1f");
        WordUtils.singular("([^aeiouy]|qu)ies$", "$1y");
        WordUtils.singular("(s)eries$", "$1eries");
        WordUtils.singular("(m)ovies$", "$1ovie");
        WordUtils.singular("(x|ch|ss|sh)es$", "$1");
        WordUtils.singular("([m|l])ice$", "$1ouse");
        WordUtils.singular("(bus)es$", "$1");
        WordUtils.singular("(o)es$", "$1");
        WordUtils.singular("(shoe)s$", "$1");
        WordUtils.singular("(cris|ax|test)es$", "$1is");
        WordUtils.singular("([octop|vir])i$", "$1us");
        WordUtils.singular("(alias|status)es$", "$1");
        WordUtils.singular("^(ox)en", "$1");
        WordUtils.singular("(vert|ind)ices$", "$1ex");
        WordUtils.singular("(matr)ices$", "$1ix");
        WordUtils.singular("(quiz)zes$", "$1");
        WordUtils.singular("(ess)$", "$1");
        WordUtils.singular("men$", "man");
        WordUtils.plural("man$", "men");
        WordUtils.irregular("curve", "curves");
        WordUtils.irregular("leaf", "leaves");
        WordUtils.irregular("roof", "rooves");
        WordUtils.irregular("person", "people");
        WordUtils.irregular("child", "children");
        WordUtils.irregular("sex", "sexes");
        WordUtils.irregular("move", "moves");
        WordUtils.uncountable("equipment", "information", "rice", "money", "species", "series", "fish", "sheep", "s");
    }
}

