/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.modelgen;

import io.apptik.json.JsonElement;
import io.apptik.json.modelgen.Generator;
import io.apptik.json.modelgen.util.WordUtils;
import io.apptik.json.schema.Schema;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class Util {
    static final String JOB_FTL_TEMPLATE = "JsonObjectWrapper.ftl";
    static Map<String, String> javaTypeMap = new HashMap<String, String>();
    static Map<String, String> optMethodMap = new HashMap<String, String>();

    private Util() {
    }

    public static String getJavaType(String jsonType) {
        String res = javaTypeMap.get(jsonType);
        if (res == null) {
            throw new RuntimeException("Unknown type");
        }
        return res;
    }

    public static String getOptMethod(String jsonType) {
        String res = optMethodMap.get(jsonType);
        if (res == null) {
            throw new RuntimeException("Unknown type");
        }
        return res;
    }

    public static Generator.Prop getPropFromJsonEntry(String key, JsonElement el) {
        Generator.Prop p = new Generator.Prop();
        p.origKey = key;
        p.methodName = WordUtils.capitalize(p.origKey);
        p.returnType = Util.getJavaType(el.getJsonType());
        p.optMethod = Util.getOptMethod(el.getJsonType());
        return p;
    }

    public static Generator.Prop getPropFromJsonSchema(String key, Schema schema) {
        Generator.Prop p = new Generator.Prop();
        p.origKey = key;
        p.methodName = WordUtils.capitalize(p.origKey);
        String type = schema.getType().size() == 1 ? (String)schema.getType().get(0) : "null";
        p.returnType = Util.getJavaType(type);
        p.optMethod = Util.getOptMethod(type);
        return p;
    }

    public static InputStream getResource(String name) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream is = classloader.getResourceAsStream(name);
        return is;
    }

    public static InputStream getJOBftl() {
        return Util.getResource(JOB_FTL_TEMPLATE);
    }

    static {
        javaTypeMap.put("array", "JsonArray");
        javaTypeMap.put("object", "JsonObject");
        javaTypeMap.put("boolean", "Boolean");
        javaTypeMap.put("integer", "Integer");
        javaTypeMap.put("number", "Double");
        javaTypeMap.put("string", "String");
        javaTypeMap.put("null", "JsonElement");
        optMethodMap.put("array", "JsonArray");
        optMethodMap.put("object", "JsonObject");
        optMethodMap.put("boolean", "Boolean");
        optMethodMap.put("integer", "Int");
        optMethodMap.put("number", "Double");
        optMethodMap.put("string", "String");
        optMethodMap.put("null", "");
    }
}

