/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.modelgen;

import freemarker.template.AdapterTemplateModel;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.Version;
import freemarker.template.WrappingTemplateModel;
import io.apptik.json.JsonElement;
import io.apptik.json.JsonObject;
import io.apptik.json.modelgen.Generator;
import io.apptik.json.modelgen.Util;
import io.apptik.json.modelgen.util.WordUtils;
import io.apptik.json.schema.Schema;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FtlGenerator
implements Generator {
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);

    public FtlGenerator() {
        this.cfg.setObjectWrapper((ObjectWrapper)new MyAppObjectWrapper(this.cfg.getIncompatibleImprovements()));
    }

    private Template getJobTemplate() throws IOException {
        return new Template("JsonObjectWrapper.ftl", (Reader)new InputStreamReader(Util.getJOBftl()), this.cfg);
    }

    private Writer getWrapperWriter(String wrapperName, File outDir) throws IOException {
        File file = new File(outDir, WordUtils.capitalize(wrapperName) + ".java");
        if (!outDir.exists()) {
            System.out.println("creating directory: " + outDir.getPath());
            outDir.mkdirs();
        }
        return new FileWriter(file);
    }

    private void process(Map<String, Object> data, Writer writer, Template template) throws IOException, TemplateException {
        template.process(data, writer);
    }

    private void writeWrapper(Map<String, Object> data, Template template, String wrapperName, File outDir) throws IOException {
        Writer writer = this.getWrapperWriter(wrapperName, outDir);
        try {
            this.process(data, writer, template);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        writer.flush();
        writer.close();
    }

    @Override
    public void fromJson(JsonObject job, String wrapperName, File outDir) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("wrapperName", WordUtils.capitalize(wrapperName));
        ArrayList<Generator.Prop> props = new ArrayList<Generator.Prop>();
        for (Map.Entry el : job) {
            Generator.Prop p = Util.getPropFromJsonEntry((String)el.getKey(), (JsonElement)el.getValue());
            props.add(p);
            System.out.println("Adding: " + p);
        }
        data.put("properties", props);
        this.writeWrapper(data, this.getJobTemplate(), wrapperName, outDir);
    }

    @Override
    public void fromSchema(Schema schema, String wrapperName, File outDir) throws IOException {
        if (wrapperName == null) {
            wrapperName = schema.getTitle();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("wrapperName", WordUtils.capitalize(wrapperName));
        ArrayList<Generator.Prop> props = new ArrayList<Generator.Prop>();
        for (Map.Entry el : schema.getProperties()) {
            Generator.Prop p = Util.getPropFromJsonSchema((String)el.getKey(), (Schema)el.getValue());
            props.add(p);
            System.out.println("Adding: " + p);
        }
        data.put("properties", props);
        this.writeWrapper(data, this.getJobTemplate(), wrapperName, outDir);
    }

    public static class MyAppObjectWrapper
    extends DefaultObjectWrapper {
        public MyAppObjectWrapper(Version incompatibleImprovements) {
            super(incompatibleImprovements);
        }

        protected TemplateModel handleUnknownType(Object obj) throws TemplateModelException {
            if (obj instanceof Generator.Prop) {
                return new PropAdapter((Generator.Prop)obj, (ObjectWrapper)this);
            }
            return super.handleUnknownType(obj);
        }
    }

    public static class PropAdapter
    extends WrappingTemplateModel
    implements TemplateHashModel,
    AdapterTemplateModel {
        private final Generator.Prop prop;

        public PropAdapter(Generator.Prop prop, ObjectWrapper objectWrapper) {
            super(objectWrapper);
            this.prop = prop;
        }

        public Object getAdaptedObject(Class hint) {
            return this.prop;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            if (key.equals("origKey")) {
                return this.wrap(this.prop.origKey);
            }
            if (key.equals("methodName")) {
                return this.wrap(this.prop.methodName);
            }
            if (key.equals("returnType")) {
                return this.wrap(this.prop.returnType);
            }
            if (key.equals("optMethod")) {
                return this.wrap(this.prop.optMethod);
            }
            return null;
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }
    }
}

