/*
 * Decompiled with CFR 0.152.
 */
package io.appium.mitmproxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.appium.mitmproxy.InterceptedMessage;
import io.appium.mitmproxy.MessageSerializer;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MitmproxyServer
extends WebSocketServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketServer.class);
    private final Function<InterceptedMessage, InterceptedMessage> interceptor;
    private final MessageSerializer messageSerializer;

    MitmproxyServer(InetSocketAddress address, Function<InterceptedMessage, InterceptedMessage> interceptor) {
        super(address);
        this.interceptor = interceptor;
        this.messageSerializer = new MessageSerializer();
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        LOGGER.debug("new connection to websocket server" + conn.getRemoteSocketAddress());
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        LOGGER.debug("closed " + conn.getRemoteSocketAddress() + " with exit code " + code + " additional info: " + reason);
    }

    public void onMessage(WebSocket conn, String message) {
        LOGGER.debug("received message from " + conn.getRemoteSocketAddress() + " : " + message);
    }

    public void onMessage(WebSocket conn, ByteBuffer rawInputMessage) {
        InterceptedMessage modifiedMessage;
        InterceptedMessage incomingMessage = this.messageSerializer.deserializeMessage(rawInputMessage);
        InterceptedMessage messageToSendBack = modifiedMessage = this.interceptor.apply(incomingMessage);
        if (modifiedMessage == null) {
            messageToSendBack = incomingMessage;
        }
        try {
            conn.send(this.messageSerializer.serializeMessage(messageToSendBack));
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage());
        }
    }

    public void onError(WebSocket conn, Exception ex) {
        LOGGER.error("an error occured on connection " + conn.getRemoteSocketAddress() + ":" + ex);
    }

    public void onStart() {
        LOGGER.info("websocket server started successfully");
    }
}

