/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.utils;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;

public final class PreOperationUtils {
    private static final String MONTH_OF_YEAR = "month_of_year";
    private static final String WEEK_OF_YEAR = "week_of_year";
    private static final String WEEK_OF_MONTH = "week_of_month";
    private static final String DAY_OF_YEAR = "day_of_year";
    private static final String DAY_OF_MONTH = "day_of_month";
    private static final String DAY_OF_WEEK = "day_of_week";
    private static final String HOUR_OF_DAY = "hour_of_day";
    private static final String MINUTE_OF_HOUR = "minute_of_hour";

    public static int getFromDateTime(OffsetDateTime dateTime, String field) {
        switch (field) {
            case "minute_of_hour": {
                return dateTime.get(ChronoField.MINUTE_OF_HOUR);
            }
            case "hour_of_day": {
                return dateTime.get(ChronoField.HOUR_OF_DAY);
            }
            case "day_of_week": {
                return dateTime.get(ChronoField.DAY_OF_WEEK);
            }
            case "day_of_month": {
                return dateTime.get(ChronoField.DAY_OF_MONTH);
            }
            case "day_of_year": {
                return dateTime.get(ChronoField.DAY_OF_YEAR);
            }
            case "week_of_month": {
                return dateTime.get(ChronoField.ALIGNED_WEEK_OF_MONTH);
            }
            case "week_of_year": {
                return dateTime.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
            }
            case "month_of_year": {
                return dateTime.get(ChronoField.MONTH_OF_YEAR);
            }
        }
        throw new IllegalArgumentException("Operand does not represent a valid field");
    }

    public static OffsetDateTime getDateTime(long epoch, String zoneOffSet) {
        try {
            Instant instant = PreOperationUtils.isEpochInMillis(epoch) ? Instant.ofEpochMilli(epoch) : Instant.ofEpochSecond(epoch);
            if (zoneOffSet != null && !zoneOffSet.trim().isEmpty()) {
                return instant.atOffset(ZoneOffset.of(zoneOffSet));
            }
            return instant.atOffset(ZoneOffset.UTC);
        }
        catch (Exception e) {
            return PreOperationUtils.throwInvalidDate();
        }
    }

    public static OffsetDateTime getDateTime(String dateTimeStr, String zoneOffSet) {
        try {
            Instant instant = Instant.parse(dateTimeStr);
            if (zoneOffSet != null && !zoneOffSet.trim().isEmpty()) {
                return instant.atOffset(ZoneOffset.of(zoneOffSet));
            }
            return instant.atOffset(ZoneOffset.UTC);
        }
        catch (Exception e) {
            PreOperationUtils.throwInvalidDate();
            throw new IllegalStateException();
        }
    }

    public static LocalDateTime getLocalDateTime(long epoch, String timeZone) {
        try {
            long epochSecond = Long.divideUnsigned(epoch, 1000L);
            long nanoOfSecond = Long.remainderUnsigned(epoch, 1000L) * 1000000L;
            ZoneOffset zoneOffSet = timeZone == null ? ZoneOffset.UTC : ZoneOffset.of(timeZone);
            return LocalDateTime.ofEpochSecond(epochSecond, (int)nanoOfSecond, zoneOffSet);
        }
        catch (Exception e) {
            PreOperationUtils.throwInvalidDate();
            throw new IllegalStateException();
        }
    }

    public static boolean isNumericRepresentation(JsonNode evaluatedNode) {
        try {
            Double.parseDouble(evaluatedNode.asText());
        }
        catch (NumberFormatException exception) {
            return false;
        }
        return true;
    }

    private static OffsetDateTime throwInvalidDate() {
        throw new IllegalArgumentException("Operand doesnot represent a valid date");
    }

    private static boolean isEpochInMillis(long epoch) {
        return String.valueOf(epoch).length() >= 12;
    }

    private PreOperationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

