/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.string;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.ExpressionVisitor;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.expressions.string.StringJsonPathBasedExpression;

public class EmptyExpression
extends StringJsonPathBasedExpression {
    public EmptyExpression() {
        super(ExpressionType.empty);
    }

    public EmptyExpression(String path, Boolean defaultResult, PreOperation<?> preoperation) {
        super(ExpressionType.empty, path, null, false, false, defaultResult, preoperation);
    }

    @Override
    protected boolean evaluate(String data, String value, boolean ignoreCase) {
        return Strings.isNullOrEmpty((String)data);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, JsonNode jsonNode) {
        return visitor.visit(this, jsonNode);
    }

    public static EmptyExpressionBuilder builder() {
        return new EmptyExpressionBuilder();
    }

    public static class EmptyExpressionBuilder {
        private String path;
        private Boolean defaultResult;
        private PreOperation<?> preoperation;

        EmptyExpressionBuilder() {
        }

        public EmptyExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public EmptyExpressionBuilder defaultResult(Boolean defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public EmptyExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public EmptyExpression build() {
            return new EmptyExpression(this.path, this.defaultResult, this.preoperation);
        }

        public String toString() {
            return "EmptyExpression.EmptyExpressionBuilder(path=" + this.path + ", defaultResult=" + this.defaultResult + ", preoperation=" + this.preoperation + ")";
        }
    }
}

