/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.preoperation.numeric;

import io.appform.jsonrules.expressions.preoperation.PreOperationType;
import io.appform.jsonrules.expressions.preoperation.numeric.NumericPreOperation;

public class DivideOperation
extends NumericPreOperation {
    public DivideOperation() {
        super(PreOperationType.divide);
    }

    public DivideOperation(Number operand) {
        super(PreOperationType.divide, operand);
    }

    @Override
    public long compute(long leftOperand, long rightOperand) {
        if (rightOperand == 0L) {
            throw new IllegalArgumentException("Division by zero not allowed");
        }
        return leftOperand / rightOperand;
    }

    @Override
    public double compute(double leftOperand, double rightOperand) {
        if (Double.isInfinite(leftOperand) || Double.isInfinite(rightOperand)) {
            throw new IllegalArgumentException("Atleast one of the operands is infinite");
        }
        if (rightOperand == 0.0) {
            throw new IllegalArgumentException("Division by zero not allowed");
        }
        return leftOperand / rightOperand;
    }

    public static DivideOperationBuilder builder() {
        return new DivideOperationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DivideOperation)) {
            return false;
        }
        DivideOperation other = (DivideOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DivideOperation;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "DivideOperation(super=" + super.toString() + ")";
    }

    public static class DivideOperationBuilder {
        private Number operand;

        DivideOperationBuilder() {
        }

        public DivideOperationBuilder operand(Number operand) {
            this.operand = operand;
            return this;
        }

        public DivideOperation build() {
            return new DivideOperation(this.operand);
        }

        public String toString() {
            return "DivideOperation.DivideOperationBuilder(operand=" + this.operand + ")";
        }
    }
}

