/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.preoperation.array;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.expressions.preoperation.PreOperationType;

public class SizeOperation
extends PreOperation<Number> {
    public SizeOperation() {
        super(PreOperationType.size);
    }

    @Override
    public Number compute(ExpressionEvaluationContext context) {
        JsonNode node = context.getNode();
        if (node.isArray()) {
            return ((ArrayNode)node).size();
        }
        throw new IllegalArgumentException("Size operation is not supported");
    }

    public static SizeOperationBuilder builder() {
        return new SizeOperationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SizeOperation)) {
            return false;
        }
        SizeOperation other = (SizeOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SizeOperation;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SizeOperation(super=" + super.toString() + ")";
    }

    public static class SizeOperationBuilder {
        SizeOperationBuilder() {
        }

        public SizeOperation build() {
            return new SizeOperation();
        }

        public String toString() {
            return "SizeOperation.SizeOperationBuilder()";
        }
    }
}

