/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.numeric;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.ExpressionVisitor;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;

public class BetweenExpression
extends JsonPathBasedExpression {
    private Number lowerBound;
    private Number upperBound;
    private boolean includeLowerBound;
    private boolean includeUpperBound;

    public BetweenExpression() {
        super(ExpressionType.between);
    }

    public BetweenExpression(String path, Number lowerbound, Number upperBound, boolean includeLowerBound, boolean includeUpperBound, boolean defaultResult, PreOperation<?> preoperation) {
        super(ExpressionType.between, path, defaultResult, preoperation);
        this.lowerBound = lowerbound;
        this.upperBound = upperBound;
        this.includeLowerBound = includeLowerBound;
        this.includeUpperBound = includeUpperBound;
    }

    @Override
    protected boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        if (null == evaluatedNode || !evaluatedNode.isNumber()) {
            return false;
        }
        boolean finalResult = false;
        if (evaluatedNode.isIntegralNumber()) {
            boolean bl = this.includeLowerBound ? evaluatedNode.asLong() >= this.lowerBound.longValue() : (finalResult = evaluatedNode.asLong() > this.lowerBound.longValue());
            finalResult &= this.includeUpperBound ? evaluatedNode.asLong() <= this.upperBound.longValue() : evaluatedNode.asLong() < this.upperBound.longValue();
        } else if (evaluatedNode.isFloatingPointNumber()) {
            boolean bl = this.includeLowerBound ? evaluatedNode.doubleValue() >= this.lowerBound.doubleValue() : (finalResult = evaluatedNode.doubleValue() > this.lowerBound.doubleValue());
            finalResult &= this.includeUpperBound ? evaluatedNode.doubleValue() <= this.upperBound.doubleValue() : evaluatedNode.doubleValue() < this.upperBound.doubleValue();
        }
        return finalResult;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, JsonNode jsonNode) {
        return visitor.visit(this, jsonNode);
    }

    public static BetweenExpressionBuilder builder() {
        return new BetweenExpressionBuilder();
    }

    public Number getLowerBound() {
        return this.lowerBound;
    }

    public Number getUpperBound() {
        return this.upperBound;
    }

    public boolean isIncludeLowerBound() {
        return this.includeLowerBound;
    }

    public boolean isIncludeUpperBound() {
        return this.includeUpperBound;
    }

    public void setLowerBound(Number lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(Number upperBound) {
        this.upperBound = upperBound;
    }

    public void setIncludeLowerBound(boolean includeLowerBound) {
        this.includeLowerBound = includeLowerBound;
    }

    public void setIncludeUpperBound(boolean includeUpperBound) {
        this.includeUpperBound = includeUpperBound;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BetweenExpression)) {
            return false;
        }
        BetweenExpression other = (BetweenExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIncludeLowerBound() != other.isIncludeLowerBound()) {
            return false;
        }
        if (this.isIncludeUpperBound() != other.isIncludeUpperBound()) {
            return false;
        }
        Number this$lowerBound = this.getLowerBound();
        Number other$lowerBound = other.getLowerBound();
        if (this$lowerBound == null ? other$lowerBound != null : !this$lowerBound.equals(other$lowerBound)) {
            return false;
        }
        Number this$upperBound = this.getUpperBound();
        Number other$upperBound = other.getUpperBound();
        return !(this$upperBound == null ? other$upperBound != null : !this$upperBound.equals(other$upperBound));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BetweenExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIncludeLowerBound() ? 79 : 97);
        result = result * 59 + (this.isIncludeUpperBound() ? 79 : 97);
        Number $lowerBound = this.getLowerBound();
        result = result * 59 + ($lowerBound == null ? 43 : $lowerBound.hashCode());
        Number $upperBound = this.getUpperBound();
        result = result * 59 + ($upperBound == null ? 43 : $upperBound.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BetweenExpression(super=" + super.toString() + ", lowerBound=" + this.getLowerBound() + ", upperBound=" + this.getUpperBound() + ", includeLowerBound=" + this.isIncludeLowerBound() + ", includeUpperBound=" + this.isIncludeUpperBound() + ")";
    }

    public static class BetweenExpressionBuilder {
        private String path;
        private Number lowerbound;
        private Number upperBound;
        private boolean includeLowerBound;
        private boolean includeUpperBound;
        private boolean defaultResult;
        private PreOperation<?> preoperation;

        BetweenExpressionBuilder() {
        }

        public BetweenExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public BetweenExpressionBuilder lowerbound(Number lowerbound) {
            this.lowerbound = lowerbound;
            return this;
        }

        public BetweenExpressionBuilder upperBound(Number upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        public BetweenExpressionBuilder includeLowerBound(boolean includeLowerBound) {
            this.includeLowerBound = includeLowerBound;
            return this;
        }

        public BetweenExpressionBuilder includeUpperBound(boolean includeUpperBound) {
            this.includeUpperBound = includeUpperBound;
            return this;
        }

        public BetweenExpressionBuilder defaultResult(boolean defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public BetweenExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public BetweenExpression build() {
            return new BetweenExpression(this.path, this.lowerbound, this.upperBound, this.includeLowerBound, this.includeUpperBound, this.defaultResult, this.preoperation);
        }

        public String toString() {
            return "BetweenExpression.BetweenExpressionBuilder(path=" + this.path + ", lowerbound=" + this.lowerbound + ", upperBound=" + this.upperBound + ", includeLowerBound=" + this.includeLowerBound + ", includeUpperBound=" + this.includeUpperBound + ", defaultResult=" + this.defaultResult + ", preoperation=" + this.preoperation + ")";
        }
    }
}

