/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.debug;

import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.appform.jsonrules.Expression;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.ExpressionVisitor;
import io.appform.jsonrules.expressions.array.ContainsAllExpression;
import io.appform.jsonrules.expressions.array.ContainsAnyExpression;
import io.appform.jsonrules.expressions.array.InExpression;
import io.appform.jsonrules.expressions.array.NotInExpression;
import io.appform.jsonrules.expressions.composite.AndExpression;
import io.appform.jsonrules.expressions.composite.NotExpression;
import io.appform.jsonrules.expressions.composite.OrExpression;
import io.appform.jsonrules.expressions.debug.FailureDetail;
import io.appform.jsonrules.expressions.equality.EqualsExpression;
import io.appform.jsonrules.expressions.equality.NotEqualsExpression;
import io.appform.jsonrules.expressions.meta.ExistsExpression;
import io.appform.jsonrules.expressions.meta.NotExistsExpression;
import io.appform.jsonrules.expressions.numeric.BetweenExpression;
import io.appform.jsonrules.expressions.numeric.GreaterThanEqualsExpression;
import io.appform.jsonrules.expressions.numeric.GreaterThanExpression;
import io.appform.jsonrules.expressions.numeric.LessThanEqualsExpression;
import io.appform.jsonrules.expressions.numeric.LessThanExpression;
import io.appform.jsonrules.expressions.string.EmptyExpression;
import io.appform.jsonrules.expressions.string.EndsWithExpression;
import io.appform.jsonrules.expressions.string.MatchesExpression;
import io.appform.jsonrules.expressions.string.NotEmptyExpression;
import io.appform.jsonrules.expressions.string.StartsWithExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ExpressionDebugger
implements ExpressionVisitor<FailureDetail> {
    private static final FailureDetail DEFAULT_SUCCESS_RESPONSE = FailureDetail.builder().failed(false).build();
    private final Expression expression;
    private final JsonNode node;

    public FailureDetail debug() {
        return this.expression.accept(this, this.node);
    }

    @Override
    public FailureDetail visit(AndExpression expression, JsonNode node) {
        List<FailureDetail> details = this.evaluteChildren(expression.getChildren(), node);
        if (details.isEmpty()) {
            return DEFAULT_SUCCESS_RESPONSE;
        }
        return this.generateDetails(expression.getType(), details);
    }

    @Override
    public FailureDetail visit(OrExpression expression, JsonNode node) {
        List<FailureDetail> details = this.evaluteChildren(expression.getChildren(), node);
        if (details.size() < expression.getChildren().size()) {
            return DEFAULT_SUCCESS_RESPONSE;
        }
        return this.generateDetails(expression.getType(), details);
    }

    @Override
    public FailureDetail visit(NotExpression expression, JsonNode node) {
        List<FailureDetail> details = this.evaluteChildren(expression.getChildren(), node);
        if (details.size() == expression.getChildren().size()) {
            return DEFAULT_SUCCESS_RESPONSE;
        }
        return this.generateDetails(expression.getType(), details);
    }

    @Override
    public FailureDetail visit(ExistsExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Path [%s] doesn't exist", expression.getPath()));
    }

    @Override
    public FailureDetail visit(NotExistsExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Path [%s] exists", expression.getPath()));
    }

    @Override
    public FailureDetail visit(GreaterThanExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value of [%s] at path [%s] is not greater than [%s]", value, expression.getPath(), expression.getValue()));
    }

    @Override
    public FailureDetail visit(GreaterThanEqualsExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value of [%s] at path [%s] is less than [%s]", value, expression.getPath(), expression.getValue()));
    }

    @Override
    public FailureDetail visit(LessThanExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value of [%s] at path [%s] is not less than [%s]", value, expression.getPath(), expression.getValue()));
    }

    @Override
    public FailureDetail visit(LessThanEqualsExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value of [%s] at path [%s] is greater than [%s]", value, expression.getPath(), expression.getValue()));
    }

    @Override
    public FailureDetail visit(EqualsExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value of [%s] at path [%s] is not equals to [%s]", value, expression.getPath(), expression.getValue()));
    }

    @Override
    public FailureDetail visit(NotEqualsExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value of [%s] at path [%s] is equal to [%s]", value, expression.getPath(), expression.getValue()));
    }

    @Override
    public FailureDetail visit(EmptyExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value at path [%s] is not empty", expression.getPath()));
    }

    @Override
    public FailureDetail visit(NotEmptyExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value at path [%s] is empty", expression.getPath()));
    }

    @Override
    public FailureDetail visit(StartsWithExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value of [%s] at path [%s] doesn't start with [%s]", value, expression.getPath(), expression.getValue()));
    }

    @Override
    public FailureDetail visit(EndsWithExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value of [%s] at path [%s] doesn't end with [%s]", value, expression.getPath(), expression.getValue()));
    }

    @Override
    public FailureDetail visit(MatchesExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value of [%s] at path [%s] doesn't match with [%s]", value, expression.getPath(), expression.getValue()));
    }

    @Override
    public FailureDetail visit(InExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value of [%s] at path [%s] is not allowed", value, expression.getPath()));
    }

    @Override
    public FailureDetail visit(NotInExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value of [%s] at path [%s] is blocked", value, expression.getPath()));
    }

    @Override
    public FailureDetail visit(ContainsAnyExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("None of the values at path [%s] are allowed", expression.getPath()));
    }

    @Override
    public FailureDetail visit(ContainsAllExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Not all of the expected values at path [%s] are present", expression.getPath()));
    }

    @Override
    public FailureDetail visit(BetweenExpression expression, JsonNode node) {
        Object value = this.fetchValue(node, expression.getPath());
        return this.generateDetails(expression.getType(), expression.getPath(), value, expression.evaluate(node), String.format("Value of [%s] at path [%s] is not between [%s] & [%s]", value, expression.getPath(), expression.getLowerBound(), expression.getUpperBound()));
    }

    private List<FailureDetail> evaluteChildren(List<Expression> expressions, JsonNode node) {
        return expressions.stream().map(e -> e.accept(this, node)).filter(FailureDetail::isFailed).collect(Collectors.toList());
    }

    private FailureDetail generateDetails(ExpressionType type, List<FailureDetail> details) {
        return FailureDetail.builder().expressionType(type).failed(true).reason(details.stream().map(FailureDetail::getReason).flatMap(Collection::stream).collect(Collectors.toList())).build();
    }

    private FailureDetail generateDetails(ExpressionType type, String expressionPath, Object value, boolean result, String reason) {
        if (result) {
            return DEFAULT_SUCCESS_RESPONSE;
        }
        return FailureDetail.builder().expressionType(type).path(expressionPath).value(value).failed(true).reason(Collections.singletonList(reason)).build();
    }

    private Object fetchValue(JsonNode jsonNode, String path) {
        if (jsonNode != null && path != null) {
            try {
                return JsonPath.read((String)jsonNode.toString(), (String)path, (Predicate[])new Predicate[0]);
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    ExpressionDebugger(Expression expression, JsonNode node) {
        this.expression = expression;
        this.node = node;
    }

    public static ExpressionDebuggerBuilder builder() {
        return new ExpressionDebuggerBuilder();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public JsonNode getNode() {
        return this.node;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionDebugger)) {
            return false;
        }
        ExpressionDebugger other = (ExpressionDebugger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$expression = this.getExpression();
        Expression other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !((Object)this$expression).equals(other$expression)) {
            return false;
        }
        JsonNode this$node = this.getNode();
        JsonNode other$node = other.getNode();
        return !(this$node == null ? other$node != null : !this$node.equals(other$node));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExpressionDebugger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : ((Object)$expression).hashCode());
        JsonNode $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : $node.hashCode());
        return result;
    }

    public String toString() {
        return "ExpressionDebugger(expression=" + this.getExpression() + ", node=" + this.getNode() + ")";
    }

    public static class ExpressionDebuggerBuilder {
        private Expression expression;
        private JsonNode node;

        ExpressionDebuggerBuilder() {
        }

        public ExpressionDebuggerBuilder expression(Expression expression) {
            this.expression = expression;
            return this;
        }

        public ExpressionDebuggerBuilder node(JsonNode node) {
            this.node = node;
            return this;
        }

        public ExpressionDebugger build() {
            return new ExpressionDebugger(this.expression, this.node);
        }

        public String toString() {
            return "ExpressionDebugger.ExpressionDebuggerBuilder(expression=" + this.expression + ", node=" + this.node + ")";
        }
    }
}

