/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.composite;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.Expression;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.ExpressionVisitor;
import io.appform.jsonrules.expressions.composite.CompositeExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public class AndExpression
extends CompositeExpression {
    public AndExpression() {
        super(ExpressionType.and);
    }

    public AndExpression(List<Expression> children) {
        super(ExpressionType.and, children);
    }

    @Override
    protected boolean evaluate(ExpressionEvaluationContext context, List<Expression> children) {
        return children.stream().map(expression -> expression.evaluate(context)).allMatch(Predicate.isEqual(true));
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, JsonNode jsonNode) {
        return visitor.visit(this, jsonNode);
    }

    public static AndExpressionBuilder builder() {
        return new AndExpressionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AndExpression)) {
            return false;
        }
        AndExpression other = (AndExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AndExpression;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "AndExpression(super=" + super.toString() + ")";
    }

    public static class AndExpressionBuilder {
        private ArrayList<Expression> children;

        AndExpressionBuilder() {
        }

        public AndExpressionBuilder child(Expression child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
            return this;
        }

        public AndExpressionBuilder children(Collection<? extends Expression> children) {
            if (children == null) {
                throw new NullPointerException("children cannot be null");
            }
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.addAll(children);
            return this;
        }

        public AndExpressionBuilder clearChildren() {
            if (this.children != null) {
                this.children.clear();
            }
            return this;
        }

        public AndExpression build() {
            List<Expression> children;
            switch (this.children == null ? 0 : this.children.size()) {
                case 0: {
                    children = Collections.emptyList();
                    break;
                }
                case 1: {
                    children = Collections.singletonList(this.children.get(0));
                    break;
                }
                default: {
                    children = Collections.unmodifiableList(new ArrayList<Expression>(this.children));
                }
            }
            return new AndExpression(children);
        }

        public String toString() {
            return "AndExpression.AndExpressionBuilder(children=" + this.children + ")";
        }
    }
}

