/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.string;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.ExpressionVisitor;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.expressions.string.StringJsonPathBasedExpression;

public class EndsWithExpression
extends StringJsonPathBasedExpression {
    public EndsWithExpression() {
        super(ExpressionType.ends_with);
    }

    public EndsWithExpression(String path, String value, boolean ignoreCase, boolean extractValueFromPath, Boolean defaultResult, PreOperation<?> preoperation) {
        super(ExpressionType.ends_with, path, value, ignoreCase, extractValueFromPath, defaultResult, preoperation);
    }

    @Override
    protected boolean evaluate(String leftValue, String rightValue, boolean ignoreCase) {
        if (!Strings.isNullOrEmpty((String)leftValue) && !Strings.isNullOrEmpty((String)rightValue)) {
            if (ignoreCase) {
                return leftValue.toLowerCase().endsWith(rightValue.toLowerCase());
            }
            return leftValue.endsWith(rightValue);
        }
        return false;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, JsonNode jsonNode) {
        return visitor.visit(this, jsonNode);
    }

    public static EndsWithExpressionBuilder builder() {
        return new EndsWithExpressionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndsWithExpression)) {
            return false;
        }
        EndsWithExpression other = (EndsWithExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EndsWithExpression;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "EndsWithExpression(super=" + super.toString() + ")";
    }

    public static class EndsWithExpressionBuilder {
        private String path;
        private String value;
        private boolean ignoreCase;
        private boolean extractValueFromPath;
        private Boolean defaultResult;
        private PreOperation<?> preoperation;

        EndsWithExpressionBuilder() {
        }

        public EndsWithExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public EndsWithExpressionBuilder value(String value) {
            this.value = value;
            return this;
        }

        public EndsWithExpressionBuilder ignoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public EndsWithExpressionBuilder extractValueFromPath(boolean extractValueFromPath) {
            this.extractValueFromPath = extractValueFromPath;
            return this;
        }

        public EndsWithExpressionBuilder defaultResult(Boolean defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public EndsWithExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public EndsWithExpression build() {
            return new EndsWithExpression(this.path, this.value, this.ignoreCase, this.extractValueFromPath, this.defaultResult, this.preoperation);
        }

        public String toString() {
            return "EndsWithExpression.EndsWithExpressionBuilder(path=" + this.path + ", value=" + this.value + ", ignoreCase=" + this.ignoreCase + ", extractValueFromPath=" + this.extractValueFromPath + ", defaultResult=" + this.defaultResult + ", preoperation=" + this.preoperation + ")";
        }
    }
}

