/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.preoperation.string;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.expressions.preoperation.PreOperationType;

public class LengthOperation
extends PreOperation<Number> {
    private static final String EMPTY_STRING = "";

    public LengthOperation() {
        super(PreOperationType.length);
    }

    @Override
    public Number compute(ExpressionEvaluationContext context) {
        JsonNode node = context.getNode();
        if (node.isTextual()) {
            return node.asText(EMPTY_STRING).length();
        }
        throw new IllegalArgumentException("Length operation is not supported");
    }

    public static LengthOperationBuilder builder() {
        return new LengthOperationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LengthOperation)) {
            return false;
        }
        LengthOperation other = (LengthOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LengthOperation;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "LengthOperation(super=" + super.toString() + ")";
    }

    public static class LengthOperationBuilder {
        LengthOperationBuilder() {
        }

        public LengthOperation build() {
            return new LengthOperation();
        }

        public String toString() {
            return "LengthOperation.LengthOperationBuilder()";
        }
    }
}

