/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.preoperation.numeric;

import io.appform.jsonrules.expressions.preoperation.PreOperationType;
import io.appform.jsonrules.expressions.preoperation.numeric.NumericPreOperation;

public class ModuloOperation
extends NumericPreOperation {
    public ModuloOperation() {
        super(PreOperationType.modulo);
    }

    public ModuloOperation(Number operand) {
        super(PreOperationType.modulo, operand);
    }

    @Override
    public long compute(long leftOperand, long rightOperand) {
        if (rightOperand == 0L) {
            throw new IllegalArgumentException("Division by zero not allowed");
        }
        return Long.remainderUnsigned(leftOperand, rightOperand);
    }

    @Override
    public double compute(double leftOperand, double rightOperand) {
        if (Double.isInfinite(leftOperand) || Double.isInfinite(rightOperand)) {
            throw new IllegalArgumentException("Atleast one of the operands is infinite");
        }
        if (rightOperand == 0.0) {
            throw new IllegalArgumentException("Division by zero not allowed");
        }
        return leftOperand % rightOperand;
    }

    public static ModuloOperationBuilder builder() {
        return new ModuloOperationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuloOperation)) {
            return false;
        }
        ModuloOperation other = (ModuloOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ModuloOperation;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ModuloOperation(super=" + super.toString() + ")";
    }

    public static class ModuloOperationBuilder {
        private Number operand;

        ModuloOperationBuilder() {
        }

        public ModuloOperationBuilder operand(Number operand) {
            this.operand = operand;
            return this;
        }

        public ModuloOperation build() {
            return new ModuloOperation(this.operand);
        }

        public String toString() {
            return "ModuloOperation.ModuloOperationBuilder(operand=" + this.operand + ")";
        }
    }
}

