/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.preoperation.date;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.OptionKeys;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.expressions.preoperation.PreOperationType;

public class DiffFromCurrentEpochOperation
extends PreOperation<Number> {
    protected DiffFromCurrentEpochOperation() {
        super(PreOperationType.current_epoch_diff);
    }

    private Number compute(JsonNode evaluatedNode, long currentEpoch) {
        if (evaluatedNode.isLong()) {
            return currentEpoch - evaluatedNode.asLong();
        }
        throw new IllegalArgumentException("Evaluated node does not represent a valid epoch");
    }

    @Override
    public Number compute(ExpressionEvaluationContext context) {
        try {
            long currentEpoch = (Long)context.getOptions().getOrDefault((Object)OptionKeys.SYSTEM_TIME, System.currentTimeMillis());
            return this.compute(context.getNode(), currentEpoch);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Operands does not represent a valid epoch", e);
        }
    }

    public static DiffFromCurrentEpochOperationBuilder builder() {
        return new DiffFromCurrentEpochOperationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiffFromCurrentEpochOperation)) {
            return false;
        }
        DiffFromCurrentEpochOperation other = (DiffFromCurrentEpochOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DiffFromCurrentEpochOperation;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "DiffFromCurrentEpochOperation(super=" + super.toString() + ")";
    }

    public static class DiffFromCurrentEpochOperationBuilder {
        DiffFromCurrentEpochOperationBuilder() {
        }

        public DiffFromCurrentEpochOperation build() {
            return new DiffFromCurrentEpochOperation();
        }

        public String toString() {
            return "DiffFromCurrentEpochOperation.DiffFromCurrentEpochOperationBuilder()";
        }
    }
}

