/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.numeric;

import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.utils.ComparisonUtils;

public abstract class NumericJsonPathBasedExpression
extends JsonPathBasedExpression {
    private Object value;
    private boolean extractValueFromPath;

    protected NumericJsonPathBasedExpression(ExpressionType type) {
        super(type);
    }

    protected NumericJsonPathBasedExpression(ExpressionType type, String path, Object value, boolean extractValueFromPath, boolean defaultResult, PreOperation<?> preoperation) {
        super(type, path, defaultResult, preoperation);
        this.value = value;
        this.extractValueFromPath = extractValueFromPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        Number numericalValue;
        if (null == evaluatedNode || !evaluatedNode.isNumber()) {
            return false;
        }
        if (this.extractValueFromPath) {
            JsonNode jsonNode = ComparisonUtils.mapper.valueToTree(JsonPath.using((Configuration)ComparisonUtils.SUPPRESS_EXCEPTION_CONFIG).parse(context.getNode().toString()).read(String.valueOf(this.value), new Predicate[0]));
            if (jsonNode == null) {
                return false;
            }
            if (jsonNode.isIntegralNumber()) {
                numericalValue = jsonNode.asLong();
            } else {
                if (!jsonNode.isFloatingPointNumber()) throw new IllegalArgumentException("Operand is not a number");
                numericalValue = jsonNode.asDouble();
            }
        } else {
            numericalValue = (Number)this.value;
        }
        int comparisonResult = 0;
        if (evaluatedNode.isIntegralNumber()) {
            comparisonResult = Long.compare(evaluatedNode.asLong(), numericalValue.longValue());
            return this.evaluate(context, comparisonResult);
        } else {
            if (!evaluatedNode.isFloatingPointNumber()) return this.evaluate(context, comparisonResult);
            comparisonResult = Double.compare(evaluatedNode.asDouble(), numericalValue.doubleValue());
        }
        return this.evaluate(context, comparisonResult);
    }

    protected abstract boolean evaluate(ExpressionEvaluationContext var1, int var2);

    public Object getValue() {
        return this.value;
    }

    public boolean isExtractValueFromPath() {
        return this.extractValueFromPath;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setExtractValueFromPath(boolean extractValueFromPath) {
        this.extractValueFromPath = extractValueFromPath;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumericJsonPathBasedExpression)) {
            return false;
        }
        NumericJsonPathBasedExpression other = (NumericJsonPathBasedExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.isExtractValueFromPath() == other.isExtractValueFromPath();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NumericJsonPathBasedExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isExtractValueFromPath() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "NumericJsonPathBasedExpression(super=" + super.toString() + ", value=" + this.getValue() + ", extractValueFromPath=" + this.isExtractValueFromPath() + ")";
    }
}

