/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.string;

import com.google.common.base.Strings;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.expressions.string.StringJsonPathBasedExpression;

public class MatchesExpression
extends StringJsonPathBasedExpression {
    public MatchesExpression() {
        super(ExpressionType.matches);
    }

    public MatchesExpression(String path, String value, boolean ignoreCase, boolean extractValueFromPath, Boolean defaultResult, PreOperation<?> preoperation) {
        super(ExpressionType.matches, path, value, ignoreCase, extractValueFromPath, defaultResult, preoperation);
    }

    @Override
    protected boolean evaluate(String leftValue, String rightValue, boolean ignoreCase) {
        if (!Strings.isNullOrEmpty((String)leftValue) && !Strings.isNullOrEmpty((String)rightValue)) {
            if (ignoreCase) {
                return leftValue.toLowerCase().matches(rightValue.toLowerCase());
            }
            return leftValue.matches(rightValue);
        }
        return false;
    }

    public static MatchesExpressionBuilder builder() {
        return new MatchesExpressionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatchesExpression)) {
            return false;
        }
        MatchesExpression other = (MatchesExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MatchesExpression;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "MatchesExpression(super=" + super.toString() + ")";
    }

    public static class MatchesExpressionBuilder {
        private String path;
        private String value;
        private boolean ignoreCase;
        private boolean extractValueFromPath;
        private Boolean defaultResult;
        private PreOperation<?> preoperation;

        MatchesExpressionBuilder() {
        }

        public MatchesExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public MatchesExpressionBuilder value(String value) {
            this.value = value;
            return this;
        }

        public MatchesExpressionBuilder ignoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public MatchesExpressionBuilder extractValueFromPath(boolean extractValueFromPath) {
            this.extractValueFromPath = extractValueFromPath;
            return this;
        }

        public MatchesExpressionBuilder defaultResult(Boolean defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public MatchesExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public MatchesExpression build() {
            return new MatchesExpression(this.path, this.value, this.ignoreCase, this.extractValueFromPath, this.defaultResult, this.preoperation);
        }

        public String toString() {
            return "MatchesExpression.MatchesExpressionBuilder(path=" + this.path + ", value=" + this.value + ", ignoreCase=" + this.ignoreCase + ", extractValueFromPath=" + this.extractValueFromPath + ", defaultResult=" + this.defaultResult + ", preoperation=" + this.preoperation + ")";
        }
    }
}

