/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.equality;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.utils.ComparisonUtils;

public class EqualsExpression
extends JsonPathBasedExpression {
    private Object value;
    private boolean extractValueFromPath;

    public EqualsExpression() {
        super(ExpressionType.equals);
    }

    public EqualsExpression(String path, Object value, boolean extractValueFromPath, boolean defaultResult, PreOperation<?> preoperation) {
        super(ExpressionType.equals, path, defaultResult, preoperation);
        this.value = value;
        this.extractValueFromPath = extractValueFromPath;
    }

    public EqualsExpression(String path, Object value, boolean extractValueFromPath, PreOperation<?> preoperation) {
        this(path, value, extractValueFromPath, false, preoperation);
    }

    public EqualsExpression(String path, Object value, PreOperation<?> preoperation) {
        this(path, value, false, preoperation);
    }

    @Override
    protected boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        if (this.extractValueFromPath) {
            return ComparisonUtils.compareForEquality(context, evaluatedNode, this.value);
        }
        return !ComparisonUtils.isNodeMissingOrNull(evaluatedNode) && ComparisonUtils.compare(evaluatedNode, this.value) == 0;
    }

    public static EqualsExpressionBuilder builder() {
        return new EqualsExpressionBuilder();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isExtractValueFromPath() {
        return this.extractValueFromPath;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setExtractValueFromPath(boolean extractValueFromPath) {
        this.extractValueFromPath = extractValueFromPath;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualsExpression)) {
            return false;
        }
        EqualsExpression other = (EqualsExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.isExtractValueFromPath() == other.isExtractValueFromPath();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EqualsExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isExtractValueFromPath() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "EqualsExpression(super=" + super.toString() + ", value=" + this.getValue() + ", extractValueFromPath=" + this.isExtractValueFromPath() + ")";
    }

    public static class EqualsExpressionBuilder {
        private String path;
        private Object value;
        private boolean extractValueFromPath;
        private boolean defaultResult;
        private PreOperation<?> preoperation;

        EqualsExpressionBuilder() {
        }

        public EqualsExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public EqualsExpressionBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public EqualsExpressionBuilder extractValueFromPath(boolean extractValueFromPath) {
            this.extractValueFromPath = extractValueFromPath;
            return this;
        }

        public EqualsExpressionBuilder defaultResult(boolean defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public EqualsExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public EqualsExpression build() {
            return new EqualsExpression(this.path, this.value, this.extractValueFromPath, this.defaultResult, this.preoperation);
        }

        public String toString() {
            return "EqualsExpression.EqualsExpressionBuilder(path=" + this.path + ", value=" + this.value + ", extractValueFromPath=" + this.extractValueFromPath + ", defaultResult=" + this.defaultResult + ", preoperation=" + this.preoperation + ")";
        }
    }
}

