/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.array;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.array.CollectionJsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class ContainsAnyExpression
extends CollectionJsonPathBasedExpression {
    public ContainsAnyExpression() {
        super(ExpressionType.contains_any);
    }

    public ContainsAnyExpression(String path, Set<Object> values, boolean extractValues, String valuesPath, boolean defaultResult, PreOperation<?> preoperation) {
        super(ExpressionType.contains_any, path, values, extractValues, valuesPath, defaultResult, null);
    }

    @Override
    protected boolean evaluate(JsonNode evaluatedNode, Set<Object> values) {
        if (null == values || values.isEmpty() || !evaluatedNode.isArray()) {
            return false;
        }
        HashSet pathValues = new HashSet((Collection)JsonPath.read((String)evaluatedNode.toString(), (String)"$", (Predicate[])new Predicate[0]));
        return !Sets.intersection(values, pathValues).isEmpty();
    }

    public static ContainsAnyExpressionBuilder builder() {
        return new ContainsAnyExpressionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainsAnyExpression)) {
            return false;
        }
        ContainsAnyExpression other = (ContainsAnyExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ContainsAnyExpression;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ContainsAnyExpression(super=" + super.toString() + ")";
    }

    public static class ContainsAnyExpressionBuilder {
        private String path;
        private ArrayList<Object> values;
        private boolean extractValues;
        private String valuesPath;
        private boolean defaultResult;
        private PreOperation<?> preoperation;

        ContainsAnyExpressionBuilder() {
        }

        public ContainsAnyExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ContainsAnyExpressionBuilder value(Object value) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(value);
            return this;
        }

        public ContainsAnyExpressionBuilder values(Collection<? extends Object> values) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.addAll(values);
            return this;
        }

        public ContainsAnyExpressionBuilder clearValues() {
            if (this.values != null) {
                this.values.clear();
            }
            return this;
        }

        public ContainsAnyExpressionBuilder extractValues(boolean extractValues) {
            this.extractValues = extractValues;
            return this;
        }

        public ContainsAnyExpressionBuilder valuesPath(String valuesPath) {
            this.valuesPath = valuesPath;
            return this;
        }

        public ContainsAnyExpressionBuilder defaultResult(boolean defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public ContainsAnyExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public ContainsAnyExpression build() {
            Set<Object> values;
            switch (this.values == null ? 0 : this.values.size()) {
                case 0: {
                    values = Collections.emptySet();
                    break;
                }
                case 1: {
                    values = Collections.singleton(this.values.get(0));
                    break;
                }
                default: {
                    values = new LinkedHashSet(this.values.size() < 0x40000000 ? 1 + this.values.size() + (this.values.size() - 3) / 3 : Integer.MAX_VALUE);
                    values.addAll(this.values);
                    values = Collections.unmodifiableSet(values);
                }
            }
            return new ContainsAnyExpression(this.path, values, this.extractValues, this.valuesPath, this.defaultResult, this.preoperation);
        }

        public String toString() {
            return "ContainsAnyExpression.ContainsAnyExpressionBuilder(path=" + this.path + ", values=" + this.values + ", extractValues=" + this.extractValues + ", valuesPath=" + this.valuesPath + ", defaultResult=" + this.defaultResult + ", preoperation=" + this.preoperation + ")";
        }
    }
}

