package ${package}.domain;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;

import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by shao_win on 2017/5/26.
 */
public final class ResourceDescription {
    private String basePath;
    private List<MethodDescription> calls;


    public ResourceDescription(String basePath) {
        this.basePath = basePath;
        this.calls = Lists.newArrayList();
    }

    public void addMethod(String path, ResourceMethodInvoker method) {
        String produces = mostPreferredOrNull(Arrays.asList(method.getProduces()));
        String consumes = mostPreferredOrNull(Arrays.asList(method.getConsumes()));
        for (String verb : method.getHttpMethods()) {
            calls.add(new MethodDescription(verb, path, produces, consumes));
        }
    }

    private static String mostPreferredOrNull(List<MediaType> preferred) {
        if (preferred.isEmpty()) {
            return null;
        } else {
            return preferred.get(0).toString();
        }
    }

    public static List<ResourceDescription> fromBoundResourceInvokers(Set<Map.Entry<String, List<ResourceInvoker>>> bound) {
        Map<String, ResourceDescription> descriptions = Maps.newHashMap();
        for (Map.Entry<String, List<ResourceInvoker>> entry : bound) {
            ResourceMethodInvoker aMethod = (ResourceMethodInvoker) entry.getValue().get(0);
            String basePath = aMethod.getMethod().getDeclaringClass().getAnnotation(Path.class).value();
            if (!descriptions.containsKey(basePath)) {
                descriptions.put(basePath, new ResourceDescription(basePath));
            }
            for (ResourceInvoker invoker : entry.getValue()) {
                ResourceMethodInvoker method = (ResourceMethodInvoker) invoker;
                descriptions.get(basePath).addMethod(basePath, method);
            }
        }
        return Lists.newLinkedList(descriptions.values());
    }

    public String getBasePath() {
        return basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public List<MethodDescription> getCalls() {
        return calls;
    }

    public void setCalls(List<MethodDescription> calls) {
        this.calls = calls;
    }
}
