/*
 * Decompiled with CFR 0.152.
 */
package io.apitestbase.core.teststep;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQTopic;
import com.ibm.mq.headers.MQDataException;
import com.ibm.mq.headers.MQHeader;
import com.ibm.mq.headers.MQHeaderIterator;
import com.ibm.mq.headers.MQMD;
import com.ibm.mq.headers.MQRFH2;
import io.apitestbase.core.teststep.APIResponse;
import io.apitestbase.core.teststep.BasicTeststepRun;
import io.apitestbase.core.teststep.MQCheckQueueDepthResponse;
import io.apitestbase.core.teststep.MQDequeueResponse;
import io.apitestbase.core.teststep.TeststepRunner;
import io.apitestbase.models.endpoint.Endpoint;
import io.apitestbase.models.endpoint.MQConnectionMode;
import io.apitestbase.models.endpoint.MQEndpointProperties;
import io.apitestbase.models.teststep.MQDestinationType;
import io.apitestbase.models.teststep.MQRFH2Folder;
import io.apitestbase.models.teststep.MQRFH2Header;
import io.apitestbase.models.teststep.MQTeststepProperties;
import io.apitestbase.models.teststep.Teststep;
import io.apitestbase.models.teststep.apirequest.MQEnqueueOrPublishFromFileRequest;
import io.apitestbase.models.teststep.apirequest.MQEnqueueOrPublishFromTextRequest;
import io.apitestbase.models.teststep.apirequest.MQRequest;
import io.apitestbase.utils.GeneralUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTeststepRunner
extends TeststepRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MQTeststepRunner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicTeststepRun _run() throws Exception {
        Teststep teststep = this.getTeststep();
        String action = teststep.getAction();
        if (teststep.getAction() == null) {
            throw new Exception("Action not specified.");
        }
        MQTeststepProperties teststepProperties = (MQTeststepProperties)teststep.getOtherProperties();
        if (teststepProperties.getDestinationType() == null) {
            throw new Exception("Destination type not specified.");
        }
        BasicTeststepRun basicTeststepRun = new BasicTeststepRun();
        APIResponse response = null;
        Endpoint endpoint = teststep.getEndpoint();
        MQEndpointProperties endpointProperties = (MQEndpointProperties)endpoint.getOtherProperties();
        MQQueueManager queueManager = null;
        try {
            if (endpointProperties.getConnectionMode() == MQConnectionMode.BINDINGS) {
                queueManager = new MQQueueManager(endpointProperties.getQueueManagerName());
            } else {
                Hashtable<String, Object> qmConnProperties = new Hashtable<String, Object>();
                qmConnProperties.put("hostname", endpoint.getHost());
                qmConnProperties.put("port", endpoint.getPort());
                qmConnProperties.put("channel", endpointProperties.getSvrConnChannelName());
                queueManager = new MQQueueManager(endpointProperties.getQueueManagerName(), qmConnProperties);
            }
            if (MQDestinationType.QUEUE == teststepProperties.getDestinationType()) {
                response = this.doQueueAction(queueManager, teststepProperties.getQueueName(), action, (MQRequest)teststep.getApiRequest());
            } else if (MQDestinationType.TOPIC == teststepProperties.getDestinationType()) {
                this.doTopicAction(queueManager, teststepProperties.getTopicString(), action, (MQRequest)teststep.getApiRequest());
            }
        }
        finally {
            if (queueManager != null) {
                queueManager.disconnect();
            }
        }
        basicTeststepRun.setResponse(response);
        return basicTeststepRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIResponse doQueueAction(MQQueueManager queueManager, String queueName, String action, MQRequest apiRequest) throws Exception {
        MQCheckQueueDepthResponse response;
        block14: {
            response = null;
            int openOptions = 8194;
            try (MQQueue queue = null;){
                if ("CheckDepth".equals(action)) {
                    openOptions += 32;
                } else if ("Enqueue".equals(action)) {
                    openOptions += 16;
                }
                try {
                    queue = queueManager.accessQueue(queueName, openOptions, null, null, null);
                }
                catch (MQException mqEx) {
                    if (mqEx.getCompCode() == 2 && mqEx.getReason() == 2085) {
                        throw new Exception("Queue \"" + queueName + "\" not found.");
                    }
                    throw mqEx;
                }
                if ("Clear".equals(action)) {
                    this.clearQueue(queue);
                    break block14;
                }
                if ("CheckDepth".equals(action)) {
                    response = new MQCheckQueueDepthResponse();
                    response.setQueueDepth(queue.getCurrentDepth());
                    break block14;
                }
                if ("Dequeue".equals(action)) {
                    response = this.dequeue(queue);
                    break block14;
                }
                if ("Enqueue".equals(action)) {
                    this.enqueue(queue, apiRequest);
                    break block14;
                }
                throw new Exception("Unrecognized action " + action + ".");
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTopicAction(MQQueueManager queueManager, String topicString, String action, MQRequest apiRequest) throws Exception {
        block6: {
            if ("".equals(StringUtils.trimToEmpty((String)topicString))) {
                throw new Exception("Topic string not specified.");
            }
            try (MQTopic publisher = null;){
                publisher = queueManager.accessTopic(topicString, null, 2, 16);
                if ("Publish".equals(action)) {
                    MQMessage message = this.buildMessage(apiRequest);
                    publisher.put(message);
                    break block6;
                }
                throw new Exception("Unrecognized action " + action + ".");
            }
        }
    }

    private MQMessage buildMessage(MQRequest apiRequest) throws Exception {
        MQMessage message;
        if (apiRequest instanceof MQEnqueueOrPublishFromTextRequest) {
            MQEnqueueOrPublishFromTextRequest request = (MQEnqueueOrPublishFromTextRequest)apiRequest;
            message = this.buildMessageFromText(request.getBody(), request.getRfh2Header());
        } else {
            MQEnqueueOrPublishFromFileRequest request = (MQEnqueueOrPublishFromFileRequest)apiRequest;
            message = this.buildMessageFromFile(request.getFileContent());
        }
        return message;
    }

    private void enqueue(MQQueue queue, MQRequest apiRequest) throws Exception {
        MQMessage message = this.buildMessage(apiRequest);
        MQPutMessageOptions pmo = new MQPutMessageOptions();
        queue.put(message, pmo);
    }

    private MQMessage buildMessageFromText(String body, MQRFH2Header rfh2Header) throws IOException, MQDataException {
        if (body == null) {
            throw new IllegalArgumentException("Message body can not be null.");
        }
        MQMessage message = new MQMessage();
        MQMD mqmd = new MQMD();
        message.putDateTime = new GregorianCalendar();
        mqmd.setEncoding(546);
        if (rfh2Header == null) {
            mqmd.copyTo((com.ibm.mq.MQMD)message);
        } else {
            mqmd.setFormat("MQHRF2  ");
            mqmd.setCodedCharSetId(0);
            mqmd.setPersistence(1);
            mqmd.copyTo((com.ibm.mq.MQMD)message);
            MQRFH2 mqrfh2 = new MQRFH2();
            mqrfh2.setFolderStrings(rfh2Header.getFolderStrings());
            mqrfh2.write((DataOutput)message);
        }
        message.writeString(body);
        return message;
    }

    private MQMessage buildMessageFromFile(byte[] bytes) throws MQDataException, IOException {
        MQMD mqmdHeader;
        if (bytes == null) {
            throw new IllegalArgumentException("File can not be null.");
        }
        MQMessage message = new MQMessage();
        try {
            mqmdHeader = new MQMD((DataInput)new DataInputStream(new ByteArrayInputStream(bytes)), 546, 0);
        }
        catch (Exception e) {
            LOGGER.info("Not able to construct MQMD out of the bytes. Exception details: ", (Throwable)e);
            mqmdHeader = null;
        }
        if (mqmdHeader != null && "MD  ".equals(mqmdHeader.getStrucId()) && (1 == mqmdHeader.getVersion() || 2 == mqmdHeader.getVersion())) {
            LOGGER.info("MQMD constructed. Writing other bytes as application data.");
            message.putDateTime = new GregorianCalendar();
            mqmdHeader.copyTo((com.ibm.mq.MQMD)message);
            message.persistence = 1;
            message.write(bytes, 364, bytes.length - 364);
        } else {
            LOGGER.info("No valid MQMD. Writing all bytes as application data.");
            message.write(bytes);
        }
        return message;
    }

    private MQDequeueResponse dequeue(MQQueue queue) throws MQException, IOException, MQDataException {
        MQDequeueResponse result;
        block4: {
            result = null;
            MQGetMessageOptions getOptions = new MQGetMessageOptions();
            getOptions.options = 0x2002000;
            MQMessage message = new MQMessage();
            try {
                queue.get(message, getOptions);
                result = new MQDequeueResponse();
                MQRFH2Header mqrfh2Header = null;
                MQHeaderIterator it = new MQHeaderIterator((DataInput)message);
                while (it.hasNext()) {
                    MQHeader header = it.nextHeader();
                    if (!(header instanceof MQRFH2)) continue;
                    mqrfh2Header = new MQRFH2Header();
                    MQRFH2 mqrfh2 = (MQRFH2)header;
                    String[] folderStrings = mqrfh2.getFolderStrings();
                    for (int i = 0; i < folderStrings.length; ++i) {
                        MQRFH2Folder mqrfh2Folder = new MQRFH2Folder();
                        mqrfh2Folder.setString(folderStrings[i]);
                        GeneralUtils.validateMQRFH2FolderStringAndSetFolderName((MQRFH2Folder)mqrfh2Folder);
                        mqrfh2Header.getFolders().add(mqrfh2Folder);
                    }
                }
                result.setMqrfh2Header(mqrfh2Header);
                result.setBodyAsText(it.getBodyAsText());
            }
            catch (MQException mqEx) {
                if (mqEx.getCompCode() == 2 && mqEx.getReason() == 2033) break block4;
                throw mqEx;
            }
        }
        return result;
    }

    private void clearQueue(MQQueue queue) throws MQException {
        MQGetMessageOptions getOptions = new MQGetMessageOptions();
        getOptions.options = 8192;
        while (true) {
            MQMessage message = new MQMessage();
            try {
                queue.get(message, getOptions);
            }
            catch (MQException mqEx) {
                if (mqEx.getCompCode() != 2 || mqEx.getReason() != 2033) {
                    throw mqEx;
                }
                return;
            }
        }
    }
}

