/*
 * Decompiled with CFR 0.152.
 */
package io.apitestbase.core.teststep;

import com.ibm.broker.config.proxy.ActivityLogEntry;
import com.ibm.broker.config.proxy.ActivityLogProxy;
import com.ibm.broker.config.proxy.ApplicationProxy;
import com.ibm.broker.config.proxy.BrokerConnectionParameters;
import com.ibm.broker.config.proxy.BrokerProxy;
import com.ibm.broker.config.proxy.ExecutionGroupProxy;
import com.ibm.broker.config.proxy.MessageFlowProxy;
import io.apitestbase.core.testcase.TestcaseRunContext;
import io.apitestbase.core.teststep.BasicTeststepRun;
import io.apitestbase.core.teststep.TeststepRunner;
import io.apitestbase.models.teststep.IIBTeststepProperties;
import io.apitestbase.models.teststep.Teststep;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IIBTeststepRunnerBase
extends TeststepRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(IIBTeststepRunnerBase.class);
    private BrokerConnectionParameters bcp;

    protected void setBrokerConnectionParameters(BrokerConnectionParameters bcp) {
        this.bcp = bcp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BasicTeststepRun run() throws Exception {
        Teststep teststep = this.getTeststep();
        String action = teststep.getAction();
        if (action == null) {
            throw new Exception("Action not specified.");
        }
        BasicTeststepRun basicTeststepRun = new BasicTeststepRun();
        IIBTeststepProperties teststepProperties = (IIBTeststepProperties)teststep.getOtherProperties();
        BrokerProxy brokerProxy = null;
        try {
            brokerProxy = BrokerProxy.getInstance((BrokerConnectionParameters)this.bcp);
            brokerProxy.setSynchronous(90000);
            MessageFlowProxy messageFlowProxy = this.getMessageFlowProxy(brokerProxy, teststepProperties.getIntegrationServerName(), teststepProperties.getApplicationName(), teststepProperties.getMessageFlowName());
            switch (action) {
                case "Start": {
                    this.start(messageFlowProxy, basicTeststepRun);
                    return basicTeststepRun;
                }
                case "Stop": {
                    this.stop(messageFlowProxy, basicTeststepRun);
                    return basicTeststepRun;
                }
                case "WaitForProcessingCompletion": {
                    this.waitForProcessingCompletion(messageFlowProxy, teststepProperties.getWaitForProcessingCompletionTimeout());
                    return basicTeststepRun;
                }
                default: {
                    throw new Exception("Unrecognized action " + action);
                }
            }
        }
        finally {
            if (brokerProxy != null) {
                brokerProxy.disconnect();
            }
        }
    }

    private MessageFlowProxy getMessageFlowProxy(BrokerProxy brokerProxy, String integrationServerName, String applicationName, String messageFlowName) throws Exception {
        MessageFlowProxy messageFlowProxy;
        String integrationNodeName = brokerProxy.getName();
        ExecutionGroupProxy integrationServerProxy = brokerProxy.getExecutionGroupByName(integrationServerName);
        if (integrationServerProxy == null) {
            throw new Exception("Integration server \"" + integrationServerName + "\" not found on integration node \"" + integrationNodeName + "\".");
        }
        if (!integrationServerProxy.isRunning()) {
            throw new Exception("Integration server \"" + integrationServerName + "\" not running.");
        }
        if ("".equals(StringUtils.trimToEmpty((String)applicationName))) {
            messageFlowProxy = integrationServerProxy.getMessageFlowByName(messageFlowName);
            if (messageFlowProxy == null) {
                throw new Exception("Message flow \"" + messageFlowName + "\" not found on integration server \"" + integrationServerName + "\".");
            }
        } else {
            ApplicationProxy applicationProxy = integrationServerProxy.getApplicationByName(applicationName);
            if (applicationProxy == null) {
                throw new Exception("Application \"" + applicationName + "\" not found on integration server \"" + integrationServerName + "\".");
            }
            if (!applicationProxy.isRunning()) {
                throw new Exception("Application \"" + applicationName + "\" not running.");
            }
            messageFlowProxy = applicationProxy.getMessageFlowByName(messageFlowName);
            if (messageFlowProxy == null) {
                throw new Exception("Message flow \"" + messageFlowName + "\" not found in application \"" + applicationName + "\" on integration server \"" + integrationServerName + "\".");
            }
        }
        return messageFlowProxy;
    }

    private void start(MessageFlowProxy messageFlowProxy, BasicTeststepRun basicTeststepRun) throws Exception {
        if (messageFlowProxy.isRunning()) {
            basicTeststepRun.setInfoMessage("Message flow is already running");
        } else {
            messageFlowProxy.start();
            basicTeststepRun.setInfoMessage("Message flow started");
        }
    }

    private void stop(MessageFlowProxy messageFlowProxy, BasicTeststepRun basicTeststepRun) throws Exception {
        if (messageFlowProxy.isRunning()) {
            messageFlowProxy.stop();
            basicTeststepRun.setInfoMessage("Message flow stopped");
        } else {
            basicTeststepRun.setInfoMessage("Message flow is already stopped");
        }
    }

    private void waitForProcessingCompletion(MessageFlowProxy messageFlowProxy, Integer activityLogPollingTimeout) throws Exception {
        if (!messageFlowProxy.isRunning()) {
            throw new Exception("Message flow not running.");
        }
        TestcaseRunContext testcaseRunContext = this.getTestcaseRunContext();
        Date referenceTime = testcaseRunContext.getTestcaseIndividualRunStartTime() == null ? testcaseRunContext.getTestcaseRunStartTime() : testcaseRunContext.getTestcaseIndividualRunStartTime();
        Date pollingEndTime = DateUtils.addSeconds((Date)new Date(), (int)activityLogPollingTimeout);
        ActivityLogEntry processingCompletionSignal = null;
        ActivityLogEntry potentialProcessingCompletionSignal = null;
        int previousNewLogsCount = 0;
        Date noNewLogsStartTime = null;
        boolean rollbackLogObserved = false;
        while (System.currentTimeMillis() < pollingEndTime.getTime()) {
            ActivityLogProxy activityLogProxy = messageFlowProxy.getActivityLog();
            if (activityLogProxy != null) {
                int newLogsCount = 0;
                for (int i = 1; i <= activityLogProxy.getSize(); ++i) {
                    ActivityLogEntry logEntry = activityLogProxy.getLogEntry(i);
                    if (!logEntry.getTimestamp().after(referenceTime)) continue;
                    ++newLogsCount;
                    if (11506 == logEntry.getMessageNumber()) {
                        processingCompletionSignal = logEntry;
                        break;
                    }
                    if (11507 != logEntry.getMessageNumber()) continue;
                    potentialProcessingCompletionSignal = logEntry;
                    rollbackLogObserved = true;
                }
                if (newLogsCount > previousNewLogsCount) {
                    previousNewLogsCount = newLogsCount;
                    noNewLogsStartTime = new Date();
                } else if (newLogsCount < previousNewLogsCount) {
                    throw new RuntimeException("unexpected situation");
                }
            }
            if (rollbackLogObserved && new Date().after(DateUtils.addSeconds(noNewLogsStartTime, (int)2))) {
                processingCompletionSignal = potentialProcessingCompletionSignal;
            }
            if (processingCompletionSignal == null) continue;
            break;
        }
        if (processingCompletionSignal == null) {
            throw new Exception("Message flow activity log polling timeout. No processing completion signal found.");
        }
        LOGGER.info("Message flow processing completion signal found. " + processingCompletionSignal.toString());
    }
}

