/*
 * Decompiled with CFR 0.152.
 */
package io.apitestbase.core.teststep;

import io.apitestbase.core.teststep.BasicTeststepRun;
import io.apitestbase.core.teststep.IIBTeststepRunnerClassLoader;
import io.apitestbase.core.teststep.TeststepRunner;
import io.apitestbase.models.endpoint.Endpoint;
import io.apitestbase.models.teststep.Teststep;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;

public class IIBTeststepRunner
extends TeststepRunner {
    private static IIBTeststepRunnerClassLoader iib100ClassLoader;
    private static IIBTeststepRunnerClassLoader iib90ClassLoader;

    public BasicTeststepRun run() throws Exception {
        TeststepRunner actualRunner;
        Teststep teststep = this.getTeststep();
        Endpoint endpoint = teststep.getEndpoint();
        if ("IIB".equals(endpoint.getType())) {
            String actualRunnerClassName = "io.apitestbase.core.teststep.IIB100TeststepRunner";
            IIBTeststepRunnerClassLoader classLoader = iib100ClassLoader;
            Class<?> actualRunnerClass = Class.forName(actualRunnerClassName, false, classLoader);
            Constructor<?> constructor = actualRunnerClass.getConstructor(Endpoint.class, String.class);
            actualRunner = (TeststepRunner)constructor.newInstance(endpoint, this.getDecryptedEndpointPassword());
        } else {
            String actualRunnerClassName = "io.apitestbase.core.teststep.IIB90TeststepRunner";
            IIBTeststepRunnerClassLoader classLoader = iib90ClassLoader;
            Class<?> actualRunnerClass = Class.forName(actualRunnerClassName, false, classLoader);
            Constructor<?> constructor = actualRunnerClass.getConstructor(Endpoint.class);
            actualRunner = (TeststepRunner)constructor.newInstance(endpoint);
        }
        actualRunner.setTeststep(teststep);
        actualRunner.setTestcaseRunContext(this.getTestcaseRunContext());
        return actualRunner.run();
    }

    static {
        URL[] iib90URLs;
        URL[] iib100URLs;
        File userDir = new File(System.getProperty("user.dir"));
        try {
            iib100URLs = new URL[]{new File(userDir, "lib/iib/v100/IntegrationAPI.jar").toURI().toURL(), new File(userDir, "lib/iib/v100/jetty-client.jar").toURI().toURL(), new File(userDir, "lib/iib/v100/jetty-io.jar").toURI().toURL(), new File(userDir, "lib/iib/v100/jetty-util.jar").toURI().toURL(), new File(userDir, "lib/iib/v100/websocket-api.jar").toURI().toURL(), new File(userDir, "lib/iib/v100/websocket-client.jar").toURI().toURL(), new File(userDir, "lib/iib/v100/websocket-common.jar").toURI().toURL()};
            iib90URLs = new URL[]{new File(userDir, "lib/iib/v90/ibmjsseprovider2.jar").toURI().toURL(), new File(userDir, "lib/iib/v90/ConfigManagerProxy.jar").toURI().toURL()};
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to initialize " + IIBTeststepRunner.class.getName(), e);
        }
        iib100ClassLoader = new IIBTeststepRunnerClassLoader(iib100URLs, IIBTeststepRunner.class.getClassLoader());
        iib90ClassLoader = new IIBTeststepRunnerClassLoader(iib90URLs, IIBTeststepRunner.class.getClassLoader());
    }
}

