/*
 * Decompiled with CFR 0.152.
 */
package io.ankburov.retrofit.httpclient;

import io.ankburov.retrofit.httpclient.HttpFactoryException;
import io.ankburov.retrofit.httpclient.HttpRequestFactory;
import io.ankburov.retrofit.httpclient.InterceptorChain;
import io.ankburov.retrofit.httpclient.RetrofitResponseFactory;
import io.ankburov.retrofit.httpclient.UnderlyingClientException;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientRetrofitCall
implements Call {
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final Request retrofitRequest;
    @NotNull
    private final HttpRequestFactory requestFactory;
    @NotNull
    private final RetrofitResponseFactory responseFactory;
    @NotNull
    private final Executor asyncCallbackExecutor;
    @NotNull
    private final InterceptorChain interceptorChain;
    @Nullable
    private final Duration timeout;
    private volatile boolean isExecuted = false;
    private volatile CompletableFuture<HttpResponse<InputStream>> asyncCall;

    public HttpClientRetrofitCall(@NotNull HttpClient httpClient, @NotNull Request retrofitRequest, @NotNull HttpRequestFactory requestFactory, @NotNull RetrofitResponseFactory responseFactory, @NotNull Executor asyncCallbackExecutor, InterceptorChain interceptorChain, @Nullable Duration timeout) {
        this.httpClient = httpClient;
        this.retrofitRequest = retrofitRequest;
        this.requestFactory = requestFactory;
        this.responseFactory = responseFactory;
        this.asyncCallbackExecutor = asyncCallbackExecutor;
        this.interceptorChain = interceptorChain;
        this.timeout = timeout;
    }

    @NotNull
    public Request request() {
        return this.retrofitRequest;
    }

    @NotNull
    public Response execute() throws IOException {
        HttpResponse<InputStream> httpResponse;
        Request decoratedRequest = this.interceptorChain.processOnRequest(this.request());
        HttpRequest httpRequest = this.requestFactory.build(decoratedRequest, this.timeout);
        try {
            try {
                httpResponse = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
            }
            catch (Throwable t) {
                this.interceptorChain.processOnResult(decoratedRequest, null, t);
                throw t;
            }
        }
        catch (InterruptedException e) {
            throw new UnderlyingClientException(e);
        }
        this.isExecuted = true;
        Response response = this.responseFactory.build(decoratedRequest, httpResponse);
        return this.interceptorChain.processOnResult(decoratedRequest, response, null);
    }

    public void enqueue(@NotNull Callback callback) {
        Request decoratedRequest = this.interceptorChain.processOnRequest(this.request());
        try {
            HttpRequest httpRequest = this.requestFactory.build(decoratedRequest, this.timeout);
            this.asyncCall = this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofInputStream()).whenCompleteAsync((httpResponse, executionThrowable) -> {
                try {
                    if (httpResponse != null) {
                        Response response = this.responseFactory.build(decoratedRequest, (HttpResponse<InputStream>)httpResponse);
                        Response decoratedResponse = this.interceptorChain.processOnResult(decoratedRequest, response, null);
                        callback.onResponse((Call)this, decoratedResponse);
                    } else {
                        executionThrowable = executionThrowable instanceof CompletionException ? executionThrowable.getCause() : executionThrowable;
                        this.interceptorChain.processOnResult(decoratedRequest, null, (Throwable)executionThrowable);
                        if (executionThrowable instanceof IOException) {
                            callback.onFailure((Call)this, (IOException)executionThrowable);
                        } else {
                            callback.onFailure((Call)this, (IOException)new UnderlyingClientException((Throwable)executionThrowable));
                        }
                    }
                }
                catch (Throwable t) {
                    callback.onFailure((Call)this, (IOException)new HttpFactoryException(t));
                }
            }, this.asyncCallbackExecutor);
        }
        catch (IOException e) {
            this.interceptorChain.processOnResult(decoratedRequest, null, e);
            callback.onFailure((Call)this, (IOException)new HttpFactoryException(e));
        }
        this.isExecuted = true;
    }

    public void cancel() {
        if (this.asyncCall != null) {
            this.asyncCall.cancel(true);
        }
    }

    public boolean isExecuted() {
        return this.isExecuted;
    }

    public boolean isCanceled() {
        return this.asyncCall != null && this.asyncCall.isCancelled();
    }

    @NotNull
    public Timeout timeout() {
        return Timeout.NONE;
    }

    @NotNull
    public Call clone() {
        HttpClientRetrofitCall call = new HttpClientRetrofitCall(this.httpClient, this.request(), this.requestFactory, this.responseFactory, this.asyncCallbackExecutor, this.interceptorChain, this.timeout);
        call.isExecuted = this.isExecuted;
        call.asyncCall = this.asyncCall;
        return call;
    }
}

