/*
 * Decompiled with CFR 0.152.
 */
package io.ankburov.retrofit.httpclient;

import io.ankburov.retrofit.httpclient.HttpRequestFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.time.Duration;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.Nullable;

public class DefaultHttpRequestFactory
implements HttpRequestFactory {
    private static final String CONTENT_TYPE = "Content-Type";

    @Override
    public HttpRequest build(Request request, @Nullable Duration timeout) throws IOException {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(request.url().uri()).method(request.method(), this.getBody(request));
        request.headers().forEach(pair -> builder.header((String)pair.getFirst(), (String)pair.getSecond()));
        if (request.body() != null && request.body().contentType() != null) {
            builder.setHeader(CONTENT_TYPE, request.body().contentType().toString());
        }
        if (timeout != null) {
            builder.timeout(timeout);
        }
        return builder.build();
    }

    protected HttpRequest.BodyPublisher getBody(Request request) throws IOException {
        RequestBody body = request.body();
        if (body == null) {
            return HttpRequest.BodyPublishers.noBody();
        }
        try (Buffer buffer = new Buffer();){
            HttpRequest.BodyPublisher bodyPublisher;
            block12: {
                body.writeTo((BufferedSink)buffer);
                InputStream bodyStream = buffer.inputStream();
                try {
                    bodyPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> bodyStream);
                    if (bodyStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (bodyStream != null) {
                        try {
                            bodyStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                bodyStream.close();
            }
            return bodyPublisher;
        }
    }
}

