/*
 * Decompiled with CFR 0.152.
 */
package io.ankburov.retrofit.httpclient;

import io.ankburov.retrofit.httpclient.DefaultHttpRequestFactory;
import io.ankburov.retrofit.httpclient.DefaultInterceptorChain;
import io.ankburov.retrofit.httpclient.DefaultRetrofitResponseFactory;
import io.ankburov.retrofit.httpclient.HttpClientRetrofitCall;
import io.ankburov.retrofit.httpclient.HttpRequestFactory;
import io.ankburov.retrofit.httpclient.Interceptor;
import io.ankburov.retrofit.httpclient.InterceptorChain;
import io.ankburov.retrofit.httpclient.RetrofitResponseFactory;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import okhttp3.Call;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientRetrofitCallFactory
implements Call.Factory {
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final HttpRequestFactory requestFactory;
    @NotNull
    private final RetrofitResponseFactory responseFactory;
    @NotNull
    private final Executor asyncCallbackExecutor;
    @NotNull
    private final InterceptorChain interceptorChain;
    @Nullable
    private final Duration timeout;

    private HttpClientRetrofitCallFactory(@NotNull HttpClient httpClient, @NotNull HttpRequestFactory requestFactory, @NotNull RetrofitResponseFactory responseFactory, @NotNull Executor asyncCallbackExecutor, InterceptorChain interceptorChain, @Nullable Duration timeout) {
        this.httpClient = httpClient;
        this.requestFactory = requestFactory;
        this.responseFactory = responseFactory;
        this.asyncCallbackExecutor = asyncCallbackExecutor;
        this.interceptorChain = interceptorChain;
        this.timeout = timeout;
    }

    @NotNull
    public Call newCall(@NotNull Request request) {
        return new HttpClientRetrofitCall(this.httpClient, request, this.requestFactory, this.responseFactory, this.asyncCallbackExecutor, this.interceptorChain, this.timeout);
    }

    public static Builder builder(HttpClient httpClient) {
        return new Builder(httpClient);
    }

    public static class Builder {
        @NotNull
        private final HttpClient httpClient;
        @NotNull
        private HttpRequestFactory requestFactory = new DefaultHttpRequestFactory();
        @NotNull
        private RetrofitResponseFactory responseFactory = new DefaultRetrofitResponseFactory();
        @NotNull
        private Executor asyncCallbackExecutor = ForkJoinPool.commonPool();
        @NotNull
        private InterceptorChain interceptorChain = new DefaultInterceptorChain();
        @NotNull
        private List<Interceptor> interceptors = new ArrayList<Interceptor>();
        @Nullable
        private Duration timeout;

        public Builder(@NotNull HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        public Builder withRequestFactory(@NotNull HttpRequestFactory requestFactory) {
            this.requestFactory = requestFactory;
            return this;
        }

        public Builder withResponseFactory(@NotNull RetrofitResponseFactory responseFactory) {
            this.responseFactory = responseFactory;
            return this;
        }

        public Builder withAsyncCallbackExecutor(@NotNull Executor executor) {
            this.asyncCallbackExecutor = executor;
            return this;
        }

        public Builder withInterceptorChain(@NotNull InterceptorChain interceptorChain) {
            this.interceptorChain = interceptorChain;
            return this;
        }

        public Builder addInterceptor(@NotNull Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder withTimeout(@Nullable Duration duration) {
            this.timeout = duration;
            return this;
        }

        public HttpClientRetrofitCallFactory build() {
            this.interceptorChain.setInterceptors(this.interceptors);
            return new HttpClientRetrofitCallFactory(this.httpClient, this.requestFactory, this.responseFactory, this.asyncCallbackExecutor, this.interceptorChain, this.timeout);
        }
    }
}

