/*
 * Decompiled with CFR 0.152.
 */
package io.ankburov.retrofit.httpclient;

import io.ankburov.retrofit.httpclient.RetrofitResponseFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

public class DefaultRetrofitResponseFactory
implements RetrofitResponseFactory {
    private static final String EMPTY = "";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final int UNKNOWN_LENGTH = -1;

    @Override
    public Response build(Request retrofitRequest, final HttpResponse<InputStream> response) {
        Response.Builder responseBuilder = new Response.Builder().request(retrofitRequest).protocol(response.version() == HttpClient.Version.HTTP_1_1 ? Protocol.HTTP_1_1 : Protocol.HTTP_2).message(EMPTY).code(response.statusCode()).body(new ResponseBody(){

            public MediaType contentType() {
                return response.headers().firstValue(DefaultRetrofitResponseFactory.CONTENT_TYPE).map(MediaType::parse).orElse(null);
            }

            public long contentLength() {
                long length = response.headers().firstValueAsLong(DefaultRetrofitResponseFactory.CONTENT_LENGTH).orElseGet(() -> {
                    try {
                        return ((InputStream)response.body()).available();
                    }
                    catch (IOException e) {
                        return -1L;
                    }
                });
                return length != 0L ? length : -1L;
            }

            @NotNull
            public BufferedSource source() {
                return Okio.buffer((Source)Okio.source((InputStream)((InputStream)response.body())));
            }
        });
        response.headers().map().forEach((key, values) -> values.forEach(value -> responseBuilder.header(key, value)));
        return responseBuilder.build();
    }
}

