/*
 * Decompiled with CFR 0.152.
 */
package io.ankburov.retrofit.httpclient;

import io.ankburov.retrofit.httpclient.Interceptor;
import io.ankburov.retrofit.httpclient.InterceptorChain;
import java.util.List;
import okhttp3.Request;
import okhttp3.Response;

public class DefaultInterceptorChain
implements InterceptorChain {
    private List<Interceptor> interceptors;

    @Override
    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = List.copyOf(interceptors);
    }

    @Override
    public Request processOnRequest(Request request) {
        for (Interceptor interceptor : this.interceptors) {
            request = interceptor.onRequest(request);
        }
        return request;
    }

    @Override
    public Response processOnResult(Request request, Response response, Throwable throwable) {
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            response = this.interceptors.get(i).onResult(request, response, throwable);
        }
        return response;
    }
}

