/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.jcr;

import io.alapierre.jcr.JcrSessionSynchronization;
import io.alapierre.jcr.SessionFactory;
import io.alapierre.jcr.SessionHolder;
import io.alapierre.jcr.exceptions.ConcurrencyFailureException;
import io.alapierre.jcr.exceptions.DataAccessException;
import io.alapierre.jcr.exceptions.DataAccessResourceFailureException;
import io.alapierre.jcr.exceptions.DataIntegrityViolationException;
import io.alapierre.jcr.exceptions.DataRetrievalFailureException;
import io.alapierre.jcr.exceptions.InvalidDataAccessApiUsageException;
import io.alapierre.jcr.exceptions.JcrSystemException;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.version.VersionException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SessionFactoryUtils {
    private static final Logger log = LoggerFactory.getLogger(SessionFactoryUtils.class);

    public static Session getSession(@NotNull SessionFactory sessionFactory, boolean allowCreate) throws DataAccessResourceFailureException {
        if (sessionFactory == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'sessionFactory') of io/alapierre/jcr/SessionFactoryUtils.getSession must not be null");
        }
        try {
            SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
            if (sessionHolder != null && sessionHolder.getSession() != null) {
                log.debug("Return existing session from TransactionSynchronizationManager");
                return sessionHolder.getSession();
            }
            if (!allowCreate && !TransactionSynchronizationManager.isSynchronizationActive()) {
                throw new IllegalStateException("No session bound to thread, and configuration does not allow creation of non-transactional one here");
            }
            if (log.isDebugEnabled()) {
                log.debug("Opening new JCR Session for thread {}", (Object)Thread.currentThread().getName());
            }
            Session session = sessionFactory.getSession();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                log.debug("Registering transaction synchronization for JCR session");
                sessionHolder = sessionFactory.getSessionHolder(session);
                sessionHolder.setSynchronizedWithTransaction(true);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new JcrSessionSynchronization(sessionHolder, sessionFactory));
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
            } else {
                log.debug("JCR transaction synchronization is not active");
            }
            return session;
        }
        catch (RepositoryException ex) {
            throw new DataAccessResourceFailureException("Could not open Jcr Session", ex);
        }
    }

    public static DataAccessException translateException(RepositoryException ex) {
        if (ex instanceof AccessDeniedException) {
            return new DataRetrievalFailureException("Access denied to this data", ex);
        }
        if (ex instanceof ConstraintViolationException) {
            return new DataIntegrityViolationException("Constraint has been violated", ex);
        }
        if (ex instanceof InvalidItemStateException) {
            return new ConcurrencyFailureException("Invalid item state", ex);
        }
        if (ex instanceof InvalidQueryException) {
            return new DataRetrievalFailureException("Invalid query", ex);
        }
        if (ex instanceof InvalidSerializedDataException) {
            return new DataRetrievalFailureException("Invalid serialized data", ex);
        }
        if (ex instanceof ItemExistsException) {
            return new DataIntegrityViolationException("An item already exists", ex);
        }
        if (ex instanceof ItemNotFoundException) {
            return new DataRetrievalFailureException("Item not found", ex);
        }
        if (ex instanceof LoginException) {
            return new DataAccessResourceFailureException("Bad login", ex);
        }
        if (ex instanceof LockException) {
            return new ConcurrencyFailureException("Item is locked", ex);
        }
        if (ex instanceof MergeException) {
            return new DataIntegrityViolationException("Merge failed", ex);
        }
        if (ex instanceof NamespaceException) {
            return new InvalidDataAccessApiUsageException("Namespace not registred", ex);
        }
        if (ex instanceof NoSuchNodeTypeException) {
            return new InvalidDataAccessApiUsageException("No such node type", ex);
        }
        if (ex instanceof NoSuchWorkspaceException) {
            return new DataAccessResourceFailureException("Workspace not found", ex);
        }
        if (ex instanceof PathNotFoundException) {
            return new DataRetrievalFailureException("Path not found", ex);
        }
        if (ex instanceof ReferentialIntegrityException) {
            return new DataIntegrityViolationException("Referential integrity violated", ex);
        }
        if (ex instanceof UnsupportedRepositoryOperationException) {
            return new InvalidDataAccessApiUsageException("Unsupported operation", ex);
        }
        if (ex instanceof ValueFormatException) {
            return new InvalidDataAccessApiUsageException("Incorrect value format", ex);
        }
        if (ex instanceof VersionException) {
            return new DataIntegrityViolationException("Invalid version graph operation", ex);
        }
        return new JcrSystemException(ex);
    }
}

