/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.jcr;

import io.alapierre.jcr.JcrCallback;
import io.alapierre.jcr.SessionFactory;
import io.alapierre.jcr.SessionFactoryUtils;
import io.alapierre.jcr.TenantProvider;
import io.alapierre.jcr.exceptions.DataAccessException;
import io.alapierre.jcr.exceptions.JcrSystemException;
import io.alapierre.jcr.exceptions.UncategorizedDataAccessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class JcrTemplate {
    private static final Logger log = LoggerFactory.getLogger(JcrTemplate.class);
    private final SessionFactory sessionFactory;
    private final TenantProvider tenantProvider;

    public JcrTemplate(SessionFactory sessionFactory, TenantProvider tenantProvider) {
        this.sessionFactory = sessionFactory;
        this.tenantProvider = tenantProvider;
    }

    public <T> T execute(JcrCallback<T> action) throws DataAccessException {
        Session session = null;
        try {
            session = this.getSession();
            T t = action.doInJcr(session);
            return t;
        }
        catch (RepositoryException ex) {
            throw SessionFactoryUtils.translateException(ex);
        }
        catch (IOException | RuntimeException ex) {
            throw new UncategorizedDataAccessException(ex);
        }
        finally {
            log.debug("closing session for thread: {}", (Object)Thread.currentThread().getName());
            if (session != null) {
                session.logout();
            }
        }
    }

    protected Session getSession() throws DataAccessException, RepositoryException {
        log.debug("get session from SessionFactoryUtils");
        Session session = SessionFactoryUtils.getSession(this.sessionFactory, true);
        Optional<String> tenant = this.tenantProvider.getTenant();
        if (tenant.isPresent()) {
            log.info("Get session for tenantName: [{}]", (Object)tenant.get());
            session = session.getRepository().login(tenant.get());
        }
        return session;
    }

    public void addLockToken(String lock) {
        this.execute(session -> {
            session.getWorkspace().getLockManager().addLockToken(lock);
            return null;
        });
    }

    public Object getAttribute(String name) {
        return this.execute(session -> session.getAttribute(name));
    }

    public String[] getAttributeNames() {
        return this.execute(Session::getAttributeNames);
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) {
        return this.execute(session -> session.getImportContentHandler(parentAbsPath, uuidBehavior));
    }

    public Item getItem(String absPath) {
        return this.execute(session -> session.getItem(absPath));
    }

    public String[] getLockTokens() {
        return this.execute(session -> session.getWorkspace().getLockManager().getLockTokens());
    }

    public Node getNodeByIdentifier(String identifier) {
        return this.execute(session -> session.getNodeByIdentifier(identifier));
    }

    public Node getRootNode() {
        return this.execute(Session::getRootNode);
    }

    public String getUserID() {
        return this.execute(Session::getUserID);
    }

    public ValueFactory getValueFactory() {
        return this.execute(Session::getValueFactory);
    }

    public boolean hasPendingChanges() {
        return this.execute(Session::hasPendingChanges);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) {
        this.execute(session -> {
            try {
                session.importXML(parentAbsPath, in, uuidBehavior);
            }
            catch (IOException e) {
                throw new JcrSystemException(e);
            }
            return null;
        });
    }

    public void refresh(boolean keepChanges) {
        this.execute(session -> {
            session.refresh(keepChanges);
            return null;
        });
    }

    public void rename(Node node, String newName) {
        this.execute(session -> {
            session.move(node.getPath(), node.getParent().getPath() + "/" + newName);
            return null;
        });
    }

    public boolean isLive() {
        return this.execute(Session::isLive);
    }

    public boolean itemExists(String absPath) {
        return this.execute(session -> session.itemExists(absPath));
    }

    public void move(String srcAbsPath, String destAbsPath) {
        this.execute(session -> {
            session.move(srcAbsPath, destAbsPath);
            return null;
        });
    }

    public void save() {
        this.execute(session -> {
            session.save();
            return null;
        });
    }

    public String dump(Node node) {
        return this.execute(session -> {
            Node nd = node;
            if (nd == null) {
                nd = session.getRootNode();
            }
            return this.dumpNode(nd);
        });
    }

    protected String dumpNode(Node node) throws RepositoryException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getPath());
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            buffer.append(property.getPath()).append("=");
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(values[i].getString());
                }
            } else {
                buffer.append(property.getString());
            }
            buffer.append("\n");
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node child = nodes.nextNode();
            buffer.append(this.dumpNode(child));
        }
        return buffer.toString();
    }

    public QueryResult query(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node can't be null");
        }
        return this.execute(session -> {
            boolean debug = log.isDebugEnabled();
            QueryManager manager = session.getWorkspace().getQueryManager();
            if (debug) {
                log.debug("retrieved manager " + manager);
            }
            Query query = manager.getQuery(node);
            if (debug) {
                log.debug("created query " + query);
            }
            return query.execute();
        });
    }

    public QueryResult query(String statement) {
        return this.query(statement, null);
    }

    public QueryResult query(String statement, String language) {
        if (statement == null) {
            throw new IllegalArgumentException("statement can't be null");
        }
        return this.execute(session -> {
            String lang = language;
            if (lang == null) {
                lang = "xpath";
            }
            boolean debug = log.isDebugEnabled();
            QueryManager manager = session.getWorkspace().getQueryManager();
            if (debug) {
                log.debug("retrieved manager " + manager);
            }
            Query query = manager.createQuery(statement, lang);
            if (debug) {
                log.debug("created query " + query);
            }
            return query.execute();
        });
    }

    public boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node putVersionableFile(@NotNull Node parent, @NotNull String name, @NotNull String mime, @NotNull InputStream data, @NotNull Calendar date) throws RepositoryException {
        if (parent == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'parent') of io/alapierre/jcr/JcrTemplate.putVersionableFile must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'name') of io/alapierre/jcr/JcrTemplate.putVersionableFile must not be null");
        }
        if (mime == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'mime') of io/alapierre/jcr/JcrTemplate.putVersionableFile must not be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 (parameter 'data') of io/alapierre/jcr/JcrTemplate.putVersionableFile must not be null");
        }
        if (date == null) {
            throw new IllegalArgumentException("NotNull annotated argument 4 (parameter 'date') of io/alapierre/jcr/JcrTemplate.putVersionableFile must not be null");
        }
        Binary binary = parent.getSession().getValueFactory().createBinary(data);
        VersionManager manager = parent.getSession().getWorkspace().getVersionManager();
        Node file = null;
        boolean existing = JcrUtils.getNodeIfExists((Node)parent, (String)name) != null;
        try {
            file = JcrUtils.getOrAddNode((Node)parent, (String)name, (String)"{http://www.jcp.org/jcr/nt/1.0}file");
            file.addMixin("mix:versionable");
            Node content = JcrUtils.getOrAddNode((Node)file, (String)"{http://www.jcp.org/jcr/1.0}content", (String)"{http://www.jcp.org/jcr/nt/1.0}resource");
            content.addMixin("mix:versionable");
            if (existing) {
                log.debug("Checking in file {}", (Object)file.getPath());
                manager.checkin(file.getPath());
            } else {
                log.debug("Create new file {}", (Object)name);
            }
            Node node = this.getNode(mime, date, binary, file, content);
            return node;
        }
        finally {
            binary.dispose();
            if (file != null && !file.isCheckedOut()) {
                log.debug("Checking out file {}", (Object)file.getPath());
                manager.checkout(file.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node putFile(@NotNull Node parent, @NotNull String name, @NotNull String mime, @NotNull InputStream data, @NotNull Calendar date) throws RepositoryException {
        if (parent == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'parent') of io/alapierre/jcr/JcrTemplate.putFile must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'name') of io/alapierre/jcr/JcrTemplate.putFile must not be null");
        }
        if (mime == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'mime') of io/alapierre/jcr/JcrTemplate.putFile must not be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 (parameter 'data') of io/alapierre/jcr/JcrTemplate.putFile must not be null");
        }
        if (date == null) {
            throw new IllegalArgumentException("NotNull annotated argument 4 (parameter 'date') of io/alapierre/jcr/JcrTemplate.putFile must not be null");
        }
        Binary binary = parent.getSession().getValueFactory().createBinary(data);
        try {
            Node file = JcrUtils.getOrAddNode((Node)parent, (String)name, (String)"{http://www.jcp.org/jcr/nt/1.0}file");
            file.addMixin("mix:versionable");
            Node content = JcrUtils.getOrAddNode((Node)file, (String)"{http://www.jcp.org/jcr/1.0}content", (String)"{http://www.jcp.org/jcr/nt/1.0}resource");
            content.addMixin("mix:versionable");
            Node node = this.getNode(mime, date, binary, file, content);
            return node;
        }
        finally {
            binary.dispose();
        }
    }

    private Node getNode(@NotNull String mime, @NotNull Calendar date, Binary binary, Node file, Node content) throws RepositoryException {
        if (mime == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'mime') of io/alapierre/jcr/JcrTemplate.getNode must not be null");
        }
        if (date == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'date') of io/alapierre/jcr/JcrTemplate.getNode must not be null");
        }
        content.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", mime);
        String[] parameters = mime.split(";");
        for (int i = 1; i < parameters.length; ++i) {
            String parameter;
            int equals = parameters[i].indexOf(61);
            if (equals == -1 || !"charset".equalsIgnoreCase((parameter = parameters[i].substring(0, equals)).trim())) continue;
            content.setProperty("{http://www.jcp.org/jcr/1.0}encoding", parameters[i].substring(equals + 1).trim());
        }
        content.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", date);
        content.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
        return file;
    }

    public void checkin(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of io/alapierre/jcr/JcrTemplate.checkin must not be null");
        }
        this.execute(session -> {
            VersionManager manager = session.getWorkspace().getVersionManager();
            manager.checkin(path);
            return null;
        });
    }

    public void checkout(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of io/alapierre/jcr/JcrTemplate.checkout must not be null");
        }
        this.execute(session -> {
            VersionManager manager = session.getWorkspace().getVersionManager();
            manager.checkout(path);
            return null;
        });
    }

    public Stream<Version> getVersions(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of io/alapierre/jcr/JcrTemplate.getVersions must not be null");
        }
        return this.execute(session -> {
            VersionManager manager = session.getWorkspace().getVersionManager();
            VersionHistory history = manager.getVersionHistory(path);
            VersionIterator it = history.getAllVersions();
            boolean debug = log.isDebugEnabled();
            while (it.hasNext()) {
                Version v = it.nextVersion();
                if (!debug) continue;
                log.debug("v.getCreated().getTime()");
            }
            Spliterator spliterator = Spliterators.spliteratorUnknownSize(history.getAllVersions(), 0);
            return StreamSupport.stream(spliterator, false);
        });
    }

    public InputStream readFile(Node node) throws RepositoryException {
        return JcrUtils.readFile((Node)node);
    }

    public void readFile(Node node, OutputStream output) throws RepositoryException, IOException {
        JcrUtils.readFile((Node)node, (OutputStream)output);
    }
}

