/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.jcr;

import io.alapierre.jcr.SessionFactory;
import io.alapierre.jcr.SessionHolder;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

class JcrSessionSynchronization
extends TransactionSynchronizationAdapter {
    private static final Logger log = LoggerFactory.getLogger(JcrSessionSynchronization.class);
    private final SessionHolder sessionHolder;
    private final SessionFactory sessionFactory;
    private boolean holderActive = true;

    public JcrSessionSynchronization(SessionHolder holder, SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.sessionHolder = holder;
    }

    public void suspend() {
        if (this.holderActive) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }
    }

    public void resume() {
        if (this.holderActive) {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
        }
    }

    public void beforeCompletion() {
        TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        this.holderActive = false;
        JcrSessionSynchronization.releaseSession(this.sessionHolder.getSession(), this.sessionFactory);
    }

    public static void releaseSession(Session session, SessionFactory sessionFactory) {
        if (session == null) {
            return;
        }
        if (!JcrSessionSynchronization.isSessionThreadBound(session, sessionFactory)) {
            log.debug("Closing JCR Session");
            session.logout();
        }
    }

    public static boolean isSessionThreadBound(Session session, SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return false;
        }
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        return sessionHolder != null && session == sessionHolder.getSession();
    }
}

