/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.jcr;

import io.alapierre.jcr.SessionFactory;
import io.alapierre.jcr.SessionHolder;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JcrSessionFactory
implements InitializingBean,
DisposableBean,
SessionFactory {
    private static final Logger log = LoggerFactory.getLogger(JcrSessionFactory.class);
    private Repository repository;
    private String workspaceName;
    private Credentials credentials;

    public JcrSessionFactory(@NotNull Repository repository, @Nullable String workspaceName, @NotNull Credentials credentials) {
        if (repository == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'repository') of io/alapierre/jcr/JcrSessionFactory.<init> must not be null");
        }
        if (credentials == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'credentials') of io/alapierre/jcr/JcrSessionFactory.<init> must not be null");
        }
        this.repository = repository;
        this.workspaceName = workspaceName;
        this.credentials = credentials;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void destroy() throws Exception {
    }

    @Override
    public Session getSession() throws RepositoryException {
        return this.repository.login(this.credentials, this.workspaceName);
    }

    public String toString() {
        return "SessionFactory for " + this.getRepositoryInfo() + "|workspace=" + this.workspaceName;
    }

    private String getRepositoryInfo() {
        if (this.getRepository() == null) {
            return "<N/A>";
        }
        return this.getRepository().getDescriptor("jcr.repository.name") + " " + this.getRepository().getDescriptor("jcr.repository.version");
    }

    @Override
    public SessionHolder getSessionHolder(@NotNull Session session) {
        if (session == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'session') of io/alapierre/jcr/JcrSessionFactory.getSessionHolder must not be null");
        }
        return new SessionHolder(session);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }
}

