(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'react', 'react-router-dom', 'react-router', 'akryl-dom'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('react'), require('react-router-dom'), require('react-router'), require('akryl-dom'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'akryl-router'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'akryl-router'.");
    }
    if (typeof React === 'undefined') {
      throw new Error("Error loading module 'akryl-router'. Its dependency 'react' was not found. Please, check whether 'react' is loaded prior to 'akryl-router'.");
    }
    if (typeof ReactRouterDom === 'undefined') {
      throw new Error("Error loading module 'akryl-router'. Its dependency 'react-router-dom' was not found. Please, check whether 'react-router-dom' is loaded prior to 'akryl-router'.");
    }
    if (typeof ReactRouter === 'undefined') {
      throw new Error("Error loading module 'akryl-router'. Its dependency 'react-router' was not found. Please, check whether 'react-router' is loaded prior to 'akryl-router'.");
    }
    if (typeof this['akryl-dom'] === 'undefined') {
      throw new Error("Error loading module 'akryl-router'. Its dependency 'akryl-dom' was not found. Please, check whether 'akryl-dom' is loaded prior to 'akryl-router'.");
    }
    root['akryl-router'] = factory(typeof this['akryl-router'] === 'undefined' ? {} : this['akryl-router'], kotlin, React, ReactRouterDom, ReactRouter, this['akryl-dom']);
  }
}(this, function (_, Kotlin, $module$react, $module$react_router_dom, $module$react_router, $module$akryl_dom) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var asList = Kotlin.kotlin.collections.asList_us0mfu$;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var json = Kotlin.kotlin.js.json_pyyo18$;
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var text = $module$akryl_dom.io.akryl.dom.html.text_61zpoe$;
  var filterNotNullTo = Kotlin.kotlin.collections.filterNotNullTo_u9kwcl$;
  var css = $module$akryl_dom.io.akryl.dom.css;
  var listOfNotNull = Kotlin.kotlin.collections.listOfNotNull_jurz7g$;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  function LocationDescriptor(pathname, search, state, hash, key) {
    if (pathname === void 0)
      pathname = undefined;
    if (search === void 0)
      search = undefined;
    if (state === void 0)
      state = undefined;
    if (hash === void 0)
      hash = undefined;
    if (key === void 0)
      key = undefined;
    this.pathname = pathname;
    this.search = search;
    this.state = state;
    this.hash = hash;
    this.key = key;
  }
  LocationDescriptor.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LocationDescriptor',
    interfaces: []
  };
  function Location(pathname, search, state, hash, key) {
    this.pathname = pathname;
    this.search = search;
    this.state = state;
    this.hash = hash;
    this.key = key;
  }
  Location.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Location',
    interfaces: []
  };
  function Match(params, isExact, path, url) {
    this.params = params;
    this.isExact = isExact;
    this.path = path;
    this.url = url;
  }
  Match.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Match',
    interfaces: []
  };
  function RouteComponentProps(history, location, match) {
    this.history = history;
    this.location = location;
    this.match = match;
  }
  RouteComponentProps.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RouteComponentProps',
    interfaces: []
  };
  function browserRouter(children) {
    if (children === void 0)
      children = emptyList();
    var tmp$;
    return (tmp$ = $module$react).createElement.apply(tmp$, [$module$react_router_dom.BrowserRouter, null].concat(copyToArray(children)));
  }
  function browserRouter_0(children) {
    return browserRouter(asList(children));
  }
  function hashRouter(children) {
    if (children === void 0)
      children = emptyList();
    var tmp$;
    return (tmp$ = $module$react).createElement.apply(tmp$, [$module$react_router_dom.HashRouter, null].concat(copyToArray(children)));
  }
  function hashRouter_0(children) {
    return hashRouter(asList(children));
  }
  function memoryRouter(initialEntries, initialIndex, children) {
    if (initialEntries === void 0)
      initialEntries = null;
    if (initialIndex === void 0)
      initialIndex = null;
    if (children === void 0)
      children = emptyList();
    var tmp$;
    return (tmp$ = $module$react).createElement.apply(tmp$, [$module$react_router.MemoryRouter, json([to('initialIndex', initialIndex), to('initialEntries', initialEntries != null ? copyToArray(initialEntries) : null)])].concat(copyToArray(children)));
  }
  function redirect(to_0, push, from, path, exact, strict) {
    if (push === void 0)
      push = undefined;
    if (from === void 0)
      from = undefined;
    if (path === void 0)
      path = undefined;
    if (exact === void 0)
      exact = undefined;
    if (strict === void 0)
      strict = undefined;
    return $module$react.createElement($module$react_router.Redirect, json([to('to', to_0), to('push', push), to('from', from), to('path', path), to('exact', exact), to('strict', strict)]));
  }
  function route(render, children, child, text_0, path, exact, sensitive, strict) {
    if (render === void 0)
      render = undefined;
    if (children === void 0)
      children = emptyList();
    if (child === void 0)
      child = null;
    if (text_0 === void 0)
      text_0 = null;
    if (path === void 0)
      path = undefined;
    if (exact === void 0)
      exact = undefined;
    if (sensitive === void 0)
      sensitive = undefined;
    if (strict === void 0)
      strict = undefined;
    var tmp$;
    var tmp$_0 = (tmp$ = $module$react).createElement;
    var tmp$_1 = [$module$react_router.Route, json([to('render', render), to('path', path), to('exact', exact), to('sensitive', sensitive), to('strict', strict)])];
    var tmp$_2 = tmp$_1.concat;
    var tmp$_3, tmp$_0_0;
    var concatChildren$result;
    concatChildren$break: do {
      if (text_0 == null && child == null && children == null) {
        concatChildren$result = null;
        break concatChildren$break;
      }
      var result = ArrayList_init();
      if (text_0 != null)
        result.add_11rb$(text(text_0));
      if (child != null)
        result.add_11rb$(child);
      children != null ? filterNotNullTo(children, result) : null;
      concatChildren$result = result;
    }
     while (false);
    return tmp$_0.apply(tmp$, tmp$_2.call(tmp$_1, (tmp$_0_0 = (tmp$_3 = concatChildren$result) != null ? copyToArray(tmp$_3) : null) != null ? tmp$_0_0 : []));
  }
  function switch_0(children) {
    if (children === void 0)
      children = emptyList();
    var tmp$;
    return (tmp$ = $module$react).createElement.apply(tmp$, [$module$react_router.Switch, null].concat(copyToArray(children)));
  }
  function switch_1(children) {
    return switch_0(asList(children));
  }
  function link(to_0, replace, className, css_0, children, child, text_0) {
    if (replace === void 0)
      replace = undefined;
    if (className === void 0)
      className = null;
    if (css_0 === void 0)
      css_0 = null;
    if (children === void 0)
      children = emptyList();
    if (child === void 0)
      child = null;
    if (text_0 === void 0)
      text_0 = null;
    var tmp$;
    var tmp$_0 = (tmp$ = $module$react).createElement;
    var tmp$_1 = $module$react_router_dom.Link;
    var tmp$_2 = to('to', to_0);
    var tmp$_3 = to('replace', replace);
    var tmp$_4, tmp$_0_0;
    var cssClassName = css.cssRegistry.findOrCreateClassName_g70jig$(css_0);
    var $receiver = listOfNotNull([className != null ? className.toString() : null, cssClassName]);
    var tmp$_5 = [tmp$_1, json([tmp$_2, tmp$_3, to('className', (tmp$_0_0 = (tmp$_4 = !$receiver.isEmpty() ? $receiver : null) != null ? joinToString(tmp$_4, ' ') : null) != null ? tmp$_0_0 : undefined)])];
    var tmp$_6 = tmp$_5.concat;
    var tmp$_7, tmp$_0_1;
    var concatChildren$result;
    concatChildren$break: do {
      if (text_0 == null && child == null && children == null) {
        concatChildren$result = null;
        break concatChildren$break;
      }
      var result = ArrayList_init();
      if (text_0 != null)
        result.add_11rb$(text(text_0));
      if (child != null)
        result.add_11rb$(child);
      children != null ? filterNotNullTo(children, result) : null;
      concatChildren$result = result;
    }
     while (false);
    return tmp$_0.apply(tmp$, tmp$_6.call(tmp$_5, (tmp$_0_1 = (tmp$_7 = concatChildren$result) != null ? copyToArray(tmp$_7) : null) != null ? tmp$_0_1 : []));
  }
  var package$io = _.io || (_.io = {});
  var package$akryl = package$io.akryl || (package$io.akryl = {});
  var package$router = package$akryl.router || (package$akryl.router = {});
  package$router.LocationDescriptor = LocationDescriptor;
  package$router.Location = Location;
  package$router.Match = Match;
  package$router.RouteComponentProps = RouteComponentProps;
  package$router.browserRouter_hr57lf$ = browserRouter;
  package$router.browserRouter_t7oou7$ = browserRouter_0;
  package$router.hashRouter_hr57lf$ = hashRouter;
  package$router.hashRouter_t7oou7$ = hashRouter_0;
  package$router.memoryRouter_tgyc8c$ = memoryRouter;
  package$router.redirect_ix55ai$ = redirect;
  $$importsForInline$$['akryl-dom'] = $module$akryl_dom;
  package$router.route_ja2331$ = route;
  package$router.switch_hr57lf$ = switch_0;
  package$router.switch_t7oou7$ = switch_1;
  package$router.link_u57b6s$ = link;
  Kotlin.defineModule('akryl-router', _);
  return _;
}));

//# sourceMappingURL=akryl-router.js.map
