@file:Suppress("NOTHING_TO_INLINE", "FunctionName", "unused", "MemberVisibilityCanBePrivate")

package io.akryl.dom.html

import io.akryl.dom.css.AbstractStyleProperty
import io.akryl.dom.css.CssElement
import io.akryl.dom.css.TagName
import org.w3c.dom.*
import org.w3c.dom.clipboard.ClipboardEvent
import org.w3c.dom.events.Event
import org.w3c.dom.events.KeyboardEvent
import org.w3c.dom.events.MouseEvent
import org.w3c.dom.events.WheelEvent
import org.w3c.dom.svg.SVGElement
import org.w3c.dom.svg.SVGPathElement
import react.MutableRefObject
import react.ReactElement

interface ElementFactory<T : ElementFactory<T>> {
    fun with(defaults: Map<String, Any>): T
}

@Suppress("UNCHECKED_CAST")
private inline fun listeners(
    noinline onBlur: ((event: Event) -> Unit)? = null,
    noinline onChange: ((event: Event) -> Unit)? = null,
    noinline onContextMenu: ((event: Event) -> Unit)? = null,
    noinline onFocus: ((event: Event) -> Unit)? = null,
    noinline onInput: ((event: Event) -> Unit)? = null,
    noinline onInvalid: ((event: Event) -> Unit)? = null,
    noinline onReset: ((event: Event) -> Unit)? = null,
    noinline onSearch: ((event: Event) -> Unit)? = null,
    noinline onSelect: ((event: Event) -> Unit)? = null,
    noinline onSubmit: ((event: Event) -> Unit)? = null,
    noinline onScroll: ((event: Event) -> Unit)? = null,
    noinline onToggle: ((event: Event) -> Unit)? = null,
    noinline onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
    noinline onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
    noinline onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
    noinline onMouseDown: ((event: MouseEvent) -> Unit)? = null,
    noinline onMouseMove: ((event: MouseEvent) -> Unit)? = null,
    noinline onMouseOut: ((event: MouseEvent) -> Unit)? = null,
    noinline onMouseOver: ((event: MouseEvent) -> Unit)? = null,
    noinline onMouseUp: ((event: MouseEvent) -> Unit)? = null,
    noinline onClick: ((event: MouseEvent) -> Unit)? = null,
    noinline onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
    noinline onWheel: ((event: WheelEvent) -> Unit)? = null,
    noinline onDrag: ((event: DragEvent) -> Unit)? = null,
    noinline onDragEnd: ((event: DragEvent) -> Unit)? = null,
    noinline onDragEnter: ((event: DragEvent) -> Unit)? = null,
    noinline onDragLeave: ((event: DragEvent) -> Unit)? = null,
    noinline onDragOver: ((event: DragEvent) -> Unit)? = null,
    noinline onDragStart: ((event: DragEvent) -> Unit)? = null,
    noinline onDrop: ((event: DragEvent) -> Unit)? = null,
    noinline onCopy: ((event: ClipboardEvent) -> Unit)? = null,
    noinline onCut: ((event: ClipboardEvent) -> Unit)? = null,
    noinline onPaste: ((event: ClipboardEvent) -> Unit)? = null
): HashMap<String, (Event) -> Unit> {
    val result = HashMap<String, (Event) -> Unit>()
    if (onBlur != null) result["onBlur"] = onBlur
    if (onChange != null) result["onChange"] = onChange
    if (onContextMenu != null) result["onContextMenu"] = onContextMenu
    if (onFocus != null) result["onFocus"] = onFocus
    if (onInput != null) result["onInput"] = onInput
    if (onInvalid != null) result["onInvalid"] = onInvalid
    if (onReset != null) result["onReset"] = onReset
    if (onSearch != null) result["onSearch"] = onSearch
    if (onSelect != null) result["onSelect"] = onSelect
    if (onSubmit != null) result["onSubmit"] = onSubmit
    if (onScroll != null) result["onScroll"] = onScroll
    if (onToggle != null) result["onToggle"] = onToggle
    if (onKeyDown != null) result["onKeyDown"] = onKeyDown as (Event) -> Unit
    if (onKeyPress != null) result["onKeyPress"] = onKeyPress as (Event) -> Unit
    if (onKeyUp != null) result["onKeyUp"] = onKeyUp as (Event) -> Unit
    if (onMouseDown != null) result["onMouseDown"] = onMouseDown as (Event) -> Unit
    if (onMouseMove != null) result["onMouseMove"] = onMouseMove as (Event) -> Unit
    if (onMouseOut != null) result["onMouseOut"] = onMouseOut as (Event) -> Unit
    if (onMouseOver != null) result["onMouseOver"] = onMouseOver as (Event) -> Unit
    if (onMouseUp != null) result["onMouseUp"] = onMouseUp as (Event) -> Unit
    if (onClick != null) result["onClick"] = onClick as (Event) -> Unit
    if (onDoubleClick != null) result["onDoubleClick"] = onDoubleClick as (Event) -> Unit
    if (onWheel != null) result["onWheel"] = onWheel as (Event) -> Unit
    if (onDrag != null) result["onDrag"] = onDrag as (Event) -> Unit
    if (onDragEnd != null) result["onDragEnd"] = onDragEnd as (Event) -> Unit
    if (onDragEnter != null) result["onDragEnter"] = onDragEnter as (Event) -> Unit
    if (onDragLeave != null) result["onDragLeave"] = onDragLeave as (Event) -> Unit
    if (onDragOver != null) result["onDragOver"] = onDragOver as (Event) -> Unit
    if (onDragStart != null) result["onDragStart"] = onDragStart as (Event) -> Unit
    if (onDrop != null) result["onDrop"] = onDrop as (Event) -> Unit
    if (onCopy != null) result["onCopy"] = onCopy as (Event) -> Unit
    if (onCut != null) result["onCut"] = onCut as (Event) -> Unit
    if (onPaste != null) result["onPaste"] = onPaste as (Event) -> Unit
    return result
}

val a get() = AFactory()

class AFactory(val defaults: Map<String, Any>? = null) : TagName("a"), ElementFactory<AFactory> {
    override fun with(defaults: Map<String, Any>) = AFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        target: String? = null,
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        href: String? = null,
        rel: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        media: String? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        ping: String? = null,
        accessKey: String? = null,
        title: String? = null,
        download: String? = null,
        hrefLang: String? = null,
        translate: String? = null,
        type: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "a",
        attributes = attributes(
            defaults = defaults,
            target = target,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            href = href,
            rel = rel,
            dir = dir,
            tabIndex = tabIndex,
            media = media,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            ping = ping,
            accessKey = accessKey,
            title = title,
            download = download,
            hrefLang = hrefLang,
            translate = translate,
            type = type,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "a",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val abbr get() = AbbrFactory()

class AbbrFactory(val defaults: Map<String, Any>? = null) : TagName("abbr"), ElementFactory<AbbrFactory> {
    override fun with(defaults: Map<String, Any>) = AbbrFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "abbr",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "abbr",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val address get() = AddressFactory()

class AddressFactory(val defaults: Map<String, Any>? = null) : TagName("address"), ElementFactory<AddressFactory> {
    override fun with(defaults: Map<String, Any>) = AddressFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "address",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "address",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val area get() = AreaFactory()

class AreaFactory(val defaults: Map<String, Any>? = null) : TagName("area"), ElementFactory<AreaFactory> {
    override fun with(defaults: Map<String, Any>) = AreaFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        alt: String? = null,
        hrefLang: String? = null,
        download: String? = null,
        coords: String? = null,
        draggable: Boolean? = null,
        shape: String? = null,
        id: String? = null,
        title: String? = null,
        translate: String? = null,
        lang: String? = null,
        hidden: Boolean? = null,
        contentEditable: String? = null,
        href: String? = null,
        rel: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        accessKey: String? = null,
        type: String? = null,
        target: String? = null,
        media: String? = null,
        spellCheck: Boolean? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLAreaElement?>? = null
    ) = html(
        tag = "area",
        attributes = attributes(
            defaults = defaults,
            alt = alt,
            hrefLang = hrefLang,
            download = download,
            coords = coords,
            draggable = draggable,
            shape = shape,
            id = id,
            title = title,
            translate = translate,
            lang = lang,
            hidden = hidden,
            contentEditable = contentEditable,
            href = href,
            rel = rel,
            dir = dir,
            tabIndex = tabIndex,
            accessKey = accessKey,
            type = type,
            target = target,
            media = media,
            spellCheck = spellCheck,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "area",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val article get() = ArticleFactory()

class ArticleFactory(val defaults: Map<String, Any>? = null) : TagName("article"), ElementFactory<ArticleFactory> {
    override fun with(defaults: Map<String, Any>) = ArticleFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "article",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "article",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val aside get() = AsideFactory()

class AsideFactory(val defaults: Map<String, Any>? = null) : TagName("aside"), ElementFactory<AsideFactory> {
    override fun with(defaults: Map<String, Any>) = AsideFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "aside",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "aside",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val audio get() = AudioFactory()

class AudioFactory(val defaults: Map<String, Any>? = null) : TagName("audio"), ElementFactory<AudioFactory> {
    override fun with(defaults: Map<String, Any>) = AudioFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        muted: Boolean? = null,
        src: String? = null,
        contentEditable: String? = null,
        autoPlay: String? = null,
        preload: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        controls: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        loop: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLAudioElement?>? = null
    ) = html(
        tag = "audio",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            muted = muted,
            src = src,
            contentEditable = contentEditable,
            autoPlay = autoPlay,
            preload = preload,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            controls = controls,
            translate = translate,
            dropZone = dropZone,
            loop = loop,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "audio",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val b get() = BFactory()

class BFactory(val defaults: Map<String, Any>? = null) : TagName("b"), ElementFactory<BFactory> {
    override fun with(defaults: Map<String, Any>) = BFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "b",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "b",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val base get() = BaseFactory()

class BaseFactory(val defaults: Map<String, Any>? = null) : TagName("base"), ElementFactory<BaseFactory> {
    override fun with(defaults: Map<String, Any>) = BaseFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        target: String? = null,
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        href: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLBaseElement?>? = null
    ) = html(
        tag = "base",
        attributes = attributes(
            defaults = defaults,
            target = target,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            href = href,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "base",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val bdi get() = BdiFactory()

class BdiFactory(val defaults: Map<String, Any>? = null) : TagName("bdi"), ElementFactory<BdiFactory> {
    override fun with(defaults: Map<String, Any>) = BdiFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "bdi",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "bdi",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val bdo get() = BdoFactory()

class BdoFactory(val defaults: Map<String, Any>? = null) : TagName("bdo"), ElementFactory<BdoFactory> {
    override fun with(defaults: Map<String, Any>) = BdoFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "bdo",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "bdo",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val blockQuote get() = BlockQuoteFactory()

class BlockQuoteFactory(val defaults: Map<String, Any>? = null) : TagName("blockquote"), ElementFactory<BlockQuoteFactory> {
    override fun with(defaults: Map<String, Any>) = BlockQuoteFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        cite: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "blockquote",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            cite = cite,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "blockquote",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val body get() = BodyFactory()

class BodyFactory(val defaults: Map<String, Any>? = null) : TagName("body"), ElementFactory<BodyFactory> {
    override fun with(defaults: Map<String, Any>) = BodyFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLBodyElement?>? = null
    ) = html(
        tag = "body",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "body",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val br get() = BrFactory()

class BrFactory(val defaults: Map<String, Any>? = null) : TagName("br"), ElementFactory<BrFactory> {
    override fun with(defaults: Map<String, Any>) = BrFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLBRElement?>? = null
    ) = html(
        tag = "br",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "br",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val button get() = ButtonFactory()

class ButtonFactory(val defaults: Map<String, Any>? = null) : TagName("button"), ElementFactory<ButtonFactory> {
    override fun with(defaults: Map<String, Any>) = ButtonFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        formNoValidate: Boolean? = null,
        form: String? = null,
        formTarget: String? = null,
        autoFocus: Boolean? = null,
        draggable: Boolean? = null,
        name: String? = null,
        id: String? = null,
        value: String? = null,
        formEncType: String? = null,
        formAction: String? = null,
        title: String? = null,
        translate: String? = null,
        lang: String? = null,
        hidden: Boolean? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        accessKey: String? = null,
        formMethod: String? = null,
        type: String? = null,
        disabled: Boolean? = null,
        spellCheck: Boolean? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLButtonElement?>? = null
    ) = html(
        tag = "button",
        attributes = attributes(
            defaults = defaults,
            formNoValidate = formNoValidate,
            form = form,
            formTarget = formTarget,
            autoFocus = autoFocus,
            draggable = draggable,
            name = name,
            id = id,
            value = value,
            formEncType = formEncType,
            formAction = formAction,
            title = title,
            translate = translate,
            lang = lang,
            hidden = hidden,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            accessKey = accessKey,
            formMethod = formMethod,
            type = type,
            disabled = disabled,
            spellCheck = spellCheck,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "button",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val canvas get() = CanvasFactory()

class CanvasFactory(val defaults: Map<String, Any>? = null) : TagName("canvas"), ElementFactory<CanvasFactory> {
    override fun with(defaults: Map<String, Any>) = CanvasFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        height: Int? = null,
        width: Int? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLCanvasElement?>? = null
    ) = html(
        tag = "canvas",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            height = height,
            width = width,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "canvas",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val caption get() = CaptionFactory()

class CaptionFactory(val defaults: Map<String, Any>? = null) : TagName("caption"), ElementFactory<CaptionFactory> {
    override fun with(defaults: Map<String, Any>) = CaptionFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLTableCaptionElement?>? = null
    ) = html(
        tag = "caption",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "caption",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val cite get() = CiteFactory()

class CiteFactory(val defaults: Map<String, Any>? = null) : TagName("cite"), ElementFactory<CiteFactory> {
    override fun with(defaults: Map<String, Any>) = CiteFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "cite",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "cite",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val code get() = CodeFactory()

class CodeFactory(val defaults: Map<String, Any>? = null) : TagName("code"), ElementFactory<CodeFactory> {
    override fun with(defaults: Map<String, Any>) = CodeFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "code",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "code",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val col get() = ColFactory()

class ColFactory(val defaults: Map<String, Any>? = null) : TagName("col"), ElementFactory<ColFactory> {
    override fun with(defaults: Map<String, Any>) = ColFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        span: Int? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLTableColElement?>? = null
    ) = html(
        tag = "col",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            span = span,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "col",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val colGroup get() = ColGroupFactory()

class ColGroupFactory(val defaults: Map<String, Any>? = null) : TagName("colgroup"), ElementFactory<ColGroupFactory> {
    override fun with(defaults: Map<String, Any>) = ColGroupFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        span: Int? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLTableColElement?>? = null
    ) = html(
        tag = "colgroup",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            span = span,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "colgroup",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val data get() = DataFactory()

class DataFactory(val defaults: Map<String, Any>? = null) : TagName("data"), ElementFactory<DataFactory> {
    override fun with(defaults: Map<String, Any>) = DataFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLDataElement?>? = null
    ) = html(
        tag = "data",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "data",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val dataList get() = DataListFactory()

class DataListFactory(val defaults: Map<String, Any>? = null) : TagName("datalist"), ElementFactory<DataListFactory> {
    override fun with(defaults: Map<String, Any>) = DataListFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLDataListElement?>? = null
    ) = html(
        tag = "datalist",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "datalist",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val dd get() = DdFactory()

class DdFactory(val defaults: Map<String, Any>? = null) : TagName("dd"), ElementFactory<DdFactory> {
    override fun with(defaults: Map<String, Any>) = DdFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "dd",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "dd",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val del get() = DelFactory()

class DelFactory(val defaults: Map<String, Any>? = null) : TagName("del"), ElementFactory<DelFactory> {
    override fun with(defaults: Map<String, Any>) = DelFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        datetime: String? = null,
        accessKey: String? = null,
        title: String? = null,
        cite: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "del",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            datetime = datetime,
            accessKey = accessKey,
            title = title,
            cite = cite,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "del",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val details get() = DetailsFactory()

class DetailsFactory(val defaults: Map<String, Any>? = null) : TagName("details"), ElementFactory<DetailsFactory> {
    override fun with(defaults: Map<String, Any>) = DetailsFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        open: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLDetailsElement?>? = null
    ) = html(
        tag = "details",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            open = open,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "details",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val dfn get() = DfnFactory()

class DfnFactory(val defaults: Map<String, Any>? = null) : TagName("dfn"), ElementFactory<DfnFactory> {
    override fun with(defaults: Map<String, Any>) = DfnFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "dfn",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "dfn",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val dialog get() = DialogFactory()

class DialogFactory(val defaults: Map<String, Any>? = null) : TagName("dialog"), ElementFactory<DialogFactory> {
    override fun with(defaults: Map<String, Any>) = DialogFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        open: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLDialogElement?>? = null
    ) = html(
        tag = "dialog",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            open = open,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "dialog",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val div get() = DivFactory()

class DivFactory(val defaults: Map<String, Any>? = null) : TagName("div"), ElementFactory<DivFactory> {
    override fun with(defaults: Map<String, Any>) = DivFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLDivElement?>? = null
    ) = html(
        tag = "div",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "div",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val dl get() = DlFactory()

class DlFactory(val defaults: Map<String, Any>? = null) : TagName("dl"), ElementFactory<DlFactory> {
    override fun with(defaults: Map<String, Any>) = DlFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLDListElement?>? = null
    ) = html(
        tag = "dl",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "dl",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val dt get() = DtFactory()

class DtFactory(val defaults: Map<String, Any>? = null) : TagName("dt"), ElementFactory<DtFactory> {
    override fun with(defaults: Map<String, Any>) = DtFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "dt",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "dt",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val em get() = EmFactory()

class EmFactory(val defaults: Map<String, Any>? = null) : TagName("em"), ElementFactory<EmFactory> {
    override fun with(defaults: Map<String, Any>) = EmFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "em",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "em",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val embed get() = EmbedFactory()

class EmbedFactory(val defaults: Map<String, Any>? = null) : TagName("embed"), ElementFactory<EmbedFactory> {
    override fun with(defaults: Map<String, Any>) = EmbedFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        src: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        height: Int? = null,
        width: Int? = null,
        translate: String? = null,
        type: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLEmbedElement?>? = null
    ) = html(
        tag = "embed",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            src = src,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            height = height,
            width = width,
            translate = translate,
            type = type,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "embed",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val fieldSet get() = FieldSetFactory()

class FieldSetFactory(val defaults: Map<String, Any>? = null) : TagName("fieldset"), ElementFactory<FieldSetFactory> {
    override fun with(defaults: Map<String, Any>) = FieldSetFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        name: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        disabled: Boolean? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        form: String? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLFieldSetElement?>? = null
    ) = html(
        tag = "fieldset",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            name = name,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            disabled = disabled,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            form = form,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "fieldset",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val figCaption get() = FigCaptionFactory()

class FigCaptionFactory(val defaults: Map<String, Any>? = null) : TagName("figcaption"), ElementFactory<FigCaptionFactory> {
    override fun with(defaults: Map<String, Any>) = FigCaptionFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "figcaption",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "figcaption",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val figure get() = FigureFactory()

class FigureFactory(val defaults: Map<String, Any>? = null) : TagName("figure"), ElementFactory<FigureFactory> {
    override fun with(defaults: Map<String, Any>) = FigureFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "figure",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "figure",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val footer get() = FooterFactory()

class FooterFactory(val defaults: Map<String, Any>? = null) : TagName("footer"), ElementFactory<FooterFactory> {
    override fun with(defaults: Map<String, Any>) = FooterFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "footer",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "footer",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val form get() = FormFactory()

class FormFactory(val defaults: Map<String, Any>? = null) : TagName("form"), ElementFactory<FormFactory> {
    override fun with(defaults: Map<String, Any>) = FormFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        target: String? = null,
        hidden: Boolean? = null,
        id: String? = null,
        name: String? = null,
        contentEditable: String? = null,
        encType: String? = null,
        noValidate: Boolean? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        action: String? = null,
        autocomplete: Boolean? = null,
        acceptCharset: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        method: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLFormElement?>? = null
    ) = html(
        tag = "form",
        attributes = attributes(
            defaults = defaults,
            target = target,
            hidden = hidden,
            id = id,
            name = name,
            contentEditable = contentEditable,
            encType = encType,
            noValidate = noValidate,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            action = action,
            autocomplete = autocomplete,
            acceptCharset = acceptCharset,
            translate = translate,
            dropZone = dropZone,
            method = method,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "form",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val h1 get() = H1Factory()

class H1Factory(val defaults: Map<String, Any>? = null) : TagName("h1"), ElementFactory<H1Factory> {
    override fun with(defaults: Map<String, Any>) = H1Factory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLHeadingElement?>? = null
    ) = html(
        tag = "h1",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "h1",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val h2 get() = H2Factory()

class H2Factory(val defaults: Map<String, Any>? = null) : TagName("h2"), ElementFactory<H2Factory> {
    override fun with(defaults: Map<String, Any>) = H2Factory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLHeadingElement?>? = null
    ) = html(
        tag = "h2",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "h2",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val h3 get() = H3Factory()

class H3Factory(val defaults: Map<String, Any>? = null) : TagName("h3"), ElementFactory<H3Factory> {
    override fun with(defaults: Map<String, Any>) = H3Factory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLHeadingElement?>? = null
    ) = html(
        tag = "h3",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "h3",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val h4 get() = H4Factory()

class H4Factory(val defaults: Map<String, Any>? = null) : TagName("h4"), ElementFactory<H4Factory> {
    override fun with(defaults: Map<String, Any>) = H4Factory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLHeadingElement?>? = null
    ) = html(
        tag = "h4",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "h4",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val h5 get() = H5Factory()

class H5Factory(val defaults: Map<String, Any>? = null) : TagName("h5"), ElementFactory<H5Factory> {
    override fun with(defaults: Map<String, Any>) = H5Factory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLHeadingElement?>? = null
    ) = html(
        tag = "h5",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "h5",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val h6 get() = H6Factory()

class H6Factory(val defaults: Map<String, Any>? = null) : TagName("h6"), ElementFactory<H6Factory> {
    override fun with(defaults: Map<String, Any>) = H6Factory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLHeadingElement?>? = null
    ) = html(
        tag = "h6",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "h6",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val head get() = HeadFactory()

class HeadFactory(val defaults: Map<String, Any>? = null) : TagName("head"), ElementFactory<HeadFactory> {
    override fun with(defaults: Map<String, Any>) = HeadFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLHeadElement?>? = null
    ) = html(
        tag = "head",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "head",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val header get() = HeaderFactory()

class HeaderFactory(val defaults: Map<String, Any>? = null) : TagName("header"), ElementFactory<HeaderFactory> {
    override fun with(defaults: Map<String, Any>) = HeaderFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "header",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "header",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val hr get() = HrFactory()

class HrFactory(val defaults: Map<String, Any>? = null) : TagName("hr"), ElementFactory<HrFactory> {
    override fun with(defaults: Map<String, Any>) = HrFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "hr",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "hr",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val html get() = HtmlFactory()

class HtmlFactory(val defaults: Map<String, Any>? = null) : TagName("html"), ElementFactory<HtmlFactory> {
    override fun with(defaults: Map<String, Any>) = HtmlFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        xmlns: String? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "html",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            xmlns = xmlns,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "html",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val i get() = IFactory()

class IFactory(val defaults: Map<String, Any>? = null) : TagName("i"), ElementFactory<IFactory> {
    override fun with(defaults: Map<String, Any>) = IFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "i",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "i",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val iframe get() = IframeFactory()

class IframeFactory(val defaults: Map<String, Any>? = null) : TagName("iframe"), ElementFactory<IframeFactory> {
    override fun with(defaults: Map<String, Any>) = IframeFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        name: String? = null,
        src: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        height: Int? = null,
        width: Int? = null,
        translate: String? = null,
        sandbox: String? = null,
        dropZone: String? = null,
        srcDoc: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLIFrameElement?>? = null
    ) = html(
        tag = "iframe",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            name = name,
            src = src,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            height = height,
            width = width,
            translate = translate,
            sandbox = sandbox,
            dropZone = dropZone,
            srcDoc = srcDoc,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "iframe",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val img get() = ImgFactory()

class ImgFactory(val defaults: Map<String, Any>? = null) : TagName("img"), ElementFactory<ImgFactory> {
    override fun with(defaults: Map<String, Any>) = ImgFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        src: String? = null,
        useMap: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        isMap: String? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        alt: String? = null,
        accessKey: String? = null,
        title: String? = null,
        height: Int? = null,
        width: Int? = null,
        longDesc: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLImageElement?>? = null
    ) = html(
        tag = "img",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            src = src,
            useMap = useMap,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            isMap = isMap,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            alt = alt,
            accessKey = accessKey,
            title = title,
            height = height,
            width = width,
            longDesc = longDesc,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "img",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val input get() = InputFactory()

class InputFactory(val defaults: Map<String, Any>? = null) : TagName("input"), ElementFactory<InputFactory> {
    override fun with(defaults: Map<String, Any>) = InputFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        formNoValidate: Boolean? = null,
        multiple: String? = null,
        min: String? = null,
        alt: String? = null,
        accept: String? = null,
        form: String? = null,
        step: Double? = null,
        width: Int? = null,
        formTarget: String? = null,
        autoFocus: Boolean? = null,
        draggable: Boolean? = null,
        name: String? = null,
        id: String? = null,
        size: String? = null,
        readonly: Boolean? = null,
        value: String? = null,
        list: String? = null,
        formEncType: String? = null,
        formAction: String? = null,
        title: String? = null,
        height: Int? = null,
        translate: String? = null,
        lang: String? = null,
        hidden: Boolean? = null,
        contentEditable: String? = null,
        pattern: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        maxLength: Int? = null,
        max: String? = null,
        accessKey: String? = null,
        formMethod: String? = null,
        dirname: String? = null,
        type: String? = null,
        src: String? = null,
        placeholder: String? = null,
        disabled: Boolean? = null,
        checked: Boolean? = null,
        spellCheck: Boolean? = null,
        required: Boolean? = null,
        autocomplete: Boolean? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLInputElement?>? = null
    ) = html(
        tag = "input",
        attributes = attributes(
            defaults = defaults,
            formNoValidate = formNoValidate,
            multiple = multiple,
            min = min,
            alt = alt,
            accept = accept,
            form = form,
            step = step,
            width = width,
            formTarget = formTarget,
            autoFocus = autoFocus,
            draggable = draggable,
            name = name,
            id = id,
            size = size,
            readonly = readonly,
            value = value,
            list = list,
            formEncType = formEncType,
            formAction = formAction,
            title = title,
            height = height,
            translate = translate,
            lang = lang,
            hidden = hidden,
            contentEditable = contentEditable,
            pattern = pattern,
            dir = dir,
            tabIndex = tabIndex,
            maxLength = maxLength,
            max = max,
            accessKey = accessKey,
            formMethod = formMethod,
            dirname = dirname,
            type = type,
            src = src,
            placeholder = placeholder,
            disabled = disabled,
            checked = checked,
            spellCheck = spellCheck,
            required = required,
            autocomplete = autocomplete,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "input",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val ins get() = InsFactory()

class InsFactory(val defaults: Map<String, Any>? = null) : TagName("ins"), ElementFactory<InsFactory> {
    override fun with(defaults: Map<String, Any>) = InsFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        datetime: String? = null,
        accessKey: String? = null,
        title: String? = null,
        cite: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "ins",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            datetime = datetime,
            accessKey = accessKey,
            title = title,
            cite = cite,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "ins",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val kbd get() = KbdFactory()

class KbdFactory(val defaults: Map<String, Any>? = null) : TagName("kbd"), ElementFactory<KbdFactory> {
    override fun with(defaults: Map<String, Any>) = KbdFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "kbd",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "kbd",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val label get() = LabelFactory()

class LabelFactory(val defaults: Map<String, Any>? = null) : TagName("label"), ElementFactory<LabelFactory> {
    override fun with(defaults: Map<String, Any>) = LabelFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        `for`: String? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        form: String? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLLabelElement?>? = null
    ) = html(
        tag = "label",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            `for` = `for`,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            form = form,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "label",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val legend get() = LegendFactory()

class LegendFactory(val defaults: Map<String, Any>? = null) : TagName("legend"), ElementFactory<LegendFactory> {
    override fun with(defaults: Map<String, Any>) = LegendFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLLegendElement?>? = null
    ) = html(
        tag = "legend",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "legend",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val li get() = LiFactory()

class LiFactory(val defaults: Map<String, Any>? = null) : TagName("li"), ElementFactory<LiFactory> {
    override fun with(defaults: Map<String, Any>) = LiFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        value: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "li",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            value = value,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "li",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val link get() = LinkFactory()

class LinkFactory(val defaults: Map<String, Any>? = null) : TagName("link"), ElementFactory<LinkFactory> {
    override fun with(defaults: Map<String, Any>) = LinkFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        href: String? = null,
        rel: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        media: String? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        sizes: String? = null,
        accessKey: String? = null,
        title: String? = null,
        hrefLang: String? = null,
        translate: String? = null,
        type: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLLinkElement?>? = null
    ) = html(
        tag = "link",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            href = href,
            rel = rel,
            dir = dir,
            tabIndex = tabIndex,
            media = media,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            sizes = sizes,
            accessKey = accessKey,
            title = title,
            hrefLang = hrefLang,
            translate = translate,
            type = type,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "link",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val main get() = MainFactory()

class MainFactory(val defaults: Map<String, Any>? = null) : TagName("main"), ElementFactory<MainFactory> {
    override fun with(defaults: Map<String, Any>) = MainFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "main",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "main",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val map get() = MapFactory()

class MapFactory(val defaults: Map<String, Any>? = null) : TagName("map"), ElementFactory<MapFactory> {
    override fun with(defaults: Map<String, Any>) = MapFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        name: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLMapElement?>? = null
    ) = html(
        tag = "map",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            name = name,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "map",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val mark get() = MarkFactory()

class MarkFactory(val defaults: Map<String, Any>? = null) : TagName("mark"), ElementFactory<MarkFactory> {
    override fun with(defaults: Map<String, Any>) = MarkFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "mark",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "mark",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val meta get() = MetaFactory()

class MetaFactory(val defaults: Map<String, Any>? = null) : TagName("meta"), ElementFactory<MetaFactory> {
    override fun with(defaults: Map<String, Any>) = MetaFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        name: String? = null,
        contentEditable: String? = null,
        content: String? = null,
        charset: String? = null,
        httpEquiv: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLMetaElement?>? = null
    ) = html(
        tag = "meta",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            name = name,
            contentEditable = contentEditable,
            content = content,
            charset = charset,
            httpEquiv = httpEquiv,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "meta",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val meter get() = MeterFactory()

class MeterFactory(val defaults: Map<String, Any>? = null) : TagName("meter"), ElementFactory<MeterFactory> {
    override fun with(defaults: Map<String, Any>) = MeterFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        high: String? = null,
        contentEditable: String? = null,
        value: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        max: String? = null,
        form: String? = null,
        min: String? = null,
        accessKey: String? = null,
        title: String? = null,
        low: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        optimum: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLMeterElement?>? = null
    ) = html(
        tag = "meter",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            high = high,
            contentEditable = contentEditable,
            value = value,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            max = max,
            form = form,
            min = min,
            accessKey = accessKey,
            title = title,
            low = low,
            translate = translate,
            dropZone = dropZone,
            optimum = optimum,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "meter",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val nav get() = NavFactory()

class NavFactory(val defaults: Map<String, Any>? = null) : TagName("nav"), ElementFactory<NavFactory> {
    override fun with(defaults: Map<String, Any>) = NavFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "nav",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "nav",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val noScript get() = NoScriptFactory()

class NoScriptFactory(val defaults: Map<String, Any>? = null) : TagName("noscript"), ElementFactory<NoScriptFactory> {
    override fun with(defaults: Map<String, Any>) = NoScriptFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "noscript",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "noscript",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val htmlObject get() = HtmlObjectFactory()

class HtmlObjectFactory(val defaults: Map<String, Any>? = null) : TagName("object"), ElementFactory<HtmlObjectFactory> {
    override fun with(defaults: Map<String, Any>) = HtmlObjectFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        data: String? = null,
        name: String? = null,
        contentEditable: String? = null,
        useMap: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        form: String? = null,
        accessKey: String? = null,
        title: String? = null,
        height: Int? = null,
        width: Int? = null,
        translate: String? = null,
        type: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLObjectElement?>? = null
    ) = html(
        tag = "object",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            data = data,
            name = name,
            contentEditable = contentEditable,
            useMap = useMap,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            form = form,
            accessKey = accessKey,
            title = title,
            height = height,
            width = width,
            translate = translate,
            type = type,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "object",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val ol get() = OlFactory()

class OlFactory(val defaults: Map<String, Any>? = null) : TagName("ol"), ElementFactory<OlFactory> {
    override fun with(defaults: Map<String, Any>) = OlFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        reversed: String? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        start: String? = null,
        dropZone: String? = null,
        type: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLOListElement?>? = null
    ) = html(
        tag = "ol",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            reversed = reversed,
            accessKey = accessKey,
            title = title,
            translate = translate,
            start = start,
            dropZone = dropZone,
            type = type,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "ol",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val optGroup get() = OptGroupFactory()

class OptGroupFactory(val defaults: Map<String, Any>? = null) : TagName("optgroup"), ElementFactory<OptGroupFactory> {
    override fun with(defaults: Map<String, Any>) = OptGroupFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        label: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        disabled: Boolean? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLOptGroupElement?>? = null
    ) = html(
        tag = "optgroup",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            label = label,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            disabled = disabled,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "optgroup",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val option get() = OptionFactory()

class OptionFactory(val defaults: Map<String, Any>? = null) : TagName("option"), ElementFactory<OptionFactory> {
    override fun with(defaults: Map<String, Any>) = OptionFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        label: String? = null,
        contentEditable: String? = null,
        value: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        disabled: Boolean? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        selected: Boolean? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLOptionElement?>? = null
    ) = html(
        tag = "option",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            label = label,
            contentEditable = contentEditable,
            value = value,
            dir = dir,
            tabIndex = tabIndex,
            disabled = disabled,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            selected = selected,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "option",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val output get() = OutputFactory()

class OutputFactory(val defaults: Map<String, Any>? = null) : TagName("output"), ElementFactory<OutputFactory> {
    override fun with(defaults: Map<String, Any>) = OutputFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        name: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        `for`: String? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        form: String? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLOutputElement?>? = null
    ) = html(
        tag = "output",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            name = name,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            `for` = `for`,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            form = form,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "output",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val p get() = PFactory()

class PFactory(val defaults: Map<String, Any>? = null) : TagName("p"), ElementFactory<PFactory> {
    override fun with(defaults: Map<String, Any>) = PFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLParagraphElement?>? = null
    ) = html(
        tag = "p",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "p",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val param get() = ParamFactory()

class ParamFactory(val defaults: Map<String, Any>? = null) : TagName("param"), ElementFactory<ParamFactory> {
    override fun with(defaults: Map<String, Any>) = ParamFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        name: String? = null,
        contentEditable: String? = null,
        value: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLParamElement?>? = null
    ) = html(
        tag = "param",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            name = name,
            contentEditable = contentEditable,
            value = value,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "param",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val path get() = PathFactory()

class PathFactory(val defaults: Map<String, Any>? = null) : TagName("path"), ElementFactory<PathFactory> {
    override fun with(defaults: Map<String, Any>) = PathFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        d: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out SVGPathElement?>? = null
    ) = html(
        tag = "path",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            d = d,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )
}

val picture get() = PictureFactory()

class PictureFactory(val defaults: Map<String, Any>? = null) : TagName("picture"), ElementFactory<PictureFactory> {
    override fun with(defaults: Map<String, Any>) = PictureFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLPictureElement?>? = null
    ) = html(
        tag = "picture",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "picture",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val pre get() = PreFactory()

class PreFactory(val defaults: Map<String, Any>? = null) : TagName("pre"), ElementFactory<PreFactory> {
    override fun with(defaults: Map<String, Any>) = PreFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLPreElement?>? = null
    ) = html(
        tag = "pre",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "pre",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val progress get() = ProgressFactory()

class ProgressFactory(val defaults: Map<String, Any>? = null) : TagName("progress"), ElementFactory<ProgressFactory> {
    override fun with(defaults: Map<String, Any>) = ProgressFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        value: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        max: String? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLProgressElement?>? = null
    ) = html(
        tag = "progress",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            value = value,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            max = max,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "progress",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val q get() = QFactory()

class QFactory(val defaults: Map<String, Any>? = null) : TagName("q"), ElementFactory<QFactory> {
    override fun with(defaults: Map<String, Any>) = QFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        cite: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLQuoteElement?>? = null
    ) = html(
        tag = "q",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            cite = cite,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "q",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val rp get() = RpFactory()

class RpFactory(val defaults: Map<String, Any>? = null) : TagName("rp"), ElementFactory<RpFactory> {
    override fun with(defaults: Map<String, Any>) = RpFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "rp",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "rp",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val rt get() = RtFactory()

class RtFactory(val defaults: Map<String, Any>? = null) : TagName("rt"), ElementFactory<RtFactory> {
    override fun with(defaults: Map<String, Any>) = RtFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "rt",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "rt",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val ruby get() = RubyFactory()

class RubyFactory(val defaults: Map<String, Any>? = null) : TagName("ruby"), ElementFactory<RubyFactory> {
    override fun with(defaults: Map<String, Any>) = RubyFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "ruby",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "ruby",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val s get() = SFactory()

class SFactory(val defaults: Map<String, Any>? = null) : TagName("s"), ElementFactory<SFactory> {
    override fun with(defaults: Map<String, Any>) = SFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "s",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "s",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val samp get() = SampFactory()

class SampFactory(val defaults: Map<String, Any>? = null) : TagName("samp"), ElementFactory<SampFactory> {
    override fun with(defaults: Map<String, Any>) = SampFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "samp",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "samp",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val script get() = ScriptFactory()

class ScriptFactory(val defaults: Map<String, Any>? = null) : TagName("script"), ElementFactory<ScriptFactory> {
    override fun with(defaults: Map<String, Any>) = ScriptFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        src: String? = null,
        contentEditable: String? = null,
        charset: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        async: String? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        defer: String? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        type: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLScriptElement?>? = null
    ) = html(
        tag = "script",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            src = src,
            contentEditable = contentEditable,
            charset = charset,
            dir = dir,
            tabIndex = tabIndex,
            async = async,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            defer = defer,
            accessKey = accessKey,
            title = title,
            translate = translate,
            type = type,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "script",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val section get() = SectionFactory()

class SectionFactory(val defaults: Map<String, Any>? = null) : TagName("section"), ElementFactory<SectionFactory> {
    override fun with(defaults: Map<String, Any>) = SectionFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "section",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "section",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val select get() = SelectFactory()

class SelectFactory(val defaults: Map<String, Any>? = null) : TagName("select"), ElementFactory<SelectFactory> {
    override fun with(defaults: Map<String, Any>) = SelectFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        name: String? = null,
        size: String? = null,
        contentEditable: String? = null,
        multiple: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        disabled: Boolean? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        required: Boolean? = null,
        form: String? = null,
        accessKey: String? = null,
        title: String? = null,
        autoFocus: Boolean? = null,
        translate: String? = null,
        dropZone: String? = null,
        value: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLSelectElement?>? = null
    ) = html(
        tag = "select",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            name = name,
            size = size,
            contentEditable = contentEditable,
            multiple = multiple,
            dir = dir,
            tabIndex = tabIndex,
            disabled = disabled,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            required = required,
            form = form,
            accessKey = accessKey,
            title = title,
            autoFocus = autoFocus,
            translate = translate,
            dropZone = dropZone,
            value = value,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "select",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val small get() = SmallFactory()

class SmallFactory(val defaults: Map<String, Any>? = null) : TagName("small"), ElementFactory<SmallFactory> {
    override fun with(defaults: Map<String, Any>) = SmallFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "small",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "small",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val source get() = SourceFactory()

class SourceFactory(val defaults: Map<String, Any>? = null) : TagName("source"), ElementFactory<SourceFactory> {
    override fun with(defaults: Map<String, Any>) = SourceFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        src: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        media: String? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        type: String? = null,
        dropZone: String? = null,
        srcSet: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLSourceElement?>? = null
    ) = html(
        tag = "source",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            src = src,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            media = media,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            type = type,
            dropZone = dropZone,
            srcSet = srcSet,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "source",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val span get() = SpanFactory()

class SpanFactory(val defaults: Map<String, Any>? = null) : TagName("span"), ElementFactory<SpanFactory> {
    override fun with(defaults: Map<String, Any>) = SpanFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLSpanElement?>? = null
    ) = html(
        tag = "span",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "span",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val strong get() = StrongFactory()

class StrongFactory(val defaults: Map<String, Any>? = null) : TagName("strong"), ElementFactory<StrongFactory> {
    override fun with(defaults: Map<String, Any>) = StrongFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "strong",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "strong",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val style get() = StyleFactory()

class StyleFactory(val defaults: Map<String, Any>? = null) : TagName("style"), ElementFactory<StyleFactory> {
    override fun with(defaults: Map<String, Any>) = StyleFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        media: String? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        type: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLStyleElement?>? = null
    ) = html(
        tag = "style",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            media = media,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            type = type,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "style",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val sub get() = SubFactory()

class SubFactory(val defaults: Map<String, Any>? = null) : TagName("sub"), ElementFactory<SubFactory> {
    override fun with(defaults: Map<String, Any>) = SubFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "sub",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "sub",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val summary get() = SummaryFactory()

class SummaryFactory(val defaults: Map<String, Any>? = null) : TagName("summary"), ElementFactory<SummaryFactory> {
    override fun with(defaults: Map<String, Any>) = SummaryFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "summary",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "summary",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val sup get() = SupFactory()

class SupFactory(val defaults: Map<String, Any>? = null) : TagName("sup"), ElementFactory<SupFactory> {
    override fun with(defaults: Map<String, Any>) = SupFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "sup",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "sup",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val svg get() = SvgFactory()

class SvgFactory(val defaults: Map<String, Any>? = null) : TagName("svg"), ElementFactory<SvgFactory> {
    override fun with(defaults: Map<String, Any>) = SvgFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        width: Int? = null,
        height: Int? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out SVGElement?>? = null
    ) = html(
        tag = "svg",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            width = width,
            height = height,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "svg",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val table get() = TableFactory()

class TableFactory(val defaults: Map<String, Any>? = null) : TagName("table"), ElementFactory<TableFactory> {
    override fun with(defaults: Map<String, Any>) = TableFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLTableElement?>? = null
    ) = html(
        tag = "table",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "table",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val tbody get() = TbodyFactory()

class TbodyFactory(val defaults: Map<String, Any>? = null) : TagName("tbody"), ElementFactory<TbodyFactory> {
    override fun with(defaults: Map<String, Any>) = TbodyFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "tbody",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "tbody",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val td get() = TdFactory()

class TdFactory(val defaults: Map<String, Any>? = null) : TagName("td"), ElementFactory<TdFactory> {
    override fun with(defaults: Map<String, Any>) = TdFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        colSpan: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        rowSpan: Int? = null,
        accessKey: String? = null,
        title: String? = null,
        headers: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLTableCellElement?>? = null
    ) = html(
        tag = "td",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            colSpan = colSpan,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            rowSpan = rowSpan,
            accessKey = accessKey,
            title = title,
            headers = headers,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "td",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val template get() = TemplateFactory()

class TemplateFactory(val defaults: Map<String, Any>? = null) : TagName("template"), ElementFactory<TemplateFactory> {
    override fun with(defaults: Map<String, Any>) = TemplateFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLTemplateElement?>? = null
    ) = html(
        tag = "template",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "template",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val textArea get() = TextAreaFactory()

class TextAreaFactory(val defaults: Map<String, Any>? = null) : TagName("textarea"), ElementFactory<TextAreaFactory> {
    override fun with(defaults: Map<String, Any>) = TextAreaFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        form: String? = null,
        autoFocus: Boolean? = null,
        draggable: Boolean? = null,
        name: String? = null,
        id: String? = null,
        readonly: Boolean? = null,
        title: String? = null,
        wrap: String? = null,
        translate: String? = null,
        lang: String? = null,
        hidden: Boolean? = null,
        contentEditable: String? = null,
        rows: Int? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        maxLength: Int? = null,
        accessKey: String? = null,
        cols: Int? = null,
        dirname: String? = null,
        placeholder: String? = null,
        disabled: Boolean? = null,
        spellCheck: Boolean? = null,
        required: Boolean? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLTextAreaElement?>? = null
    ) = html(
        tag = "textarea",
        attributes = attributes(
            defaults = defaults,
            form = form,
            autoFocus = autoFocus,
            draggable = draggable,
            name = name,
            id = id,
            readonly = readonly,
            title = title,
            wrap = wrap,
            translate = translate,
            lang = lang,
            hidden = hidden,
            contentEditable = contentEditable,
            rows = rows,
            dir = dir,
            tabIndex = tabIndex,
            maxLength = maxLength,
            accessKey = accessKey,
            cols = cols,
            dirname = dirname,
            placeholder = placeholder,
            disabled = disabled,
            spellCheck = spellCheck,
            required = required,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "textarea",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val tfoot get() = TfootFactory()

class TfootFactory(val defaults: Map<String, Any>? = null) : TagName("tfoot"), ElementFactory<TfootFactory> {
    override fun with(defaults: Map<String, Any>) = TfootFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "tfoot",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "tfoot",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val th get() = ThFactory()

class ThFactory(val defaults: Map<String, Any>? = null) : TagName("th"), ElementFactory<ThFactory> {
    override fun with(defaults: Map<String, Any>) = ThFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        colSpan: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        rowSpan: Int? = null,
        abbr: String? = null,
        accessKey: String? = null,
        title: String? = null,
        headers: String? = null,
        scope: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLTableCellElement?>? = null
    ) = html(
        tag = "th",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            colSpan = colSpan,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            rowSpan = rowSpan,
            abbr = abbr,
            accessKey = accessKey,
            title = title,
            headers = headers,
            scope = scope,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "th",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val thead get() = TheadFactory()

class TheadFactory(val defaults: Map<String, Any>? = null) : TagName("thead"), ElementFactory<TheadFactory> {
    override fun with(defaults: Map<String, Any>) = TheadFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "thead",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "thead",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val time get() = TimeFactory()

class TimeFactory(val defaults: Map<String, Any>? = null) : TagName("time"), ElementFactory<TimeFactory> {
    override fun with(defaults: Map<String, Any>) = TimeFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        datetime: String? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLTimeElement?>? = null
    ) = html(
        tag = "time",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            datetime = datetime,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "time",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val title get() = TitleFactory()

class TitleFactory(val defaults: Map<String, Any>? = null) : TagName("title"), ElementFactory<TitleFactory> {
    override fun with(defaults: Map<String, Any>) = TitleFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLTitleElement?>? = null
    ) = html(
        tag = "title",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "title",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val tr get() = TrFactory()

class TrFactory(val defaults: Map<String, Any>? = null) : TagName("tr"), ElementFactory<TrFactory> {
    override fun with(defaults: Map<String, Any>) = TrFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLTableRowElement?>? = null
    ) = html(
        tag = "tr",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "tr",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val track get() = TrackFactory()

class TrackFactory(val defaults: Map<String, Any>? = null) : TagName("track"), ElementFactory<TrackFactory> {
    override fun with(defaults: Map<String, Any>) = TrackFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        kind: String? = null,
        hidden: Boolean? = null,
        id: String? = null,
        label: String? = null,
        src: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        default: String? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        srcLang: String? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLTrackElement?>? = null
    ) = html(
        tag = "track",
        attributes = attributes(
            defaults = defaults,
            kind = kind,
            hidden = hidden,
            id = id,
            label = label,
            src = src,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            default = default,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            srcLang = srcLang,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "track",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val u get() = UFactory()

class UFactory(val defaults: Map<String, Any>? = null) : TagName("u"), ElementFactory<UFactory> {
    override fun with(defaults: Map<String, Any>) = UFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "u",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "u",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val ul get() = UlFactory()

class UlFactory(val defaults: Map<String, Any>? = null) : TagName("ul"), ElementFactory<UlFactory> {
    override fun with(defaults: Map<String, Any>) = UlFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLUListElement?>? = null
    ) = html(
        tag = "ul",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "ul",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val htmlVar get() = HtmlVarFactory()

class HtmlVarFactory(val defaults: Map<String, Any>? = null) : TagName("var"), ElementFactory<HtmlVarFactory> {
    override fun with(defaults: Map<String, Any>) = HtmlVarFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "var",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "var",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val video get() = VideoFactory()

class VideoFactory(val defaults: Map<String, Any>? = null) : TagName("video"), ElementFactory<VideoFactory> {
    override fun with(defaults: Map<String, Any>) = VideoFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        autoPlay: String? = null,
        width: Int? = null,
        draggable: Boolean? = null,
        id: String? = null,
        preload: String? = null,
        title: String? = null,
        height: Int? = null,
        translate: String? = null,
        lang: String? = null,
        hidden: Boolean? = null,
        muted: Boolean? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        accessKey: String? = null,
        controls: String? = null,
        loop: String? = null,
        src: String? = null,
        spellCheck: Boolean? = null,
        dropZone: String? = null,
        poster: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLVideoElement?>? = null
    ) = html(
        tag = "video",
        attributes = attributes(
            defaults = defaults,
            autoPlay = autoPlay,
            width = width,
            draggable = draggable,
            id = id,
            preload = preload,
            title = title,
            height = height,
            translate = translate,
            lang = lang,
            hidden = hidden,
            muted = muted,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            accessKey = accessKey,
            controls = controls,
            loop = loop,
            src = src,
            spellCheck = spellCheck,
            dropZone = dropZone,
            poster = poster,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "video",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

val wbr get() = WbrFactory()

class WbrFactory(val defaults: Map<String, Any>? = null) : TagName("wbr"), ElementFactory<WbrFactory> {
    override fun with(defaults: Map<String, Any>) = WbrFactory((this.defaults ?: emptyMap()) + defaults)

    operator fun invoke(
        hidden: Boolean? = null,
        id: String? = null,
        contentEditable: String? = null,
        dir: String? = null,
        tabIndex: Int? = null,
        draggable: Boolean? = null,
        lang: String? = null,
        spellCheck: Boolean? = null,
        accessKey: String? = null,
        title: String? = null,
        translate: String? = null,
        dropZone: String? = null,
        onBlur: ((event: Event) -> Unit)? = null,
        onChange: ((event: Event) -> Unit)? = null,
        onContextMenu: ((event: Event) -> Unit)? = null,
        onFocus: ((event: Event) -> Unit)? = null,
        onInput: ((event: Event) -> Unit)? = null,
        onInvalid: ((event: Event) -> Unit)? = null,
        onReset: ((event: Event) -> Unit)? = null,
        onSearch: ((event: Event) -> Unit)? = null,
        onSelect: ((event: Event) -> Unit)? = null,
        onSubmit: ((event: Event) -> Unit)? = null,
        onScroll: ((event: Event) -> Unit)? = null,
        onToggle: ((event: Event) -> Unit)? = null,
        onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
        onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
        onMouseDown: ((event: MouseEvent) -> Unit)? = null,
        onMouseMove: ((event: MouseEvent) -> Unit)? = null,
        onMouseOut: ((event: MouseEvent) -> Unit)? = null,
        onMouseOver: ((event: MouseEvent) -> Unit)? = null,
        onMouseUp: ((event: MouseEvent) -> Unit)? = null,
        onClick: ((event: MouseEvent) -> Unit)? = null,
        onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
        onWheel: ((event: WheelEvent) -> Unit)? = null,
        onDrag: ((event: DragEvent) -> Unit)? = null,
        onDragEnd: ((event: DragEvent) -> Unit)? = null,
        onDragEnter: ((event: DragEvent) -> Unit)? = null,
        onDragLeave: ((event: DragEvent) -> Unit)? = null,
        onDragOver: ((event: DragEvent) -> Unit)? = null,
        onDragStart: ((event: DragEvent) -> Unit)? = null,
        onDrop: ((event: DragEvent) -> Unit)? = null,
        onCopy: ((event: ClipboardEvent) -> Unit)? = null,
        onCut: ((event: ClipboardEvent) -> Unit)? = null,
        onPaste: ((event: ClipboardEvent) -> Unit)? = null,
        className: CharSequence? = null,
        style: List<AbstractStyleProperty?>? = null,
        css: List<CssElement?>? = null,
        children: Iterable<ReactElement<*>?>? = null,
        child: ReactElement<*>? = null,
        text: String? = null,
        innerHtml: String? = null,
        key: Any? = null,
        ref: MutableRefObject<out HTMLElement?>? = null
    ) = html(
        tag = "wbr",
        attributes = attributes(
            defaults = defaults,
            hidden = hidden,
            id = id,
            contentEditable = contentEditable,
            dir = dir,
            tabIndex = tabIndex,
            draggable = draggable,
            lang = lang,
            spellCheck = spellCheck,
            accessKey = accessKey,
            title = title,
            translate = translate,
            dropZone = dropZone,
            className = className
        ),
        listeners = listeners(
            onBlur,
            onChange,
            onContextMenu,
            onFocus,
            onInput,
            onInvalid,
            onReset,
            onSearch,
            onSelect,
            onSubmit,
            onScroll,
            onToggle,
            onKeyDown,
            onKeyPress,
            onKeyUp,
            onMouseDown,
            onMouseMove,
            onMouseOut,
            onMouseOver,
            onMouseUp,
            onClick,
            onDoubleClick,
            onWheel,
            onDrag,
            onDragEnd,
            onDragEnter,
            onDragLeave,
            onDragOver,
            onDragStart,
            onDrop,
            onCopy,
            onCut,
            onPaste
        ),
        style = style,
        css = css,
        children = concatChildren(children, child, text),
        innerHtml = innerHtml,
        key = key,
        ref = ref
    )

    operator fun invoke(vararg children: ReactElement<*>) = html(
        tag = "wbr",
        attributes = defaults ?: emptyMap(),
        children = children.asList()
    )
}

private inline fun attributes(
    defaults: Map<out String, Any>? = null,
    data: String? = null,
    useMap: String? = null,
    multiple: String? = null,
    content: String? = null,
    rowSpan: Int? = null,
    form: String? = null,
    accept: String? = null,
    formTarget: String? = null,
    autoFocus: Boolean? = null,
    shape: String? = null,
    size: String? = null,
    value: String? = null,
    list: String? = null,
    formEncType: String? = null,
    title: String? = null,
    headers: String? = null,
    acceptCharset: String? = null,
    method: String? = null,
    srcDoc: String? = null,
    hidden: Boolean? = null,
    `for`: String? = null,
    defer: String? = null,
    srcLang: String? = null,
    type: String? = null,
    target: String? = null,
    kind: String? = null,
    charset: String? = null,
    required: Boolean? = null,
    sandbox: String? = null,
    poster: String? = null,
    formNoValidate: Boolean? = null,
    noValidate: Boolean? = null,
    autoPlay: String? = null,
    colSpan: Int? = null,
    default: String? = null,
    min: String? = null,
    alt: String? = null,
    step: Double? = null,
    coords: String? = null,
    label: String? = null,
    id: String? = null,
    async: String? = null,
    reversed: String? = null,
    height: Int? = null,
    muted: Boolean? = null,
    rows: Int? = null,
    dirname: String? = null,
    selected: Boolean? = null,
    placeholder: String? = null,
    sizes: String? = null,
    low: String? = null,
    autocomplete: Boolean? = null,
    dropZone: String? = null,
    open: String? = null,
    isMap: String? = null,
    datetime: String? = null,
    abbr: String? = null,
    cite: String? = null,
    download: String? = null,
    width: Int? = null,
    xmlns: String? = null,
    span: Int? = null,
    name: String? = null,
    readonly: Boolean? = null,
    scope: String? = null,
    translate: String? = null,
    contentEditable: String? = null,
    pattern: String? = null,
    href: String? = null,
    rel: String? = null,
    tabIndex: Int? = null,
    accessKey: String? = null,
    formMethod: String? = null,
    cols: Int? = null,
    start: String? = null,
    loop: String? = null,
    optimum: String? = null,
    srcSet: String? = null,
    src: String? = null,
    high: String? = null,
    media: String? = null,
    disabled: Boolean? = null,
    spellCheck: Boolean? = null,
    checked: Boolean? = null,
    hrefLang: String? = null,
    draggable: Boolean? = null,
    encType: String? = null,
    preload: String? = null,
    ping: String? = null,
    formAction: String? = null,
    longDesc: String? = null,
    wrap: String? = null,
    lang: String? = null,
    dir: String? = null,
    maxLength: Int? = null,
    max: String? = null,
    controls: String? = null,
    httpEquiv: String? = null,
    action: String? = null,
    d: String? = null,
    className: CharSequence? = null
): HashMap<String, Any> {
    val result = if (defaults != null) HashMap(defaults) else HashMap()
    if (data != null) result["data"] = data
    if (useMap != null) result["useMap"] = useMap
    if (multiple != null) result["multiple"] = multiple
    if (content != null) result["content"] = content
    if (rowSpan != null) result["rowSpan"] = rowSpan
    if (form != null) result["form"] = form
    if (accept != null) result["accept"] = accept
    if (formTarget != null) result["formTarget"] = formTarget
    if (autoFocus != null) result["autoFocus"] = autoFocus
    if (shape != null) result["shape"] = shape
    if (size != null) result["size"] = size
    if (value != null) result["value"] = value
    if (list != null) result["list"] = list
    if (formEncType != null) result["formEncType"] = formEncType
    if (title != null) result["title"] = title
    if (headers != null) result["headers"] = headers
    if (acceptCharset != null) result["acceptCharset"] = acceptCharset
    if (method != null) result["method"] = method
    if (srcDoc != null) result["srcDoc"] = srcDoc
    if (hidden != null) result["hidden"] = hidden
    if (`for` != null) result["htmlFor"] = `for`
    if (defer != null) result["defer"] = defer
    if (srcLang != null) result["srcLang"] = srcLang
    if (type != null) result["type"] = type
    if (target != null) result["target"] = target
    if (kind != null) result["kind"] = kind
    if (charset != null) result["charset"] = charset
    if (required != null) result["required"] = required
    if (sandbox != null) result["sandbox"] = sandbox
    if (poster != null) result["poster"] = poster
    if (formNoValidate != null) result["formNoValidate"] = formNoValidate
    if (noValidate != null) result["novalidate"] = noValidate
    if (autoPlay != null) result["autoPlay"] = autoPlay
    if (colSpan != null) result["colSpan"] = colSpan
    if (default != null) result["default"] = default
    if (min != null) result["min"] = min
    if (alt != null) result["alt"] = alt
    if (step != null) result["step"] = step
    if (coords != null) result["coords"] = coords
    if (label != null) result["label"] = label
    if (id != null) result["id"] = id
    if (async != null) result["async"] = async
    if (reversed != null) result["reversed"] = reversed
    if (height != null) result["height"] = height
    if (muted != null) result["muted"] = muted
    if (rows != null) result["rows"] = rows
    if (dirname != null) result["dirname"] = dirname
    if (selected != null) result["selected"] = selected
    if (placeholder != null) result["placeholder"] = placeholder
    if (sizes != null) result["sizes"] = sizes
    if (low != null) result["low"] = low
    if (autocomplete != null) result["autocomplete"] = autocomplete
    if (dropZone != null) result["dropZone"] = dropZone
    if (open != null) result["open"] = open
    if (isMap != null) result["isMap"] = isMap
    if (datetime != null) result["datetime"] = datetime
    if (abbr != null) result["abbr"] = abbr
    if (cite != null) result["cite"] = cite
    if (download != null) result["download"] = download
    if (width != null) result["width"] = width
    if (xmlns != null) result["xmlns"] = xmlns
    if (span != null) result["span"] = span
    if (name != null) result["name"] = name
    if (readonly != null) result["readonly"] = readonly
    if (scope != null) result["scope"] = scope
    if (translate != null) result["translate"] = translate
    if (contentEditable != null) result["contentEditable"] = contentEditable
    if (pattern != null) result["pattern"] = pattern
    if (href != null) result["href"] = href
    if (rel != null) result["rel"] = rel
    if (tabIndex != null) result["tabIndex"] = tabIndex
    if (accessKey != null) result["accessKey"] = accessKey
    if (formMethod != null) result["formMethod"] = formMethod
    if (cols != null) result["cols"] = cols
    if (start != null) result["start"] = start
    if (loop != null) result["loop"] = loop
    if (optimum != null) result["optimum"] = optimum
    if (srcSet != null) result["srcSet"] = srcSet
    if (src != null) result["src"] = src
    if (high != null) result["high"] = high
    if (media != null) result["media"] = media
    if (disabled != null) result["disabled"] = disabled
    if (spellCheck != null) result["spellCheck"] = spellCheck
    if (checked != null) result["checked"] = checked
    if (hrefLang != null) result["hrefLang"] = hrefLang
    if (draggable != null) result["draggable"] = draggable
    if (encType != null) result["encType"] = encType
    if (preload != null) result["preload"] = preload
    if (ping != null) result["ping"] = ping
    if (formAction != null) result["formAction"] = formAction
    if (longDesc != null) result["longDesc"] = longDesc
    if (wrap != null) result["wrap"] = wrap
    if (lang != null) result["lang"] = lang
    if (dir != null) result["dir"] = dir
    if (maxLength != null) result["maxLength"] = maxLength
    if (max != null) result["max"] = max
    if (controls != null) result["controls"] = controls
    if (httpEquiv != null) result["httpEquiv"] = httpEquiv
    if (action != null) result["action"] = action
    if (d != null) result["d"] = d
    if (className != null) result["className"] = className.toString()
    return result
}

// todo svg elements
