@file:Suppress("NOTHING_TO_INLINE", "FunctionName", "unused")

package io.akryl.dom.html

import io.akryl.dom.css.AbstractStyleProperty
import io.akryl.dom.css.CssElement
import org.w3c.dom.*
import org.w3c.dom.clipboard.ClipboardEvent
import org.w3c.dom.events.Event
import org.w3c.dom.events.KeyboardEvent
import org.w3c.dom.events.MouseEvent
import org.w3c.dom.events.WheelEvent
import org.w3c.dom.svg.SVGElement
import org.w3c.dom.svg.SVGPathElement
import react.MutableRefObject
import react.ReactElement

@Suppress("UNCHECKED_CAST")
private inline fun listeners(
  noinline onBlur: ((event: Event) -> Unit)? = null,
  noinline onChange: ((event: Event) -> Unit)? = null,
  noinline onContextMenu: ((event: Event) -> Unit)? = null,
  noinline onFocus: ((event: Event) -> Unit)? = null,
  noinline onInput: ((event: Event) -> Unit)? = null,
  noinline onInvalid: ((event: Event) -> Unit)? = null,
  noinline onReset: ((event: Event) -> Unit)? = null,
  noinline onSearch: ((event: Event) -> Unit)? = null,
  noinline onSelect: ((event: Event) -> Unit)? = null,
  noinline onSubmit: ((event: Event) -> Unit)? = null,
  noinline onScroll: ((event: Event) -> Unit)? = null,
  noinline onToggle: ((event: Event) -> Unit)? = null,
  noinline onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  noinline onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  noinline onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  noinline onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  noinline onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  noinline onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  noinline onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  noinline onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  noinline onClick: ((event: MouseEvent) -> Unit)? = null,
  noinline onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  noinline onWheel: ((event: WheelEvent) -> Unit)? = null,
  noinline onDrag: ((event: DragEvent) -> Unit)? = null,
  noinline onDragEnd: ((event: DragEvent) -> Unit)? = null,
  noinline onDragEnter: ((event: DragEvent) -> Unit)? = null,
  noinline onDragLeave: ((event: DragEvent) -> Unit)? = null,
  noinline onDragOver: ((event: DragEvent) -> Unit)? = null,
  noinline onDragStart: ((event: DragEvent) -> Unit)? = null,
  noinline onDrop: ((event: DragEvent) -> Unit)? = null,
  noinline onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  noinline onCut: ((event: ClipboardEvent) -> Unit)? = null,
  noinline onPaste: ((event: ClipboardEvent) -> Unit)? = null
): HashMap<String, (Event) -> Unit> {
  val result = HashMap<String, (Event) -> Unit>()
  if (onBlur != null) result["onBlur"] = onBlur
  if (onChange != null) result["onChange"] = onChange
  if (onContextMenu != null) result["onContextMenu"] = onContextMenu
  if (onFocus != null) result["onFocus"] = onFocus
  if (onInput != null) result["onInput"] = onInput
  if (onInvalid != null) result["onInvalid"] = onInvalid
  if (onReset != null) result["onReset"] = onReset
  if (onSearch != null) result["onSearch"] = onSearch
  if (onSelect != null) result["onSelect"] = onSelect
  if (onSubmit != null) result["onSubmit"] = onSubmit
  if (onScroll != null) result["onScroll"] = onScroll
  if (onToggle != null) result["onToggle"] = onToggle
  if (onKeyDown != null) result["onKeyDown"] = onKeyDown as (Event) -> Unit
  if (onKeyPress != null) result["onKeyPress"] = onKeyPress as (Event) -> Unit
  if (onKeyUp != null) result["onKeyUp"] = onKeyUp as (Event) -> Unit
  if (onMouseDown != null) result["onMouseDown"] = onMouseDown as (Event) -> Unit
  if (onMouseMove != null) result["onMouseMove"] = onMouseMove as (Event) -> Unit
  if (onMouseOut != null) result["onMouseOut"] = onMouseOut as (Event) -> Unit
  if (onMouseOver != null) result["onMouseOver"] = onMouseOver as (Event) -> Unit
  if (onMouseUp != null) result["onMouseUp"] = onMouseUp as (Event) -> Unit
  if (onClick != null) result["onClick"] = onClick as (Event) -> Unit
  if (onDoubleClick != null) result["onDoubleClick"] = onDoubleClick as (Event) -> Unit
  if (onWheel != null) result["onWheel"] = onWheel as (Event) -> Unit
  if (onDrag != null) result["onDrag"] = onDrag as (Event) -> Unit
  if (onDragEnd != null) result["onDragEnd"] = onDragEnd as (Event) -> Unit
  if (onDragEnter != null) result["onDragEnter"] = onDragEnter as (Event) -> Unit
  if (onDragLeave != null) result["onDragLeave"] = onDragLeave as (Event) -> Unit
  if (onDragOver != null) result["onDragOver"] = onDragOver as (Event) -> Unit
  if (onDragStart != null) result["onDragStart"] = onDragStart as (Event) -> Unit
  if (onDrop != null) result["onDrop"] = onDrop as (Event) -> Unit
  if (onCopy != null) result["onCopy"] = onCopy as (Event) -> Unit
  if (onCut != null) result["onCut"] = onCut as (Event) -> Unit
  if (onPaste != null) result["onPaste"] = onPaste as (Event) -> Unit
  return result
}

fun A(
  target: String? = null,
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  href: String? = null,
  rel: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  media: String? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  ping: String? = null,
  accessKey: String? = null,
  title: String? = null,
  download: String? = null,
  hrefLang: String? = null,
  translate: String? = null,
  type: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null
) = html(
  tag = "a",
  attributes = attributes(
    target = target,
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    href = href,
    rel = rel,
    dir = dir,
    tabIndex = tabIndex,
    media = media,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    ping = ping,
    accessKey = accessKey,
    title = title,
    download = download,
    hrefLang = hrefLang,
    translate = translate,
    type = type,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun A(vararg children: ReactElement<*>) = html(
  tag = "a",
  children = children.asList()
)

fun Abbr(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "abbr",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Abbr(vararg children: ReactElement<*>) = html(
  tag = "abbr",
  children = children.asList()
)

fun Address(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "address",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Address(vararg children: ReactElement<*>) = html(
  tag = "address",
  children = children.asList()
)

fun Area(
  alt: String? = null,
  hrefLang: String? = null,
  download: String? = null,
  coords: String? = null,
  draggable: Boolean? = null,
  shape: String? = null,
  id: String? = null,
  title: String? = null,
  translate: String? = null,
  lang: String? = null,
  hidden: Boolean? = null,
  contentEditable: String? = null,
  href: String? = null,
  rel: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  accessKey: String? = null,
  type: String? = null,
  target: String? = null,
  media: String? = null,
  spellCheck: Boolean? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLAreaElement?>? = null) = html(
  tag = "area",
  attributes = attributes(
    alt = alt,
    hrefLang = hrefLang,
    download = download,
    coords = coords,
    draggable = draggable,
    shape = shape,
    id = id,
    title = title,
    translate = translate,
    lang = lang,
    hidden = hidden,
    contentEditable = contentEditable,
    href = href,
    rel = rel,
    dir = dir,
    tabIndex = tabIndex,
    accessKey = accessKey,
    type = type,
    target = target,
    media = media,
    spellCheck = spellCheck,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Area(vararg children: ReactElement<*>) = html(
  tag = "area",
  children = children.asList()
)

fun Article(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "article",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Article(vararg children: ReactElement<*>) = html(
  tag = "article",
  children = children.asList()
)

fun Aside(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "aside",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Aside(vararg children: ReactElement<*>) = html(
  tag = "aside",
  children = children.asList()
)

fun Audio(
  hidden: Boolean? = null,
  id: String? = null,
  muted: Boolean? = null,
  src: String? = null,
  contentEditable: String? = null,
  autoPlay: String? = null,
  preload: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  controls: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  loop: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLAudioElement?>? = null) = html(
  tag = "audio",
  attributes = attributes(
    hidden = hidden,
    id = id,
    muted = muted,
    src = src,
    contentEditable = contentEditable,
    autoPlay = autoPlay,
    preload = preload,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    controls = controls,
    translate = translate,
    dropZone = dropZone,
    loop = loop,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Audio(vararg children: ReactElement<*>) = html(
  tag = "audio",
  children = children.asList()
)

fun B(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "b",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun B(vararg children: ReactElement<*>) = html(
  tag = "b",
  children = children.asList()
)

fun Base(
  target: String? = null,
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  href: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLBaseElement?>? = null) = html(
  tag = "base",
  attributes = attributes(
    target = target,
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    href = href,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Base(vararg children: ReactElement<*>) = html(
  tag = "base",
  children = children.asList()
)

fun Bdi(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "bdi",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Bdi(vararg children: ReactElement<*>) = html(
  tag = "bdi",
  children = children.asList()
)

fun Bdo(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "bdo",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Bdo(vararg children: ReactElement<*>) = html(
  tag = "bdo",
  children = children.asList()
)

fun Blockquote(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  cite: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "blockquote",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    cite = cite,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Blockquote(vararg children: ReactElement<*>) = html(
  tag = "blockquote",
  children = children.asList()
)

fun Body(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLBodyElement?>? = null) = html(
  tag = "body",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Body(vararg children: ReactElement<*>) = html(
  tag = "body",
  children = children.asList()
)

fun Br(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLBRElement?>? = null) = html(
  tag = "br",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Br(vararg children: ReactElement<*>) = html(
  tag = "br",
  children = children.asList()
)

fun Button(
  formNoValidate: Boolean? = null,
  form: String? = null,
  formTarget: String? = null,
  autoFocus: Boolean? = null,
  draggable: Boolean? = null,
  name: String? = null,
  id: String? = null,
  value: String? = null,
  formEncType: String? = null,
  formAction: String? = null,
  title: String? = null,
  translate: String? = null,
  lang: String? = null,
  hidden: Boolean? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  accessKey: String? = null,
  formMethod: String? = null,
  type: String? = null,
  disabled: Boolean? = null,
  spellCheck: Boolean? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLButtonElement?>? = null) = html(
  tag = "button",
  attributes = attributes(
    formNoValidate = formNoValidate,
    form = form,
    formTarget = formTarget,
    autoFocus = autoFocus,
    draggable = draggable,
    name = name,
    id = id,
    value = value,
    formEncType = formEncType,
    formAction = formAction,
    title = title,
    translate = translate,
    lang = lang,
    hidden = hidden,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    accessKey = accessKey,
    formMethod = formMethod,
    type = type,
    disabled = disabled,
    spellCheck = spellCheck,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Button(vararg children: ReactElement<*>) = html(
  tag = "button",
  children = children.asList()
)

fun Canvas(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  height: Int? = null,
  width: Int? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLCanvasElement?>? = null) = html(
  tag = "canvas",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    height = height,
    width = width,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Canvas(vararg children: ReactElement<*>) = html(
  tag = "canvas",
  children = children.asList()
)

fun Caption(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLTableCaptionElement?>? = null) = html(
  tag = "caption",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Caption(vararg children: ReactElement<*>) = html(
  tag = "caption",
  children = children.asList()
)

fun Cite(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "cite",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Cite(vararg children: ReactElement<*>) = html(
  tag = "cite",
  children = children.asList()
)

fun Code(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "code",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Code(vararg children: ReactElement<*>) = html(
  tag = "code",
  children = children.asList()
)

fun Col(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  span: Int? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLTableColElement?>? = null) = html(
  tag = "col",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    span = span,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Col(vararg children: ReactElement<*>) = html(
  tag = "col",
  children = children.asList()
)

fun Colgroup(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  span: Int? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLTableColElement?>? = null) = html(
  tag = "colgroup",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    span = span,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Colgroup(vararg children: ReactElement<*>) = html(
  tag = "colgroup",
  children = children.asList()
)

fun Data(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLDataElement?>? = null) = html(
  tag = "data",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Data(vararg children: ReactElement<*>) = html(
  tag = "data",
  children = children.asList()
)

fun Datalist(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLDataListElement?>? = null) = html(
  tag = "datalist",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Datalist(vararg children: ReactElement<*>) = html(
  tag = "datalist",
  children = children.asList()
)

fun Dd(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "dd",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Dd(vararg children: ReactElement<*>) = html(
  tag = "dd",
  children = children.asList()
)

fun Del(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  datetime: String? = null,
  accessKey: String? = null,
  title: String? = null,
  cite: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "del",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    datetime = datetime,
    accessKey = accessKey,
    title = title,
    cite = cite,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Del(vararg children: ReactElement<*>) = html(
  tag = "del",
  children = children.asList()
)

fun Details(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  open: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLDetailsElement?>? = null) = html(
  tag = "details",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    open = open,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Details(vararg children: ReactElement<*>) = html(
  tag = "details",
  children = children.asList()
)

fun Dfn(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "dfn",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Dfn(vararg children: ReactElement<*>) = html(
  tag = "dfn",
  children = children.asList()
)

fun Dialog(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  open: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLDialogElement?>? = null) = html(
  tag = "dialog",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    open = open,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Dialog(vararg children: ReactElement<*>) = html(
  tag = "dialog",
  children = children.asList()
)

fun Div(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLDivElement?>? = null) = html(
  tag = "div",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Div(vararg children: ReactElement<*>) = html(
  tag = "div",
  children = children.asList()
)

fun Dl(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLDListElement?>? = null) = html(
  tag = "dl",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Dl(vararg children: ReactElement<*>) = html(
  tag = "dl",
  children = children.asList()
)

fun Dt(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "dt",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Dt(vararg children: ReactElement<*>) = html(
  tag = "dt",
  children = children.asList()
)

fun Em(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "em",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Em(vararg children: ReactElement<*>) = html(
  tag = "em",
  children = children.asList()
)

fun Embed(
  hidden: Boolean? = null,
  id: String? = null,
  src: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  height: Int? = null,
  width: Int? = null,
  translate: String? = null,
  type: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLEmbedElement?>? = null) = html(
  tag = "embed",
  attributes = attributes(
    hidden = hidden,
    id = id,
    src = src,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    height = height,
    width = width,
    translate = translate,
    type = type,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Embed(vararg children: ReactElement<*>) = html(
  tag = "embed",
  children = children.asList()
)

fun Fieldset(
  hidden: Boolean? = null,
  id: String? = null,
  name: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  disabled: Boolean? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  form: String? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLFieldSetElement?>? = null) = html(
  tag = "fieldset",
  attributes = attributes(
    hidden = hidden,
    id = id,
    name = name,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    disabled = disabled,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    form = form,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Fieldset(vararg children: ReactElement<*>) = html(
  tag = "fieldset",
  children = children.asList()
)

fun Figcaption(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "figcaption",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Figcaption(vararg children: ReactElement<*>) = html(
  tag = "figcaption",
  children = children.asList()
)

fun Figure(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "figure",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Figure(vararg children: ReactElement<*>) = html(
  tag = "figure",
  children = children.asList()
)

fun Footer(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "footer",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Footer(vararg children: ReactElement<*>) = html(
  tag = "footer",
  children = children.asList()
)

fun Form(
  target: String? = null,
  hidden: Boolean? = null,
  id: String? = null,
  name: String? = null,
  contentEditable: String? = null,
  encType: String? = null,
  noValidate: Boolean? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  action: String? = null,
  autocomplete: Boolean? = null,
  acceptCharset: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  method: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLFormElement?>? = null) = html(
  tag = "form",
  attributes = attributes(
    target = target,
    hidden = hidden,
    id = id,
    name = name,
    contentEditable = contentEditable,
    encType = encType,
    noValidate = noValidate,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    action = action,
    autocomplete = autocomplete,
    acceptCharset = acceptCharset,
    translate = translate,
    dropZone = dropZone,
    method = method,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Form(vararg children: ReactElement<*>) = html(
  tag = "form",
  children = children.asList()
)

fun H1(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLHeadingElement?>? = null) = html(
  tag = "h1",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun H1(vararg children: ReactElement<*>) = html(
  tag = "h1",
  children = children.asList()
)

fun H2(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLHeadingElement?>? = null) = html(
  tag = "h2",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun H2(vararg children: ReactElement<*>) = html(
  tag = "h2",
  children = children.asList()
)

fun H3(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLHeadingElement?>? = null) = html(
  tag = "h3",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun H3(vararg children: ReactElement<*>) = html(
  tag = "h3",
  children = children.asList()
)

fun H4(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLHeadingElement?>? = null) = html(
  tag = "h4",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun H4(vararg children: ReactElement<*>) = html(
  tag = "h4",
  children = children.asList()
)

fun H5(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLHeadingElement?>? = null) = html(
  tag = "h5",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun H5(vararg children: ReactElement<*>) = html(
  tag = "h5",
  children = children.asList()
)

fun H6(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLHeadingElement?>? = null) = html(
  tag = "h6",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun H6(vararg children: ReactElement<*>) = html(
  tag = "h6",
  children = children.asList()
)

fun Head(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLHeadElement?>? = null) = html(
  tag = "head",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Head(vararg children: ReactElement<*>) = html(
  tag = "head",
  children = children.asList()
)

fun Header(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "header",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Header(vararg children: ReactElement<*>) = html(
  tag = "header",
  children = children.asList()
)

fun Hr(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "hr",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Hr(vararg children: ReactElement<*>) = html(
  tag = "hr",
  children = children.asList()
)

fun Html(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  xmlns: String? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "html",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    xmlns = xmlns,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Html(vararg children: ReactElement<*>) = html(
  tag = "html",
  children = children.asList()
)

fun I(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "i",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun I(vararg children: ReactElement<*>) = html(
  tag = "i",
  children = children.asList()
)

fun Iframe(
  hidden: Boolean? = null,
  id: String? = null,
  name: String? = null,
  src: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  height: Int? = null,
  width: Int? = null,
  translate: String? = null,
  sandbox: String? = null,
  dropZone: String? = null,
  srcDoc: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLIFrameElement?>? = null) = html(
  tag = "iframe",
  attributes = attributes(
    hidden = hidden,
    id = id,
    name = name,
    src = src,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    height = height,
    width = width,
    translate = translate,
    sandbox = sandbox,
    dropZone = dropZone,
    srcDoc = srcDoc,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Iframe(vararg children: ReactElement<*>) = html(
  tag = "iframe",
  children = children.asList()
)

fun Img(
  hidden: Boolean? = null,
  id: String? = null,
  src: String? = null,
  useMap: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  isMap: String? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  alt: String? = null,
  accessKey: String? = null,
  title: String? = null,
  height: Int? = null,
  width: Int? = null,
  longDesc: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLImageElement?>? = null) = html(
  tag = "img",
  attributes = attributes(
    hidden = hidden,
    id = id,
    src = src,
    useMap = useMap,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    isMap = isMap,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    alt = alt,
    accessKey = accessKey,
    title = title,
    height = height,
    width = width,
    longDesc = longDesc,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Img(vararg children: ReactElement<*>) = html(
  tag = "img",
  children = children.asList()
)

fun Input(
  formNoValidate: Boolean? = null,
  multiple: String? = null,
  min: String? = null,
  alt: String? = null,
  accept: String? = null,
  form: String? = null,
  step: Double? = null,
  width: Int? = null,
  formTarget: String? = null,
  autoFocus: Boolean? = null,
  draggable: Boolean? = null,
  name: String? = null,
  id: String? = null,
  size: String? = null,
  readonly: Boolean? = null,
  value: String? = null,
  list: String? = null,
  formEncType: String? = null,
  formAction: String? = null,
  title: String? = null,
  height: Int? = null,
  translate: String? = null,
  lang: String? = null,
  hidden: Boolean? = null,
  contentEditable: String? = null,
  pattern: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  maxLength: Int? = null,
  max: String? = null,
  accessKey: String? = null,
  formMethod: String? = null,
  dirname: String? = null,
  type: String? = null,
  src: String? = null,
  placeholder: String? = null,
  disabled: Boolean? = null,
  checked: Boolean? = null,
  spellCheck: Boolean? = null,
  required: Boolean? = null,
  autocomplete: Boolean? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLInputElement?>? = null) = html(
  tag = "input",
  attributes = attributes(
    formNoValidate = formNoValidate,
    multiple = multiple,
    min = min,
    alt = alt,
    accept = accept,
    form = form,
    step = step,
    width = width,
    formTarget = formTarget,
    autoFocus = autoFocus,
    draggable = draggable,
    name = name,
    id = id,
    size = size,
    readonly = readonly,
    value = value,
    list = list,
    formEncType = formEncType,
    formAction = formAction,
    title = title,
    height = height,
    translate = translate,
    lang = lang,
    hidden = hidden,
    contentEditable = contentEditable,
    pattern = pattern,
    dir = dir,
    tabIndex = tabIndex,
    maxLength = maxLength,
    max = max,
    accessKey = accessKey,
    formMethod = formMethod,
    dirname = dirname,
    type = type,
    src = src,
    placeholder = placeholder,
    disabled = disabled,
    checked = checked,
    spellCheck = spellCheck,
    required = required,
    autocomplete = autocomplete,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Input(vararg children: ReactElement<*>) = html(
  tag = "input",
  children = children.asList()
)

fun Ins(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  datetime: String? = null,
  accessKey: String? = null,
  title: String? = null,
  cite: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "ins",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    datetime = datetime,
    accessKey = accessKey,
    title = title,
    cite = cite,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Ins(vararg children: ReactElement<*>) = html(
  tag = "ins",
  children = children.asList()
)

fun Kbd(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "kbd",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Kbd(vararg children: ReactElement<*>) = html(
  tag = "kbd",
  children = children.asList()
)

fun Label(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  `for`: String? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  form: String? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLLabelElement?>? = null) = html(
  tag = "label",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    `for` = `for`,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    form = form,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Label(vararg children: ReactElement<*>) = html(
  tag = "label",
  children = children.asList()
)

fun Legend(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLLegendElement?>? = null) = html(
  tag = "legend",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Legend(vararg children: ReactElement<*>) = html(
  tag = "legend",
  children = children.asList()
)

fun Li(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  value: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "li",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    value = value,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Li(vararg children: ReactElement<*>) = html(
  tag = "li",
  children = children.asList()
)

fun Link(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  href: String? = null,
  rel: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  media: String? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  sizes: String? = null,
  accessKey: String? = null,
  title: String? = null,
  hrefLang: String? = null,
  translate: String? = null,
  type: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLLinkElement?>? = null) = html(
  tag = "link",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    href = href,
    rel = rel,
    dir = dir,
    tabIndex = tabIndex,
    media = media,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    sizes = sizes,
    accessKey = accessKey,
    title = title,
    hrefLang = hrefLang,
    translate = translate,
    type = type,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Link(vararg children: ReactElement<*>) = html(
  tag = "link",
  children = children.asList()
)

fun Main(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "main",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Main(vararg children: ReactElement<*>) = html(
  tag = "main",
  children = children.asList()
)

fun Map(
  hidden: Boolean? = null,
  id: String? = null,
  name: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLMapElement?>? = null) = html(
  tag = "map",
  attributes = attributes(
    hidden = hidden,
    id = id,
    name = name,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Map(vararg children: ReactElement<*>) = html(
  tag = "map",
  children = children.asList()
)

fun Mark(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "mark",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Mark(vararg children: ReactElement<*>) = html(
  tag = "mark",
  children = children.asList()
)

fun Meta(
  hidden: Boolean? = null,
  id: String? = null,
  name: String? = null,
  contentEditable: String? = null,
  content: String? = null,
  charset: String? = null,
  httpEquiv: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLMetaElement?>? = null) = html(
  tag = "meta",
  attributes = attributes(
    hidden = hidden,
    id = id,
    name = name,
    contentEditable = contentEditable,
    content = content,
    charset = charset,
    httpEquiv = httpEquiv,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Meta(vararg children: ReactElement<*>) = html(
  tag = "meta",
  children = children.asList()
)

fun Meter(
  hidden: Boolean? = null,
  id: String? = null,
  high: String? = null,
  contentEditable: String? = null,
  value: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  max: String? = null,
  form: String? = null,
  min: String? = null,
  accessKey: String? = null,
  title: String? = null,
  low: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  optimum: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLMeterElement?>? = null) = html(
  tag = "meter",
  attributes = attributes(
    hidden = hidden,
    id = id,
    high = high,
    contentEditable = contentEditable,
    value = value,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    max = max,
    form = form,
    min = min,
    accessKey = accessKey,
    title = title,
    low = low,
    translate = translate,
    dropZone = dropZone,
    optimum = optimum,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Meter(vararg children: ReactElement<*>) = html(
  tag = "meter",
  children = children.asList()
)

fun Nav(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "nav",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Nav(vararg children: ReactElement<*>) = html(
  tag = "nav",
  children = children.asList()
)

fun Noscript(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "noscript",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Noscript(vararg children: ReactElement<*>) = html(
  tag = "noscript",
  children = children.asList()
)

fun Object(
  hidden: Boolean? = null,
  id: String? = null,
  data: String? = null,
  name: String? = null,
  contentEditable: String? = null,
  useMap: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  form: String? = null,
  accessKey: String? = null,
  title: String? = null,
  height: Int? = null,
  width: Int? = null,
  translate: String? = null,
  type: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLObjectElement?>? = null) = html(
  tag = "object",
  attributes = attributes(
    hidden = hidden,
    id = id,
    data = data,
    name = name,
    contentEditable = contentEditable,
    useMap = useMap,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    form = form,
    accessKey = accessKey,
    title = title,
    height = height,
    width = width,
    translate = translate,
    type = type,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Object(vararg children: ReactElement<*>) = html(
  tag = "object",
  children = children.asList()
)

fun Ol(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  reversed: String? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  start: String? = null,
  dropZone: String? = null,
  type: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLOListElement?>? = null) = html(
  tag = "ol",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    reversed = reversed,
    accessKey = accessKey,
    title = title,
    translate = translate,
    start = start,
    dropZone = dropZone,
    type = type,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Ol(vararg children: ReactElement<*>) = html(
  tag = "ol",
  children = children.asList()
)

fun Optgroup(
  hidden: Boolean? = null,
  id: String? = null,
  label: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  disabled: Boolean? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLOptGroupElement?>? = null) = html(
  tag = "optgroup",
  attributes = attributes(
    hidden = hidden,
    id = id,
    label = label,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    disabled = disabled,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Optgroup(vararg children: ReactElement<*>) = html(
  tag = "optgroup",
  children = children.asList()
)

fun Option(
  hidden: Boolean? = null,
  id: String? = null,
  label: String? = null,
  contentEditable: String? = null,
  value: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  disabled: Boolean? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  selected: Boolean? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLOptionElement?>? = null) = html(
  tag = "option",
  attributes = attributes(
    hidden = hidden,
    id = id,
    label = label,
    contentEditable = contentEditable,
    value = value,
    dir = dir,
    tabIndex = tabIndex,
    disabled = disabled,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    selected = selected,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Option(vararg children: ReactElement<*>) = html(
  tag = "option",
  children = children.asList()
)

fun Output(
  hidden: Boolean? = null,
  id: String? = null,
  name: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  `for`: String? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  form: String? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLOutputElement?>? = null) = html(
  tag = "output",
  attributes = attributes(
    hidden = hidden,
    id = id,
    name = name,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    `for` = `for`,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    form = form,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Output(vararg children: ReactElement<*>) = html(
  tag = "output",
  children = children.asList()
)

fun P(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLParagraphElement?>? = null) = html(
  tag = "p",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun P(vararg children: ReactElement<*>) = html(
  tag = "p",
  children = children.asList()
)

fun Param(
  hidden: Boolean? = null,
  id: String? = null,
  name: String? = null,
  contentEditable: String? = null,
  value: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLParamElement?>? = null) = html(
  tag = "param",
  attributes = attributes(
    hidden = hidden,
    id = id,
    name = name,
    contentEditable = contentEditable,
    value = value,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Param(vararg children: ReactElement<*>) = html(
  tag = "param",
  children = children.asList()
)

fun Path(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  d: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out SVGPathElement?>? = null) = html(
  tag = "path",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    d = d,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Picture(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLPictureElement?>? = null) = html(
  tag = "picture",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Picture(vararg children: ReactElement<*>) = html(
  tag = "picture",
  children = children.asList()
)

fun Pre(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLPreElement?>? = null) = html(
  tag = "pre",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Pre(vararg children: ReactElement<*>) = html(
  tag = "pre",
  children = children.asList()
)

fun Progress(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  value: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  max: String? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLProgressElement?>? = null) = html(
  tag = "progress",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    value = value,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    max = max,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Progress(vararg children: ReactElement<*>) = html(
  tag = "progress",
  children = children.asList()
)

fun Q(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  cite: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLQuoteElement?>? = null) = html(
  tag = "q",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    cite = cite,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Q(vararg children: ReactElement<*>) = html(
  tag = "q",
  children = children.asList()
)

fun Rp(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "rp",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Rp(vararg children: ReactElement<*>) = html(
  tag = "rp",
  children = children.asList()
)

fun Rt(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "rt",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Rt(vararg children: ReactElement<*>) = html(
  tag = "rt",
  children = children.asList()
)

fun Ruby(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "ruby",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Ruby(vararg children: ReactElement<*>) = html(
  tag = "ruby",
  children = children.asList()
)

fun S(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "s",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun S(vararg children: ReactElement<*>) = html(
  tag = "s",
  children = children.asList()
)

fun Samp(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "samp",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Samp(vararg children: ReactElement<*>) = html(
  tag = "samp",
  children = children.asList()
)

fun Script(
  hidden: Boolean? = null,
  id: String? = null,
  src: String? = null,
  contentEditable: String? = null,
  charset: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  async: String? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  defer: String? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  type: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLScriptElement?>? = null) = html(
  tag = "script",
  attributes = attributes(
    hidden = hidden,
    id = id,
    src = src,
    contentEditable = contentEditable,
    charset = charset,
    dir = dir,
    tabIndex = tabIndex,
    async = async,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    defer = defer,
    accessKey = accessKey,
    title = title,
    translate = translate,
    type = type,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Script(vararg children: ReactElement<*>) = html(
  tag = "script",
  children = children.asList()
)

fun Section(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "section",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Section(vararg children: ReactElement<*>) = html(
  tag = "section",
  children = children.asList()
)

fun Select(
  hidden: Boolean? = null,
  id: String? = null,
  name: String? = null,
  size: String? = null,
  contentEditable: String? = null,
  multiple: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  disabled: Boolean? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  required: Boolean? = null,
  form: String? = null,
  accessKey: String? = null,
  title: String? = null,
  autoFocus: Boolean? = null,
  translate: String? = null,
  dropZone: String? = null,
  value: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLSelectElement?>? = null) = html(
  tag = "select",
  attributes = attributes(
    hidden = hidden,
    id = id,
    name = name,
    size = size,
    contentEditable = contentEditable,
    multiple = multiple,
    dir = dir,
    tabIndex = tabIndex,
    disabled = disabled,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    required = required,
    form = form,
    accessKey = accessKey,
    title = title,
    autoFocus = autoFocus,
    translate = translate,
    dropZone = dropZone,
    value = value,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Select(vararg children: ReactElement<*>) = html(
  tag = "select",
  children = children.asList()
)

fun Small(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "small",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Small(vararg children: ReactElement<*>) = html(
  tag = "small",
  children = children.asList()
)

fun Source(
  hidden: Boolean? = null,
  id: String? = null,
  src: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  media: String? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  type: String? = null,
  dropZone: String? = null,
  srcSet: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLSourceElement?>? = null) = html(
  tag = "source",
  attributes = attributes(
    hidden = hidden,
    id = id,
    src = src,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    media = media,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    type = type,
    dropZone = dropZone,
    srcSet = srcSet,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Source(vararg children: ReactElement<*>) = html(
  tag = "source",
  children = children.asList()
)

fun Span(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLSpanElement?>? = null) = html(
  tag = "span",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Span(vararg children: ReactElement<*>) = html(
  tag = "span",
  children = children.asList()
)

fun Strong(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "strong",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Strong(vararg children: ReactElement<*>) = html(
  tag = "strong",
  children = children.asList()
)

fun Style(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  media: String? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  type: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLStyleElement?>? = null) = html(
  tag = "style",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    media = media,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    type = type,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Style(vararg children: ReactElement<*>) = html(
  tag = "style",
  children = children.asList()
)

fun Sub(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "sub",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Sub(vararg children: ReactElement<*>) = html(
  tag = "sub",
  children = children.asList()
)

fun Summary(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "summary",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Summary(vararg children: ReactElement<*>) = html(
  tag = "summary",
  children = children.asList()
)

fun Sup(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "sup",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Sup(vararg children: ReactElement<*>) = html(
  tag = "sup",
  children = children.asList()
)

fun Svg(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  width: Int? = null,
  height: Int? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out SVGElement?>? = null) = html(
  tag = "svg",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    width = width,
    height = height,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Svg(vararg children: ReactElement<*>) = html(
  tag = "svg",
  children = children.asList()
)

fun Table(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLTableElement?>? = null) = html(
  tag = "table",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Table(vararg children: ReactElement<*>) = html(
  tag = "table",
  children = children.asList()
)

fun Tbody(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "tbody",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Tbody(vararg children: ReactElement<*>) = html(
  tag = "tbody",
  children = children.asList()
)

fun Td(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  colSpan: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  rowSpan: Int? = null,
  accessKey: String? = null,
  title: String? = null,
  headers: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLTableCellElement?>? = null) = html(
  tag = "td",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    colSpan = colSpan,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    rowSpan = rowSpan,
    accessKey = accessKey,
    title = title,
    headers = headers,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Td(vararg children: ReactElement<*>) = html(
  tag = "td",
  children = children.asList()
)

fun Template(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLTemplateElement?>? = null) = html(
  tag = "template",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Template(vararg children: ReactElement<*>) = html(
  tag = "template",
  children = children.asList()
)

fun Textarea(
  form: String? = null,
  autoFocus: Boolean? = null,
  draggable: Boolean? = null,
  name: String? = null,
  id: String? = null,
  readonly: Boolean? = null,
  title: String? = null,
  wrap: String? = null,
  translate: String? = null,
  lang: String? = null,
  hidden: Boolean? = null,
  contentEditable: String? = null,
  rows: Int? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  maxLength: Int? = null,
  accessKey: String? = null,
  cols: Int? = null,
  dirname: String? = null,
  placeholder: String? = null,
  disabled: Boolean? = null,
  spellCheck: Boolean? = null,
  required: Boolean? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLTextAreaElement?>? = null) = html(
  tag = "textarea",
  attributes = attributes(
    form = form,
    autoFocus = autoFocus,
    draggable = draggable,
    name = name,
    id = id,
    readonly = readonly,
    title = title,
    wrap = wrap,
    translate = translate,
    lang = lang,
    hidden = hidden,
    contentEditable = contentEditable,
    rows = rows,
    dir = dir,
    tabIndex = tabIndex,
    maxLength = maxLength,
    accessKey = accessKey,
    cols = cols,
    dirname = dirname,
    placeholder = placeholder,
    disabled = disabled,
    spellCheck = spellCheck,
    required = required,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Textarea(vararg children: ReactElement<*>) = html(
  tag = "textarea",
  children = children.asList()
)

fun Tfoot(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "tfoot",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Tfoot(vararg children: ReactElement<*>) = html(
  tag = "tfoot",
  children = children.asList()
)

fun Th(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  colSpan: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  rowSpan: Int? = null,
  abbr: String? = null,
  accessKey: String? = null,
  title: String? = null,
  headers: String? = null,
  scope: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLTableCellElement?>? = null) = html(
  tag = "th",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    colSpan = colSpan,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    rowSpan = rowSpan,
    abbr = abbr,
    accessKey = accessKey,
    title = title,
    headers = headers,
    scope = scope,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Th(vararg children: ReactElement<*>) = html(
  tag = "th",
  children = children.asList()
)

fun Thead(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "thead",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Thead(vararg children: ReactElement<*>) = html(
  tag = "thead",
  children = children.asList()
)

fun Time(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  datetime: String? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLTimeElement?>? = null) = html(
  tag = "time",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    datetime = datetime,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Time(vararg children: ReactElement<*>) = html(
  tag = "time",
  children = children.asList()
)

fun Title(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLTitleElement?>? = null) = html(
  tag = "title",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Title(vararg children: ReactElement<*>) = html(
  tag = "title",
  children = children.asList()
)

fun Tr(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLTableRowElement?>? = null) = html(
  tag = "tr",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Tr(vararg children: ReactElement<*>) = html(
  tag = "tr",
  children = children.asList()
)

fun Track(
  kind: String? = null,
  hidden: Boolean? = null,
  id: String? = null,
  label: String? = null,
  src: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  default: String? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  srcLang: String? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLTrackElement?>? = null) = html(
  tag = "track",
  attributes = attributes(
    kind = kind,
    hidden = hidden,
    id = id,
    label = label,
    src = src,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    default = default,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    srcLang = srcLang,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Track(vararg children: ReactElement<*>) = html(
  tag = "track",
  children = children.asList()
)

fun U(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "u",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun U(vararg children: ReactElement<*>) = html(
  tag = "u",
  children = children.asList()
)

fun Ul(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLUListElement?>? = null) = html(
  tag = "ul",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Ul(vararg children: ReactElement<*>) = html(
  tag = "ul",
  children = children.asList()
)

fun Var(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "var",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Var(vararg children: ReactElement<*>) = html(
  tag = "var",
  children = children.asList()
)

fun Video(
  autoPlay: String? = null,
  width: Int? = null,
  draggable: Boolean? = null,
  id: String? = null,
  preload: String? = null,
  title: String? = null,
  height: Int? = null,
  translate: String? = null,
  lang: String? = null,
  hidden: Boolean? = null,
  muted: Boolean? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  accessKey: String? = null,
  controls: String? = null,
  loop: String? = null,
  src: String? = null,
  spellCheck: Boolean? = null,
  dropZone: String? = null,
  poster: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLVideoElement?>? = null) = html(
  tag = "video",
  attributes = attributes(
    autoPlay = autoPlay,
    width = width,
    draggable = draggable,
    id = id,
    preload = preload,
    title = title,
    height = height,
    translate = translate,
    lang = lang,
    hidden = hidden,
    muted = muted,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    accessKey = accessKey,
    controls = controls,
    loop = loop,
    src = src,
    spellCheck = spellCheck,
    dropZone = dropZone,
    poster = poster,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Video(vararg children: ReactElement<*>) = html(
  tag = "video",
  children = children.asList()
)

fun Wbr(
  hidden: Boolean? = null,
  id: String? = null,
  contentEditable: String? = null,
  dir: String? = null,
  tabIndex: Int? = null,
  draggable: Boolean? = null,
  lang: String? = null,
  spellCheck: Boolean? = null,
  accessKey: String? = null,
  title: String? = null,
  translate: String? = null,
  dropZone: String? = null,
  onBlur: ((event: Event) -> Unit)? = null,
  onChange: ((event: Event) -> Unit)? = null,
  onContextMenu: ((event: Event) -> Unit)? = null,
  onFocus: ((event: Event) -> Unit)? = null,
  onInput: ((event: Event) -> Unit)? = null,
  onInvalid: ((event: Event) -> Unit)? = null,
  onReset: ((event: Event) -> Unit)? = null,
  onSearch: ((event: Event) -> Unit)? = null,
  onSelect: ((event: Event) -> Unit)? = null,
  onSubmit: ((event: Event) -> Unit)? = null,
  onScroll: ((event: Event) -> Unit)? = null,
  onToggle: ((event: Event) -> Unit)? = null,
  onKeyDown: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyPress: ((event: KeyboardEvent) -> Unit)? = null,
  onKeyUp: ((event: KeyboardEvent) -> Unit)? = null,
  onMouseDown: ((event: MouseEvent) -> Unit)? = null,
  onMouseMove: ((event: MouseEvent) -> Unit)? = null,
  onMouseOut: ((event: MouseEvent) -> Unit)? = null,
  onMouseOver: ((event: MouseEvent) -> Unit)? = null,
  onMouseUp: ((event: MouseEvent) -> Unit)? = null,
  onClick: ((event: MouseEvent) -> Unit)? = null,
  onDoubleClick: ((event: MouseEvent) -> Unit)? = null,
  onWheel: ((event: WheelEvent) -> Unit)? = null,
  onDrag: ((event: DragEvent) -> Unit)? = null,
  onDragEnd: ((event: DragEvent) -> Unit)? = null,
  onDragEnter: ((event: DragEvent) -> Unit)? = null,
  onDragLeave: ((event: DragEvent) -> Unit)? = null,
  onDragOver: ((event: DragEvent) -> Unit)? = null,
  onDragStart: ((event: DragEvent) -> Unit)? = null,
  onDrop: ((event: DragEvent) -> Unit)? = null,
  onCopy: ((event: ClipboardEvent) -> Unit)? = null,
  onCut: ((event: ClipboardEvent) -> Unit)? = null,
  onPaste: ((event: ClipboardEvent) -> Unit)? = null,
  className: CharSequence? = null,
  style: List<AbstractStyleProperty?>? = null,
  css: List<CssElement?>? = null,
  children: Iterable<ReactElement<*>?>? = null,
  child: ReactElement<*>? = null,
  text: String? = null,
  innerHtml: String? = null,
  key: Any? = null,
  ref: MutableRefObject<out HTMLElement?>? = null) = html(
  tag = "wbr",
  attributes = attributes(
    hidden = hidden,
    id = id,
    contentEditable = contentEditable,
    dir = dir,
    tabIndex = tabIndex,
    draggable = draggable,
    lang = lang,
    spellCheck = spellCheck,
    accessKey = accessKey,
    title = title,
    translate = translate,
    dropZone = dropZone,
    className = className
  ),
  listeners = listeners(
    onBlur,
    onChange,
    onContextMenu,
    onFocus,
    onInput,
    onInvalid,
    onReset,
    onSearch,
    onSelect,
    onSubmit,
    onScroll,
    onToggle,
    onKeyDown,
    onKeyPress,
    onKeyUp,
    onMouseDown,
    onMouseMove,
    onMouseOut,
    onMouseOver,
    onMouseUp,
    onClick,
    onDoubleClick,
    onWheel,
    onDrag,
    onDragEnd,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onDragStart,
    onDrop,
    onCopy,
    onCut,
    onPaste
  ),
  style = style,
  css = css,
  children = concatChildren(children, child, text),
  innerHtml = innerHtml,
  key = key,
  ref = ref
)

fun Wbr(vararg children: ReactElement<*>) = html(
  tag = "wbr",
  children = children.asList()
)

private inline fun attributes(
  data: String? = null,
  useMap: String? = null,
  multiple: String? = null,
  content: String? = null,
  rowSpan: Int? = null,
  form: String? = null,
  accept: String? = null,
  formTarget: String? = null,
  autoFocus: Boolean? = null,
  shape: String? = null,
  size: String? = null,
  value: String? = null,
  list: String? = null,
  formEncType: String? = null,
  title: String? = null,
  headers: String? = null,
  acceptCharset: String? = null,
  method: String? = null,
  srcDoc: String? = null,
  hidden: Boolean? = null,
  `for`: String? = null,
  defer: String? = null,
  srcLang: String? = null,
  type: String? = null,
  target: String? = null,
  kind: String? = null,
  charset: String? = null,
  required: Boolean? = null,
  sandbox: String? = null,
  poster: String? = null,
  formNoValidate: Boolean? = null,
  noValidate: Boolean? = null,
  autoPlay: String? = null,
  colSpan: Int? = null,
  default: String? = null,
  min: String? = null,
  alt: String? = null,
  step: Double? = null,
  coords: String? = null,
  label: String? = null,
  id: String? = null,
  async: String? = null,
  reversed: String? = null,
  height: Int? = null,
  muted: Boolean? = null,
  rows: Int? = null,
  dirname: String? = null,
  selected: Boolean? = null,
  placeholder: String? = null,
  sizes: String? = null,
  low: String? = null,
  autocomplete: Boolean? = null,
  dropZone: String? = null,
  open: String? = null,
  isMap: String? = null,
  datetime: String? = null,
  abbr: String? = null,
  cite: String? = null,
  download: String? = null,
  width: Int? = null,
  xmlns: String? = null,
  span: Int? = null,
  name: String? = null,
  readonly: Boolean? = null,
  scope: String? = null,
  translate: String? = null,
  contentEditable: String? = null,
  pattern: String? = null,
  href: String? = null,
  rel: String? = null,
  tabIndex: Int? = null,
  accessKey: String? = null,
  formMethod: String? = null,
  cols: Int? = null,
  start: String? = null,
  loop: String? = null,
  optimum: String? = null,
  srcSet: String? = null,
  src: String? = null,
  high: String? = null,
  media: String? = null,
  disabled: Boolean? = null,
  spellCheck: Boolean? = null,
  checked: Boolean? = null,
  hrefLang: String? = null,
  draggable: Boolean? = null,
  encType: String? = null,
  preload: String? = null,
  ping: String? = null,
  formAction: String? = null,
  longDesc: String? = null,
  wrap: String? = null,
  lang: String? = null,
  dir: String? = null,
  maxLength: Int? = null,
  max: String? = null,
  controls: String? = null,
  httpEquiv: String? = null,
  action: String? = null,
  d: String? = null,
  className: CharSequence? = null
): HashMap<String, Any> {
  val result = HashMap<String, Any>()
  if (data != null) result["data"] = data
  if (useMap != null) result["useMap"] = useMap
  if (multiple != null) result["multiple"] = multiple
  if (content != null) result["content"] = content
  if (rowSpan != null) result["rowSpan"] = rowSpan
  if (form != null) result["form"] = form
  if (accept != null) result["accept"] = accept
  if (formTarget != null) result["formTarget"] = formTarget
  if (autoFocus != null) result["autoFocus"] = autoFocus
  if (shape != null) result["shape"] = shape
  if (size != null) result["size"] = size
  if (value != null) result["value"] = value
  if (list != null) result["list"] = list
  if (formEncType != null) result["formEncType"] = formEncType
  if (title != null) result["title"] = title
  if (headers != null) result["headers"] = headers
  if (acceptCharset != null) result["acceptCharset"] = acceptCharset
  if (method != null) result["method"] = method
  if (srcDoc != null) result["srcDoc"] = srcDoc
  if (hidden != null) result["hidden"] = hidden
  if (`for` != null) result["htmlFor"] = `for`
  if (defer != null) result["defer"] = defer
  if (srcLang != null) result["srcLang"] = srcLang
  if (type != null) result["type"] = type
  if (target != null) result["target"] = target
  if (kind != null) result["kind"] = kind
  if (charset != null) result["charset"] = charset
  if (required != null) result["required"] = required
  if (sandbox != null) result["sandbox"] = sandbox
  if (poster != null) result["poster"] = poster
  if (formNoValidate != null) result["formNoValidate"] = formNoValidate
  if (noValidate != null) result["novalidate"] = noValidate
  if (autoPlay != null) result["autoPlay"] = autoPlay
  if (colSpan != null) result["colSpan"] = colSpan
  if (default != null) result["default"] = default
  if (min != null) result["min"] = min
  if (alt != null) result["alt"] = alt
  if (step != null) result["step"] = step
  if (coords != null) result["coords"] = coords
  if (label != null) result["label"] = label
  if (id != null) result["id"] = id
  if (async != null) result["async"] = async
  if (reversed != null) result["reversed"] = reversed
  if (height != null) result["height"] = height
  if (muted != null) result["muted"] = muted
  if (rows != null) result["rows"] = rows
  if (dirname != null) result["dirname"] = dirname
  if (selected != null) result["selected"] = selected
  if (placeholder != null) result["placeholder"] = placeholder
  if (sizes != null) result["sizes"] = sizes
  if (low != null) result["low"] = low
  if (autocomplete != null) result["autocomplete"] = autocomplete
  if (dropZone != null) result["dropZone"] = dropZone
  if (open != null) result["open"] = open
  if (isMap != null) result["isMap"] = isMap
  if (datetime != null) result["datetime"] = datetime
  if (abbr != null) result["abbr"] = abbr
  if (cite != null) result["cite"] = cite
  if (download != null) result["download"] = download
  if (width != null) result["width"] = width
  if (xmlns != null) result["xmlns"] = xmlns
  if (span != null) result["span"] = span
  if (name != null) result["name"] = name
  if (readonly != null) result["readonly"] = readonly
  if (scope != null) result["scope"] = scope
  if (translate != null) result["translate"] = translate
  if (contentEditable != null) result["contentEditable"] = contentEditable
  if (pattern != null) result["pattern"] = pattern
  if (href != null) result["href"] = href
  if (rel != null) result["rel"] = rel
  if (tabIndex != null) result["tabIndex"] = tabIndex
  if (accessKey != null) result["accessKey"] = accessKey
  if (formMethod != null) result["formMethod"] = formMethod
  if (cols != null) result["cols"] = cols
  if (start != null) result["start"] = start
  if (loop != null) result["loop"] = loop
  if (optimum != null) result["optimum"] = optimum
  if (srcSet != null) result["srcSet"] = srcSet
  if (src != null) result["src"] = src
  if (high != null) result["high"] = high
  if (media != null) result["media"] = media
  if (disabled != null) result["disabled"] = disabled
  if (spellCheck != null) result["spellCheck"] = spellCheck
  if (checked != null) result["checked"] = checked
  if (hrefLang != null) result["hrefLang"] = hrefLang
  if (draggable != null) result["draggable"] = draggable
  if (encType != null) result["encType"] = encType
  if (preload != null) result["preload"] = preload
  if (ping != null) result["ping"] = ping
  if (formAction != null) result["formAction"] = formAction
  if (longDesc != null) result["longDesc"] = longDesc
  if (wrap != null) result["wrap"] = wrap
  if (lang != null) result["lang"] = lang
  if (dir != null) result["dir"] = dir
  if (maxLength != null) result["maxLength"] = maxLength
  if (max != null) result["max"] = max
  if (controls != null) result["controls"] = controls
  if (httpEquiv != null) result["httpEquiv"] = httpEquiv
  if (action != null) result["action"] = action
  if (d != null) result["d"] = d
  if (className != null) result["className"] = className.toString()
  return result
}

// todo svg elements
