/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.testing.mysql;

import com.google.common.collect.ImmutableSet;
import io.airlift.testing.mysql.TestingMySqlServer;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTestingMySqlServer {
    @Test
    public void testDatabase() throws Exception {
        try (TestingMySqlServer server = new TestingMySqlServer("testuser", "testpass", new String[]{"db1", "db2"});){
            Assert.assertEquals((String)server.getMySqlVersion(), (String)"8.0.12");
            Assert.assertEquals((Set)server.getDatabases(), (Set)ImmutableSet.of((Object)"db1", (Object)"db2"));
            Assert.assertEquals((String)server.getUser(), (String)"testuser");
            Assert.assertEquals((String)server.getPassword(), (String)"testpass");
            Assert.assertEquals((String)server.getJdbcUrl().substring(0, 5), (String)"jdbc:");
            Assert.assertEquals((int)server.getPort(), (int)URI.create(server.getJdbcUrl().substring(5)).getPort());
            try (Connection connection = DriverManager.getConnection(server.getJdbcUrl());){
                Assert.assertEquals((String)connection.getMetaData().getDatabaseProductName(), (String)"MySQL");
            }
            for (String database : server.getDatabases()) {
                Connection connection = DriverManager.getConnection(server.getJdbcUrl(database));
                Throwable throwable = null;
                try {
                    Statement statement = connection.createStatement();
                    Throwable throwable2 = null;
                    try {
                        statement.execute("CREATE TABLE test_table (c1 bigint PRIMARY KEY)");
                        statement.execute("INSERT INTO test_table (c1) VALUES (1)");
                        ResultSet resultSet = statement.executeQuery("SELECT count(*) FROM test_table");
                        Throwable throwable3 = null;
                        try {
                            Assert.assertTrue((boolean)resultSet.next());
                            Assert.assertEquals((long)resultSet.getLong(1), (long)1L);
                            Assert.assertFalse((boolean)resultSet.next());
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (resultSet == null) continue;
                            if (throwable3 != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            resultSet.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable2 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
        }
    }

    @Test
    public void testGlobal() throws Exception {
        try (TestingMySqlServer server = new TestingMySqlServer("testuser", "testpass", new String[0]);
             Connection connection = DriverManager.getConnection(server.getJdbcUrl());){
            Assert.assertEquals((String)connection.getMetaData().getDatabaseProductName(), (String)"MySQL");
            try (Statement statement = connection.createStatement();){
                statement.execute("CREATE DATABASE testdb");
                statement.execute("CREATE TABLE testdb.test_table (id bigint PRIMARY KEY)");
            }
        }
    }
}

