/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.testing.mysql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mysql.management.MysqldResource;
import io.airlift.log.Logger;
import io.airlift.testing.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class TestingMySqlServer
implements Closeable {
    private static final Logger log = Logger.get(TestingMySqlServer.class);
    private final String user;
    private final String password;
    private final Set<String> databases;
    private final int port;
    private final Path mysqlDir;
    private final MysqldResource server;

    public TestingMySqlServer(String user, String password, String ... databases) throws Exception {
        this(user, password, (Iterable<String>)ImmutableList.copyOf((Object[])databases));
    }

    public TestingMySqlServer(String user, String password, Iterable<String> databases) throws Exception {
        this.user = Objects.requireNonNull(user, "user is null");
        this.password = Objects.requireNonNull(password, "password is null");
        this.databases = ImmutableSet.copyOf(Objects.requireNonNull(databases, "databases is null"));
        this.port = TestingMySqlServer.randomPort();
        this.mysqlDir = Files.createTempDirectory("testing-mysql-server", new FileAttribute[0]);
        Path dataDir = this.mysqlDir.resolve("data");
        this.server = new MysqldResource(this.mysqlDir.toFile(), dataDir.toFile());
        ImmutableMap args = ImmutableMap.builder().put((Object)"port", (Object)Integer.toString(this.port)).put((Object)"initialize-user", (Object)"true").put((Object)"initialize-user.user", (Object)user).put((Object)"initialize-user.password", (Object)password).build();
        this.server.start("testing-mysql-server", (Map)args);
        if (!this.server.isRunning()) {
            this.close();
            throw new RuntimeException("MySQL did not start");
        }
        try (Connection connection = TestingMySqlServer.waitForConnection(this.getJdbcUrl());){
            for (String database : databases) {
                Statement statement = connection.createStatement();
                Throwable throwable = null;
                try {
                    TestingMySqlServer.execute(statement, String.format("CREATE DATABASE %s", database));
                    TestingMySqlServer.execute(statement, String.format("GRANT ALL ON %s.* TO '%s'@'%%' IDENTIFIED BY '%s'", database, user, password));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
        log.info("MySQL server ready: %s", new Object[]{this.getJdbcUrl()});
    }

    private static int randomPort() throws IOException {
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(new InetSocketAddress(0));
            int n = socket.getLocalPort();
            return n;
        }
    }

    private static void execute(Statement statement, String sql) throws SQLException {
        log.debug("Executing: %s", new Object[]{sql});
        statement.execute(sql);
    }

    private static Connection waitForConnection(String jdbcUrl) throws InterruptedException {
        while (true) {
            try {
                return DriverManager.getConnection(jdbcUrl);
            }
            catch (SQLException sQLException) {
                log.info("Waiting for MySQL to start at " + jdbcUrl);
                TimeUnit.MILLISECONDS.sleep(10L);
                continue;
            }
            break;
        }
    }

    @Override
    public void close() {
        try {
            this.server.shutdown();
        }
        finally {
            FileUtils.deleteRecursively((File)this.mysqlDir.toFile());
        }
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public boolean isReadyForConnections() {
        return this.server.isReadyForConnections();
    }

    public String getMySqlVersion() {
        return this.server.getVersion();
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<String> getDatabases() {
        return this.databases;
    }

    public int getPort() {
        return this.port;
    }

    public String getJdbcUrl() {
        return String.format("jdbc:mysql://localhost:%d?user=%s&password=%s", this.port, this.user, this.password);
    }

    public String getJdbcUrl(String database) {
        return String.format("jdbc:mysql://localhost:%d/%s?user=%s&password=%s", this.port, database, this.user, this.password);
    }
}

