/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.security.jwks;

import com.google.common.net.MediaType;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Response;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.http.client.testing.TestingResponse;
import io.airlift.security.jwks.JwksService;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJwksService {
    private static final String EMPTY_KEYS = "{ \"keys\": [] }";
    private static final String TEST_JWKS_RESPONSE = "{\n  \"keys\": [\n    {\n      \"e\": \"AQAB\",\n      \"n\": \"mvj-0waJ2owQlFWrlC06goLs9PcNehIzCF0QrkdsYZJXOsipcHCFlXBsgQIdTdLvlCzNI07jSYA-zggycYi96lfDX-FYv_CqC8dRLf9TBOPvUgCyFMCFNUTC69hsrEYMR_J79Wj0MIOffiVr6eX-AaCG3KhBMZMh15KCdn3uVrl9coQivy7bk2Uw-aUJ_b26C0gWYj1DnpO4UEEKBk1X-lpeUMh0B_XorqWeq0NYK2pN6CoEIh0UrzYKlGfdnMU1pJJCsNxMiha-Vw3qqxez6oytOV_AswlWvQc7TkSX6cHfqepNskQb7pGxpgQpy9sA34oIxB_S-O7VS7_h0Qh4vQ\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\",\n      \"kid\": \"test-rsa\"\n    },\n    {\n      \"kty\": \"EC\",\n      \"use\": \"sig\",\n      \"crv\": \"P-256\",\n      \"kid\": \"test-ec\",\n      \"x\": \"W9pnAHwUz81LldKjL3BzxO1iHe1Pc0fO6rHkrybVy6Y\",\n      \"y\": \"XKSNmn_xajgOvWuAiJnWx5I46IwPVJJYPaEpsX3NPZg\",\n      \"alg\": \"ES256\"\n    },\n    {\n      \"alg\": \"RS256\",\n      \"kty\": \"RSA\",\n      \"use\": \"sig\",\n      \"x5c\": [\n           \"MIIC+DCCAeCgAwIBAgIJBIGjYW6hFpn2MA0GCSqGSIb3DQEBBQUAMCMxITAfBgNVBAMTGGN1c3RvbWVyLWRlbW9zLmF1dGgwLmNvbTAeFw0xNjExMjIyMjIyMDVaFw0zMDA4MDEyMjIyMDVaMCMxITAfBgNVBAMTGGN1c3RvbWVyLWRlbW9zLmF1dGgwLmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMnjZc5bm/eGIHq09N9HKHahM7Y31P0ul+A2wwP4lSpIwFrWHzxw88/7Dwk9QMc+orGXX95R6av4GF+Es/nG3uK45ooMVMa/hYCh0Mtx3gnSuoTavQEkLzCvSwTqVwzZ+5noukWVqJuMKNwjL77GNcPLY7Xy2/skMCT5bR8UoWaufooQvYq6SyPcRAU4BtdquZRiBT4U5f+4pwNTxSvey7ki50yc1tG49Per/0zA4O6Tlpv8x7Red6m1bCNHt7+Z5nSl3RX/QYyAEUX1a28VcYmR41Osy+o2OUCXYdUAphDaHo4/8rbKTJhlu8jEcc1KoMXAKjgaVZtG/v5ltx6AXY0CAwEAAaMvMC0wDAYDVR0TBAUwAwEB/zAdBgNVHQ4EFgQUQxFG602h1cG+pnyvJoy9pGJJoCswDQYJKoZIhvcNAQEFBQADggEBAGvtCbzGNBUJPLICth3mLsX0Z4z8T8iu4tyoiuAshP/Ry/ZBnFnXmhD8vwgMZ2lTgUWwlrvlgN+fAtYKnwFO2G3BOCFw96Nm8So9sjTda9CCZ3dhoH57F/hVMBB0K6xhklAc0b5ZxUpCIN92v/w+xZoz1XQBHe8ZbRHaP1HpRM4M7DJk2G5cgUCyu3UBvYS41sHvzrxQ3z7vIePRA4WF4bEkfX12gvny0RsPkrbVMXX1Rj9t6V7QXrbPYBAO+43JvDGYawxYVvLhz+BJ45x50GFQmHszfY3BR9TPK8xmMmQwtIvLu1PMttNCs7niCYkSiUv2sc2mlq1i3IashGkkgmo=\"\n      ],\n      \"n\": \"yeNlzlub94YgerT030codqEztjfU_S6X4DbDA_iVKkjAWtYfPHDzz_sPCT1Axz6isZdf3lHpq_gYX4Sz-cbe4rjmigxUxr-FgKHQy3HeCdK6hNq9ASQvMK9LBOpXDNn7mei6RZWom4wo3CMvvsY1w8tjtfLb-yQwJPltHxShZq5-ihC9irpLI9xEBTgG12q5lGIFPhTl_7inA1PFK97LuSLnTJzW0bj096v_TMDg7pOWm_zHtF53qbVsI0e3v5nmdKXdFf9BjIARRfVrbxVxiZHjU6zL6jY5QJdh1QCmENoejj_ytspMmGW7yMRxzUqgxcAqOBpVm0b-_mW3HoBdjQ\",\n      \"e\": \"AQAB\",\n      \"kid\": \"test-certificate-chain\",\n      \"x5t\": \"NjVBRjY5MDlCMUIwNzU4RTA2QzZFMDQ4QzQ2MDAyQjVDNjk1RTM2Qg\"\n    }\n  ]\n}";

    @Test
    public void testSuccess() {
        TestingHttpClient httpClient = new TestingHttpClient(request -> TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)TEST_JWKS_RESPONSE));
        JwksService service = new JwksService(URI.create("http://example.com"), (HttpClient)httpClient, new Duration(1.0, TimeUnit.DAYS));
        TestJwksService.assertTestKeys(service);
    }

    @Test
    public void testReload() {
        AtomicReference<Response> response = new AtomicReference<Response>(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
        JwksService service = new JwksService(URI.create("http://example.com"), (HttpClient)new TestingHttpClient(request -> (Response)response.get()), new Duration(1.0, TimeUnit.DAYS));
        TestJwksService.assertEmptyKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
        service.refreshKeys();
        TestJwksService.assertEmptyKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)TEST_JWKS_RESPONSE));
        service.refreshKeys();
        TestJwksService.assertTestKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)TEST_JWKS_RESPONSE));
        service.refreshKeys();
        TestJwksService.assertTestKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
        service.refreshKeys();
        TestJwksService.assertEmptyKeys(service);
    }

    @Test
    public void testTimedReload() throws InterruptedException {
        AtomicReference<Supplier<Response>> response = new AtomicReference<Supplier<Response>>(() -> TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
        JwksService service = new JwksService(URI.create("http://example.com"), (HttpClient)new TestingHttpClient(request -> (Response)((Supplier)response.get()).get()), new Duration(1.0, TimeUnit.MILLISECONDS));
        TestJwksService.assertEmptyKeys(service);
        try {
            response.set(() -> TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
            service.start();
            while (!service.getKeys().isEmpty()) {
                Thread.sleep(1000L);
            }
            response.set(() -> TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)TEST_JWKS_RESPONSE));
            while (service.getKeys().isEmpty()) {
                Thread.sleep(1000L);
            }
            TestJwksService.assertTestKeys(service);
        }
        finally {
            service.stop();
        }
    }

    @Test
    public void testRequestFailure() {
        AtomicReference<Response> response = new AtomicReference<Response>(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)TEST_JWKS_RESPONSE));
        JwksService service = new JwksService(URI.create("http://example.com"), (HttpClient)new TestingHttpClient(request -> {
            Response value = (Response)response.get();
            if (value == null) {
                throw new IllegalArgumentException("test");
            }
            return value;
        }), new Duration(1.0, TimeUnit.DAYS));
        TestJwksService.assertTestKeys(service);
        response.set(null);
        Assertions.assertThatThrownBy(() -> ((JwksService)service).refreshKeys()).hasMessage("Error reading JWKS keys from http://example.com").isInstanceOf(RuntimeException.class);
        TestJwksService.assertTestKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
        service.refreshKeys();
        TestJwksService.assertEmptyKeys(service);
    }

    @Test
    public void testBadResponse() {
        AtomicReference<Response> response = new AtomicReference<Response>(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)TEST_JWKS_RESPONSE));
        JwksService service = new JwksService(URI.create("http://example.com"), (HttpClient)new TestingHttpClient(request -> (Response)response.get()), new Duration(1.0, TimeUnit.DAYS));
        TestJwksService.assertTestKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.CREATED, (MediaType)MediaType.JSON_UTF_8, (String)""));
        Assertions.assertThatThrownBy(() -> ((JwksService)service).refreshKeys()).hasMessage("Unexpected response code 201 from JWKS service at http://example.com").isInstanceOf(RuntimeException.class);
        TestJwksService.assertTestKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)""));
        Assertions.assertThatThrownBy(() -> ((JwksService)service).refreshKeys()).hasMessage("Unable to decode JWKS response from http://example.com").isInstanceOf(RuntimeException.class);
        TestJwksService.assertTestKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
        service.refreshKeys();
        TestJwksService.assertEmptyKeys(service);
    }

    private static void assertEmptyKeys(JwksService service) {
        Assert.assertEquals((int)service.getKeys().size(), (int)0);
    }

    private static void assertTestKeys(JwksService service) {
        Map keys = service.getKeys();
        Assert.assertEquals((int)keys.size(), (int)3);
        Assert.assertTrue((boolean)keys.containsKey("test-rsa"));
        Assert.assertTrue((boolean)keys.containsKey("test-ec"));
        Assert.assertTrue((boolean)keys.containsKey("test-certificate-chain"));
    }
}

