/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jodabridge;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.airlift.jodabridge.JdkBasedDateTimeZone;
import java.time.zone.ZoneRulesProvider;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTimeZone;
import org.joda.time.tz.CachedDateTimeZone;
import org.joda.time.tz.Provider;

public class JdkBasedZoneInfoProvider
implements Provider {
    private static final Map<String, DateTimeZone> zones;

    public DateTimeZone getZone(String id) {
        if (id.startsWith("+") || id.startsWith("-")) {
            return null;
        }
        return zones.get(id);
    }

    public Set<String> getAvailableIDs() {
        return ZoneRulesProvider.getAvailableZoneIds();
    }

    public static void registerAsJodaZoneInfoProvider() {
        System.setProperty("org.joda.time.DateTimeZone.Provider", JdkBasedZoneInfoProvider.class.getName());
        if (!(DateTimeZone.getProvider() instanceof JdkBasedZoneInfoProvider)) {
            throw new RuntimeException("This method must be invoked before any use of Joda-Time");
        }
    }

    static {
        ImmutableMap.Builder zonesBuilder = ImmutableMap.builder();
        for (String zoneId : ZoneRulesProvider.getAvailableZoneIds()) {
            DateTimeZone zone;
            if (zoneId.equals("UTC")) {
                zone = DateTimeZone.UTC;
                Verify.verify((boolean)zone.isFixed());
            } else {
                zone = new JdkBasedDateTimeZone(zoneId);
            }
            if (!zone.isFixed()) {
                zone = CachedDateTimeZone.forZone((DateTimeZone)zone);
            }
            zonesBuilder.put((Object)zoneId, (Object)zone);
        }
        zones = zonesBuilder.build();
    }
}

