/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jodabridge;

import io.airlift.jodabridge.JdkBasedZoneInfoProvider;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalInstantException;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJdkBasedZoneInfoProvider {
    @BeforeClass
    protected void validateJodaZoneInfoProvider() {
        try {
            JdkBasedZoneInfoProvider.registerAsJodaZoneInfoProvider();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Set the following system property for JVM running the test: -Dorg.joda.time.DateTimeZone.Provider=io.airlift.jodabridge.JdkBasedZoneInfoProvider");
        }
    }

    @Test
    public void test() {
        DateTime dateTimePST = new DateTime(2018, 1, 1, 2, 30, DateTimeZone.forID((String)"America/Los_Angeles"));
        Assert.assertEquals((String)dateTimePST.toString(), (String)"2018-01-01T02:30:00.000-08:00");
        Assert.assertEquals((String)DateTimeFormat.forPattern((String)"z',' zzzz',' Z',' ZZ',' ZZZ").print((ReadableInstant)dateTimePST), (String)"PST, Pacific Standard Time, -0800, -08:00, America/Los_Angeles");
        Assert.assertEquals((String)dateTimePST.plusMonths(6).toString(), (String)"2018-07-01T02:30:00.000-07:00");
        DateTime dateTimeUTC = new DateTime(2018, 1, 1, 2, 30, DateTimeZone.forID((String)"UTC"));
        Assert.assertEquals((String)dateTimeUTC.toString(), (String)"2018-01-01T02:30:00.000Z");
        Assert.assertEquals((String)DateTimeFormat.forPattern((String)"z',' zzzz',' Z',' ZZ',' ZZZ").print((ReadableInstant)dateTimeUTC), (String)"UTC, Coordinated Universal Time, +0000, +00:00, UTC");
        Assert.assertEquals((String)dateTimeUTC.plusMonths(6).toString(), (String)"2018-07-01T02:30:00.000Z");
        DateTime dateTimeOffset = new DateTime(2018, 1, 1, 2, 30, DateTimeZone.forOffsetHours((int)-8));
        Assert.assertEquals((String)dateTimeOffset.toString(), (String)"2018-01-01T02:30:00.000-08:00");
        Assert.assertEquals((String)DateTimeFormat.forPattern((String)"z',' zzzz',' Z',' ZZ',' ZZZ").print((ReadableInstant)dateTimeOffset), (String)"-08:00, -08:00, -0800, -08:00, -08:00");
        Assert.assertEquals((String)dateTimeOffset.plusMonths(6).toString(), (String)"2018-07-01T02:30:00.000-08:00");
        DateTime dateTimeWeird = new DateTime(2018, 1, 1, 2, 30, DateTimeZone.forID((String)"+07:09"));
        Assert.assertEquals((String)dateTimeWeird.toString(), (String)"2018-01-01T02:30:00.000+07:09");
        Assert.assertEquals((String)DateTimeFormat.forPattern((String)"z',' zzzz',' Z',' ZZ',' ZZZ").print((ReadableInstant)dateTimeWeird), (String)"+07:09, +07:09, +0709, +07:09, +07:09");
        Assert.assertEquals((String)dateTimeWeird.plusMonths(6).toString(), (String)"2018-07-01T02:30:00.000+07:09");
    }

    @Test
    public void testEarlierInstantForLiteralInOverlaps() {
        DateTime dateTimeLosAngeles = new DateTime(2013, 11, 3, 1, 30, DateTimeZone.forID((String)"America/Los_Angeles"));
        Assert.assertEquals((int)dateTimeLosAngeles.minusHours(1).getHourOfDay(), (int)0);
        Assert.assertEquals((int)dateTimeLosAngeles.plusHours(1).getHourOfDay(), (int)1);
        DateTime dateTimeBerlin = new DateTime(2013, 10, 27, 2, 30, DateTimeZone.forID((String)"Europe/Berlin"));
        Assert.assertEquals((int)dateTimeBerlin.minusHours(1).getHourOfDay(), (int)1);
        Assert.assertEquals((int)dateTimeBerlin.plusHours(1).getHourOfDay(), (int)2);
    }

    @Test
    public void testFailureForLiteralInGaps() {
        try {
            new DateTime(2013, 3, 10, 2, 30, DateTimeZone.forID((String)"America/Los_Angeles"));
            Assert.fail((String)"Expect IllegalInstantException");
        }
        catch (IllegalInstantException illegalInstantException) {
            // empty catch block
        }
        try {
            new DateTime(2013, 3, 31, 2, 30, DateTimeZone.forID((String)"Europe/Berlin"));
            Assert.fail((String)"Expect IllegalInstantException");
        }
        catch (IllegalInstantException illegalInstantException) {
            // empty catch block
        }
    }

    @Test
    public void testPrevNextTransition() {
        DateTimeZone zoneLosAngeles = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTimeZone zoneBerlin = DateTimeZone.forID((String)"Europe/Berlin");
        Assert.assertEquals((long)zoneLosAngeles.previousTransition(ZonedDateTime.of(2013, 3, 10, 1, 59, 59, 999000000, ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli()), (long)ZonedDateTime.ofStrict(LocalDateTime.of(2012, 11, 4, 1, 59, 59, 999000000), ZoneOffset.ofHours(-7), ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneLosAngeles.previousTransition(ZonedDateTime.of(2013, 3, 10, 3, 0, 0, 0, ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli()), (long)ZonedDateTime.of(2013, 3, 10, 1, 59, 59, 999000000, ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneLosAngeles.nextTransition(ZonedDateTime.of(2013, 3, 10, 1, 59, 59, 999000000, ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli()), (long)ZonedDateTime.of(2013, 3, 10, 3, 0, 0, 0, ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneLosAngeles.nextTransition(ZonedDateTime.of(2013, 3, 10, 3, 0, 0, 0, ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli()), (long)ZonedDateTime.ofStrict(LocalDateTime.of(2013, 11, 3, 1, 0, 0, 0), ZoneOffset.ofHours(-8), ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneLosAngeles.previousTransition(ZonedDateTime.ofStrict(LocalDateTime.of(2013, 11, 3, 1, 59, 59, 999000000), ZoneOffset.ofHours(-7), ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli()), (long)ZonedDateTime.of(2013, 3, 10, 1, 59, 59, 999000000, ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneLosAngeles.previousTransition(ZonedDateTime.of(2013, 11, 3, 2, 0, 0, 0, ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli()), (long)ZonedDateTime.ofStrict(LocalDateTime.of(2013, 11, 3, 1, 59, 59, 999000000), ZoneOffset.ofHours(-7), ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneLosAngeles.nextTransition(ZonedDateTime.ofStrict(LocalDateTime.of(2013, 11, 3, 1, 59, 59, 999000000), ZoneOffset.ofHours(-7), ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli()), (long)ZonedDateTime.ofStrict(LocalDateTime.of(2013, 11, 3, 1, 0, 0, 0), ZoneOffset.ofHours(-8), ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneLosAngeles.nextTransition(ZonedDateTime.ofStrict(LocalDateTime.of(2013, 11, 3, 1, 0, 0, 0), ZoneOffset.ofHours(-8), ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli()), (long)ZonedDateTime.of(LocalDateTime.of(2014, 3, 9, 3, 0, 0, 0), ZoneId.of("America/Los_Angeles")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneBerlin.previousTransition(ZonedDateTime.of(2013, 3, 31, 1, 59, 59, 999000000, ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli()), (long)ZonedDateTime.ofStrict(LocalDateTime.of(2012, 10, 28, 2, 59, 59, 999000000), ZoneOffset.ofHours(2), ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneBerlin.previousTransition(ZonedDateTime.of(2013, 3, 31, 3, 0, 0, 0, ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli()), (long)ZonedDateTime.of(2013, 3, 31, 1, 59, 59, 999000000, ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneBerlin.nextTransition(ZonedDateTime.of(2013, 3, 31, 1, 59, 59, 999000000, ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli()), (long)ZonedDateTime.of(2013, 3, 31, 3, 0, 0, 0, ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneBerlin.nextTransition(ZonedDateTime.of(2013, 3, 31, 3, 0, 0, 0, ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli()), (long)ZonedDateTime.ofStrict(LocalDateTime.of(2013, 10, 27, 2, 0, 0, 0), ZoneOffset.ofHours(1), ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneBerlin.previousTransition(ZonedDateTime.ofStrict(LocalDateTime.of(2013, 10, 27, 2, 59, 59, 999000000), ZoneOffset.ofHours(2), ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli()), (long)ZonedDateTime.of(2013, 3, 31, 1, 59, 59, 999000000, ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneBerlin.previousTransition(ZonedDateTime.of(2013, 10, 27, 3, 0, 0, 0, ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli()), (long)ZonedDateTime.ofStrict(LocalDateTime.of(2013, 10, 27, 2, 59, 59, 999000000), ZoneOffset.ofHours(2), ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneBerlin.nextTransition(ZonedDateTime.ofStrict(LocalDateTime.of(2013, 10, 27, 2, 59, 59, 999000000), ZoneOffset.ofHours(2), ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli()), (long)ZonedDateTime.ofStrict(LocalDateTime.of(2013, 10, 27, 2, 0, 0, 0), ZoneOffset.ofHours(1), ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli());
        Assert.assertEquals((long)zoneBerlin.nextTransition(ZonedDateTime.ofStrict(LocalDateTime.of(2013, 10, 27, 2, 0, 0, 0), ZoneOffset.ofHours(1), ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli()), (long)ZonedDateTime.of(2014, 3, 30, 3, 0, 0, 0, ZoneId.of("Europe/Berlin")).toInstant().toEpochMilli());
    }

    @Test
    public void testGetOffsetFromLocal() {
        DateTimeZone zoneLosAngeles = DateTimeZone.forID((String)"America/Los_Angeles");
        Assert.assertEquals((int)zoneLosAngeles.getOffsetFromLocal(new org.joda.time.LocalDateTime(2013, 3, 10, 2, 30).toDateTime(DateTimeZone.UTC).toInstant().getMillis()), (int)-28800000);
        Assert.assertEquals((int)zoneLosAngeles.getOffsetFromLocal(new org.joda.time.LocalDateTime(2013, 11, 3, 1, 30).toDateTime(DateTimeZone.UTC).toInstant().getMillis()), (int)-25200000);
        DateTimeZone zoneBerlin = DateTimeZone.forID((String)"Europe/Berlin");
        Assert.assertEquals((int)zoneBerlin.getOffsetFromLocal(new org.joda.time.LocalDateTime(2013, 3, 31, 2, 30).toDateTime(DateTimeZone.UTC).toInstant().getMillis()), (int)3600000);
        Assert.assertEquals((int)zoneBerlin.getOffsetFromLocal(new org.joda.time.LocalDateTime(2013, 10, 27, 2, 30).toDateTime(DateTimeZone.UTC).toInstant().getMillis()), (int)0x6DDD00);
    }

    @Test
    public void testInstantiationOfAllZones() {
        DateTimeZone.forID((String)"-13:00");
        for (String zoneId : ZoneId.getAvailableZoneIds()) {
            if (zoneId.startsWith("Etc/") || zoneId.startsWith("GMT") || zoneId.startsWith("SystemV/") || zoneId.equals("Canada/East-Saskatchewan")) continue;
            DateTimeZone.forID((String)zoneId);
        }
        for (int offsetHours = -13; offsetHours < 14; ++offsetHours) {
            for (int offsetMinutes = 0; offsetMinutes < 60; ++offsetMinutes) {
                DateTimeZone.forOffsetHoursMinutes((int)offsetHours, (int)offsetMinutes);
            }
        }
    }
}

