/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import io.airlift.discovery.client.ForDiscoveryClient;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceDescriptorsRepresentation;
import io.airlift.discovery.client.ServiceInventoryConfig;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.weakref.jmx.Managed;

public class ServiceInventory {
    private static final Logger log = Logger.get(ServiceInventory.class);
    private final String environment;
    private final URI serviceInventoryUri;
    private final Duration updateInterval;
    private final NodeInfo nodeInfo;
    private final JsonCodec<ServiceDescriptorsRepresentation> serviceDescriptorsCodec;
    private final HttpClient httpClient;
    private final AtomicReference<List<ServiceDescriptor>> serviceDescriptors = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("service-inventory-%s").setDaemon(true).build());
    private final AtomicBoolean serverUp = new AtomicBoolean(true);
    private ScheduledFuture<?> scheduledFuture;

    @Inject
    public ServiceInventory(ServiceInventoryConfig config, NodeInfo nodeInfo, JsonCodec<ServiceDescriptorsRepresentation> serviceDescriptorsCodec, @ForDiscoveryClient HttpClient httpClient) {
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        Preconditions.checkNotNull(serviceDescriptorsCodec, (Object)"serviceDescriptorsCodec is null");
        Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
        this.nodeInfo = nodeInfo;
        this.environment = nodeInfo.getEnvironment();
        this.serviceInventoryUri = config.getServiceInventoryUri();
        this.updateInterval = config.getUpdateInterval();
        this.serviceDescriptorsCodec = serviceDescriptorsCodec;
        this.httpClient = httpClient;
        if (this.serviceInventoryUri != null) {
            String scheme = this.serviceInventoryUri.getScheme().toLowerCase();
            Preconditions.checkArgument((scheme.equals("http") || scheme.equals("https") || scheme.equals("file") ? 1 : 0) != 0, (Object)"Service inventory uri must have a http, https, or file scheme");
            try {
                this.updateServiceInventory();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
    }

    @PostConstruct
    public synchronized void start() {
        if (this.serviceInventoryUri == null || this.scheduledFuture != null) {
            return;
        }
        this.scheduledFuture = this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ServiceInventory.this.updateServiceInventory();
                }
                catch (Throwable e) {
                    log.error(e, "Unexpected exception from service inventory update", new Object[0]);
                }
            }
        }, (long)this.updateInterval.toMillis(), (long)this.updateInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    public Iterable<ServiceDescriptor> getServiceDescriptors() {
        return this.serviceDescriptors.get();
    }

    public Iterable<ServiceDescriptor> getServiceDescriptors(final String type) {
        return Iterables.filter(this.getServiceDescriptors(), (Predicate)new Predicate<ServiceDescriptor>(){

            public boolean apply(ServiceDescriptor serviceDescriptor) {
                return serviceDescriptor.getType().equals(type);
            }
        });
    }

    public Iterable<ServiceDescriptor> getServiceDescriptors(final String type, final String pool) {
        return Iterables.filter(this.getServiceDescriptors(), (Predicate)new Predicate<ServiceDescriptor>(){

            public boolean apply(ServiceDescriptor serviceDescriptor) {
                return serviceDescriptor.getType().equals(type) && serviceDescriptor.getPool().equals(pool);
            }
        });
    }

    @Managed
    public void updateServiceInventory() {
        if (this.serviceInventoryUri == null) {
            return;
        }
        try {
            ServiceDescriptorsRepresentation serviceDescriptorsRepresentation;
            if (this.serviceInventoryUri.getScheme().toLowerCase().startsWith("http")) {
                Request.Builder requestBuilder = Request.Builder.prepareGet().setUri(this.serviceInventoryUri).setHeader("User-Agent", this.nodeInfo.getNodeId());
                serviceDescriptorsRepresentation = (ServiceDescriptorsRepresentation)this.httpClient.execute(requestBuilder.build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(this.serviceDescriptorsCodec));
            } else {
                File file = new File(this.serviceInventoryUri);
                String json = Files.toString((File)file, (Charset)Charsets.UTF_8);
                serviceDescriptorsRepresentation = (ServiceDescriptorsRepresentation)this.serviceDescriptorsCodec.fromJson(json);
            }
            if (!this.environment.equals(serviceDescriptorsRepresentation.getEnvironment())) {
                this.logServerError("Expected environment to be %s, but was %s", this.environment, serviceDescriptorsRepresentation.getEnvironment());
            }
            ArrayList descriptors = Lists.newArrayList(serviceDescriptorsRepresentation.getServiceDescriptors());
            Collections.shuffle(descriptors);
            this.serviceDescriptors.set((List<ServiceDescriptor>)ImmutableList.copyOf((Collection)descriptors));
            if (this.serverUp.compareAndSet(false, true)) {
                log.info("ServiceInventory connect succeeded", new Object[0]);
            }
        }
        catch (Exception e) {
            this.logServerError("Error loading service inventory from %s", this.serviceInventoryUri.toASCIIString());
        }
    }

    private void logServerError(String message, Object ... args) {
        if (this.serverUp.compareAndSet(true, false)) {
            log.error(message, args);
        }
    }
}

