/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.discovery.client.ServiceDescriptor;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class ServiceDescriptorsRepresentation {
    private final String environment;
    private final List<ServiceDescriptor> serviceDescriptors;

    @JsonCreator
    public ServiceDescriptorsRepresentation(@JsonProperty(value="environment") String environment, @JsonProperty(value="services") List<ServiceDescriptor> serviceDescriptors) {
        Preconditions.checkNotNull(serviceDescriptors);
        this.environment = environment;
        this.serviceDescriptors = ImmutableList.copyOf(serviceDescriptors);
    }

    @JsonProperty
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="services")
    public List<ServiceDescriptor> getServiceDescriptors() {
        return this.serviceDescriptors;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ServiceDescriptorsRepresentation");
        sb.append("{environment='").append(this.environment).append('\'');
        sb.append(", serviceDescriptorList=").append(this.serviceDescriptors);
        sb.append('}');
        return sb.toString();
    }
}

